/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.data.wfs.internal.GetFeatureResponse;
import org.geotools.data.wfs.internal.GetParser;
import org.geotools.data.wfs.internal.parsers.EmfAppSchemaParser;

class WFSFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private SimpleFeature next;
    private GetParser<SimpleFeature> parser;
    private SimpleFeatureType featureType;
    private GetFeatureResponse response;

    public WFSFeatureReader(GetParser<SimpleFeature> parser, GetFeatureResponse response) throws IOException {
        this.response = response;
        this.parser = parser;
        this.next = parser.parse();
        if (this.next != null) {
            SimpleFeatureType parsedType = this.next.getFeatureType();
            this.featureType = parsedType instanceof SimpleFeatureType ? parsedType : EmfAppSchemaParser.toSimpleFeatureType((FeatureType)parsedType);
        }
    }

    public void close() throws IOException {
        GetParser<SimpleFeature> parser = this.parser;
        GetFeatureResponse response = this.response;
        this.parser = null;
        this.next = null;
        this.response = null;
        if (parser != null) {
            parser.close();
        }
        if (response != null) {
            response.dispose();
        }
    }

    public SimpleFeatureType getFeatureType() {
        if (this.featureType == null) {
            throw new IllegalStateException("No features were retrieved, shouldn't be calling getFeatureType()");
        }
        return this.featureType;
    }

    public boolean hasNext() throws IOException {
        return this.next != null;
    }

    public SimpleFeature next() throws IOException, NoSuchElementException {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        SimpleFeature current = this.next;
        this.next = this.parser.parse();
        return current;
    }
}

