/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MosaicDescriptor;
import org.geotools.api.coverage.Coverage;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CannotCropException;
import org.geotools.coverage.processing.EmptyIntersectionException;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.coverage.util.IntersectUtils;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;

public class Crop
extends Operation2D {
    private static final long serialVersionUID = 4466072819239413456L;
    public static final double EPS = 0.001;
    private static final GeometryFactory GFACTORY;
    public static final String PARAMNAME_ENVELOPE = "Envelope";
    public static final String PARAMNAME_ROI = "ROI";
    public static final String PARAMNAME_ROITOLERANCE = "ROITolerance";
    public static final String PARAMNAME_FORCEMOSAIC = "ForceMosaic";
    public static final String PARAMNAME_NODATA = "NoData";
    public static final String PARAMNAME_DEST_NODATA = "destNoData";
    public static final ParameterDescriptor<Bounds> CROP_ENVELOPE;
    public static final ParameterDescriptor<Geometry> CROP_ROI;
    public static final ParameterDescriptor<Double> ROI_OPTIMISATION_TOLERANCE;
    public static final ParameterDescriptor<Boolean> FORCE_MOSAIC;
    public static final ParameterDescriptor<Range> NODATA;
    public static final ParameterDescriptor<double[]> DEST_NODATA;

    public Crop() {
        super(new DefaultParameterDescriptorGroup(Citations.JAI, "CoverageCrop", (GeneralParameterDescriptor[])new ParameterDescriptor[]{SOURCE_0, CROP_ENVELOPE, CROP_ROI, ROI_OPTIMISATION_TOLERANCE, FORCE_MOSAIC, NODATA, DEST_NODATA}));
    }

    @Override
    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) {
        Polygon jis;
        Geometry cropRoi;
        GeneralBounds cropEnvelope = null;
        double roiTolerance = parameters.parameter(PARAMNAME_ROITOLERANCE).doubleValue();
        boolean forceMosaic = parameters.parameter(PARAMNAME_FORCEMOSAIC).booleanValue();
        Range nodata = (Range)parameters.parameter(PARAMNAME_NODATA).getValue();
        double[] destnodata = (double[])parameters.parameter(PARAMNAME_DEST_NODATA).getValue();
        ParameterValue sourceParameter = parameters.parameter("Source");
        if (sourceParameter == null || !(sourceParameter.getValue() instanceof GridCoverage2D)) {
            throw new CannotCropException(MessageFormat.format("\"{0}\" parameter should be not null and of type \"{1}\".", "Source", GridCoverage2D.class.toString()));
        }
        GridCoverage2D source = (GridCoverage2D)((Object)sourceParameter.getValue());
        if (nodata == null) {
            NoDataContainer noDataProperty = CoverageUtilities.getNoDataProperty(source);
            nodata = noDataProperty != null ? noDataProperty.getAsRange() : null;
        }
        ParameterValue envelopeParameter = parameters.parameter(PARAMNAME_ENVELOPE);
        ParameterValue roiParameter = parameters.parameter(PARAMNAME_ROI);
        if (!(envelopeParameter != null && envelopeParameter.getValue() != null || roiParameter != null && roiParameter.getValue() != null)) {
            throw new CannotCropException(MessageFormat.format("\"{0}\" parameter should be not null and of type \"{1}\".", PARAMNAME_ENVELOPE, GeneralBounds.class.toString()));
        }
        Object envelope = envelopeParameter.getValue();
        if (envelope != null) {
            if (envelope instanceof GeneralBounds) {
                cropEnvelope = (GeneralBounds)envelope;
            } else if (envelope instanceof Bounds) {
                cropEnvelope = new GeneralBounds((Bounds)envelope);
            }
        }
        try {
            cropRoi = IntersectUtils.unrollGeometries((Geometry)roiParameter.getValue());
        }
        catch (IllegalArgumentException ex) {
            String arg1 = ex.getMessage();
            throw new CannotCropException(MessageFormat.format("Illegal argument: \"{0}={1}\".", PARAMNAME_ROI, arg1), ex);
        }
        if (cropRoi != null && cropEnvelope == null) {
            ReferencedEnvelope e2d = new ReferencedEnvelope(cropRoi.getEnvelopeInternal(), source.getCoordinateReferenceSystem());
            cropEnvelope = new GeneralBounds((Bounds)e2d);
        }
        ReferencedEnvelope sourceEnvelope = source.getEnvelope2D();
        ReferencedEnvelope destinationEnvelope = new ReferencedEnvelope((Bounds)cropEnvelope);
        CoordinateReferenceSystem sourceCRS = sourceEnvelope.getCoordinateReferenceSystem();
        CoordinateReferenceSystem destinationCRS = destinationEnvelope.getCoordinateReferenceSystem();
        if (destinationCRS == null) {
            ReferencedEnvelope ge = new ReferencedEnvelope(destinationEnvelope);
            destinationCRS = source.getCoordinateReferenceSystem2D();
            ge.setCoordinateReferenceSystem(destinationCRS);
            destinationEnvelope = ge;
        }
        if (!CRS.equalsIgnoreMetadata(sourceCRS, destinationCRS)) {
            String arg0 = sourceCRS.getName().getCode();
            String arg1 = destinationCRS.getName().getCode();
            throw new CannotCropException(MessageFormat.format("The envelope uses an incompatible CRS: was \"{1}\" while we expected \"{0}\".", arg0, arg1));
        }
        GeneralBounds intersectionEnvelope = new GeneralBounds((Bounds)destinationEnvelope);
        intersectionEnvelope.setCoordinateReferenceSystem(source.getCoordinateReferenceSystem());
        intersectionEnvelope.intersect((Bounds)sourceEnvelope);
        if (intersectionEnvelope.isEmpty()) {
            throw new EmptyIntersectionException("Crop envelope does not intersect in model space");
        }
        if (cropRoi != null && !IntersectUtils.intersects(cropRoi, (Geometry)(jis = JTS.toGeometry((Envelope)new ReferencedEnvelope((Bounds)intersectionEnvelope))))) {
            throw new CannotCropException("An error occurred while cropping.");
        }
        ROI internalROI = CoverageUtilities.getROIProperty(source);
        AffineTransform sourceCornerGridToWorld = (AffineTransform)source.getGridGeometry().getGridToCRS(PixelInCell.CELL_CORNER);
        double tolerance = XAffineTransform.getScale(sourceCornerGridToWorld);
        if (cropRoi != null || !intersectionEnvelope.equals((Bounds)sourceEnvelope, tolerance / 2.0, false)) {
            cropEnvelope = intersectionEnvelope.clone();
            return Crop.buildResult(internalROI, nodata, destnodata, cropEnvelope, cropRoi, roiTolerance, forceMosaic, hints instanceof Hints ? hints : new Hints((RenderingHints)hints), source, sourceCornerGridToWorld);
        }
        return source;
    }

    private static GridCoverage2D buildResult(ROI internalROI, Range nodata, double[] destnodata, GeneralBounds cropEnvelope, Geometry cropROI, double roiTolerance, boolean forceMosaic, Hints hints, GridCoverage2D sourceCoverage, AffineTransform sourceGridToWorldTransform) {
        RenderedImage sourceImage = sourceCoverage.getRenderedImage();
        GridGeometry2D sourceGridGeometry = sourceCoverage.getGridGeometry();
        GridEnvelope2D sourceGridRange = sourceGridGeometry.getGridRange2D();
        boolean isSimpleTransform = CoverageUtilities.isSimpleGridToWorldTransform(sourceGridToWorldTransform, 0.001);
        boolean actionTaken = false;
        RenderingHints targetHints = new RenderingHints(null);
        if (hints != null) {
            targetHints.add((RenderingHints)hints);
        }
        ImageLayout layout = Crop.initLayout(sourceImage, targetHints);
        targetHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        try {
            if (cropROI != null) {
                try {
                    Polygon modelSpaceROI = FeatureUtilities.getPolygon(cropEnvelope, GFACTORY);
                    Geometry intersection = IntersectUtils.intersection(cropROI, (Geometry)modelSpaceROI);
                    ReferencedEnvelope e2d = ReferencedEnvelope.envelope((Envelope)intersection.getEnvelopeInternal(), (CoordinateReferenceSystem)cropEnvelope.getCoordinateReferenceSystem());
                    GeneralBounds ge = new GeneralBounds((Bounds)e2d);
                    cropEnvelope.setEnvelope(ge);
                }
                catch (TopologyException e) {
                    Envelope cropROIEnvelope = cropROI.getEnvelopeInternal();
                    Envelope intersection = cropROIEnvelope.intersection((Envelope)ReferencedEnvelope.reference((Bounds)cropEnvelope));
                    cropEnvelope.setEnvelope(new GeneralBounds((Bounds)new ReferencedEnvelope(intersection, cropEnvelope.getCoordinateReferenceSystem())));
                }
            }
            AffineTransform sourceWorldToGridTransform = sourceGridToWorldTransform.createInverse();
            Rectangle2D finalRasterAreaDouble = XAffineTransform.transform(sourceWorldToGridTransform, cropEnvelope.toRectangle2D(), null);
            Rectangle finalRasterArea = finalRasterAreaDouble.getBounds();
            Rectangle.intersect(finalRasterArea, sourceGridRange, finalRasterArea);
            if (finalRasterArea.isEmpty()) {
                throw new EmptyIntersectionException("Crop envelope intersects in model space, but not in raster space");
            }
            if (finalRasterArea.equals(sourceGridRange) && isSimpleTransform && cropROI == null) {
                return sourceCoverage;
            }
            double minX = finalRasterArea.getMinX();
            double minY = finalRasterArea.getMinY();
            double width = finalRasterArea.getWidth();
            double height = finalRasterArea.getHeight();
            ImageWorker worker = new ImageWorker();
            java.awt.Polygon rasterSpaceROI = null;
            double[] background = destnodata;
            if (background == null) {
                background = CoverageUtilities.getBackgroundValues(sourceCoverage);
            }
            String operatioName = null;
            if (!isSimpleTransform || cropROI != null) {
                Polygon modelSpaceROI = FeatureUtilities.getPolygon(cropEnvelope, GFACTORY);
                ArrayList<Point2D> points = new ArrayList<Point2D>(5);
                rasterSpaceROI = FeatureUtilities.convertPolygonToPointArray(modelSpaceROI, ProjectiveTransform.create(sourceWorldToGridTransform), points);
                if (isSimpleTransform && cropROI == null) {
                    rasterSpaceROI = Crop.rectangleToPolygon(finalRasterArea);
                }
                if ((rasterSpaceROI == null || rasterSpaceROI.getBounds().isEmpty()) && finalRasterArea.isEmpty()) {
                    throw new CannotCropException("An error occurred while cropping.");
                }
                if (forceMosaic || cropROI != null || internalROI != null || nodata != null) {
                    Range[] rangeArray;
                    ROI[] roiarr = null;
                    if (cropROI != null) {
                        Geometry txROI = JTS.transform((Geometry)cropROI, (MathTransform)ProjectiveTransform.create(sourceWorldToGridTransform));
                        if (!Crop.hasIntegerBounds(JTS.toRectangle2D((Envelope)txROI.getEnvelopeInternal()))) {
                            Crop.transformGeometry(txROI);
                        }
                        try {
                            if (!txROI.contains(JTS.toGeometry((Shape)finalRasterArea))) {
                                ROI cropRS = Crop.getAsROI(txROI);
                                roiarr = new ROI[]{cropRS};
                            }
                        }
                        catch (TopologyException e) {
                            ROI cropRS = Crop.getAsROI(txROI);
                            roiarr = new ROI[]{cropRS};
                        }
                    } else if (forceMosaic) {
                        ROI roi = Crop.getAsROI((Geometry)JTS.toPolygon((java.awt.Polygon)rasterSpaceROI));
                        roiarr = new ROI[]{roi};
                    }
                    if (roiarr != null && roiarr[0].getBounds().isEmpty()) {
                        throw new CannotCropException("An error occurred while cropping.");
                    }
                    worker.setBackground(background);
                    worker.setNoData(nodata);
                    Rectangle bounds = rasterSpaceROI.getBounds2D().getBounds();
                    Rectangle.intersect(bounds, sourceGridRange, bounds);
                    if (bounds.isEmpty()) {
                        throw new CannotCropException("An error occurred while cropping.");
                    }
                    if (!forceMosaic && bounds.getBounds().equals(sourceGridRange) && isSimpleTransform && nodata == null && roiarr == null) {
                        return sourceCoverage;
                    }
                    Rectangle boundsInt = bounds.getBounds();
                    layout.setMinX(boundsInt.x);
                    layout.setWidth(boundsInt.width);
                    layout.setMinY(boundsInt.y);
                    layout.setHeight(boundsInt.height);
                    operatioName = "Mosaic";
                    worker.setRenderingHints(targetHints);
                    RenderedImage[] renderedImageArray = new RenderedImage[]{sourceImage};
                    if (nodata != null) {
                        Range[] rangeArray2 = new Range[1];
                        rangeArray = rangeArray2;
                        rangeArray2[0] = nodata;
                    } else {
                        rangeArray = null;
                    }
                    worker.mosaic(renderedImageArray, MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, roiarr, null, rangeArray);
                }
            }
            if (operatioName == null) {
                worker.setImage(sourceImage);
                worker.setNoData(nodata);
                worker.setRenderingHints(targetHints);
                worker.crop((float)minX, (float)minY, (float)width, (float)height);
                operatioName = "Crop";
            }
            PlanarImage croppedImage = worker.getPlanarImage();
            Map sourceProperties = sourceCoverage.getProperties();
            HashMap<String, Object> properties = null;
            if (sourceProperties != null && !sourceProperties.isEmpty()) {
                properties = new HashMap<String, Object>(sourceProperties);
            }
            if (worker.getROI() != null && !worker.getROI().contains(croppedImage.getBounds())) {
                if (properties == null) {
                    properties = new HashMap();
                }
                CoverageUtilities.setROIProperty(properties, worker.getROI());
            } else if (rasterSpaceROI != null || internalROI != null) {
                ROI finalROI = null;
                if (rasterSpaceROI != null) {
                    finalROI = Crop.getAsROI((Geometry)JTS.toPolygon((java.awt.Polygon)rasterSpaceROI));
                }
                if (finalROI != null && internalROI != null) {
                    finalROI = finalROI.intersect(internalROI);
                } else if (internalROI != null) {
                    finalROI = internalROI;
                }
                if (properties == null) {
                    properties = new HashMap();
                }
                if (finalROI != null) {
                    CoverageUtilities.setROIProperty(properties, finalROI);
                }
            }
            if (worker.getNoData() != null) {
                if (properties == null) {
                    properties = new HashMap();
                }
                CoverageUtilities.setNoDataProperty(properties, worker.getNoData());
            }
            return new GridCoverageFactory(hints).create((CharSequence)sourceCoverage.getName(), (RenderedImage)croppedImage, new GridGeometry2D(new GridEnvelope2D(croppedImage.getBounds()), (MathTransform)sourceGridGeometry.getGridToCRS2D(PixelOrientation.CENTER), sourceCoverage.getCoordinateReferenceSystem()), actionTaken ? null : (GridSampleDimension[])sourceCoverage.getSampleDimensions().clone(), new GridCoverage[]{sourceCoverage}, properties);
        }
        catch (NoninvertibleTransformException | TransformException e) {
            throw new CannotCropException("An error occurred while cropping.", e);
        }
    }

    private static boolean hasIntegerBounds(Rectangle2D rt) {
        if (rt == null || rt.isEmpty()) {
            return true;
        }
        double minx = rt.getMinX();
        double miny = rt.getMinY();
        double maxx = rt.getMaxX();
        double maxy = rt.getMaxY();
        return minx % 1.0 == 0.0 && miny % 1.0 == 0.0 && maxx % 1.0 == 0.0 && maxy % 1.0 == 0.0;
    }

    private static void transformGeometry(Geometry geometry) {
        if (geometry == null) {
            return;
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geometry;
            for (int i = 0; i < collection.getNumGeometries(); ++i) {
                Crop.transformGeometry(collection.getGeometryN(i));
            }
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            Crop.transformGeometry((Geometry)polygon.getExteriorRing());
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                Crop.transformGeometry((Geometry)polygon.getInteriorRingN(i));
            }
        } else if (geometry instanceof LineString) {
            CoordinateSequence cs = ((LineString)geometry).getCoordinateSequence();
            for (int i = 0; i < cs.size(); ++i) {
                cs.setOrdinate(i, 0, (double)((int)(cs.getOrdinate(i, 0) + 0.5)));
                cs.setOrdinate(i, 1, (double)((int)(cs.getOrdinate(i, 1) + 0.5)));
            }
        }
        geometry.geometryChanged();
    }

    private static ImageLayout initLayout(RenderedImage sourceImage, RenderingHints hints) {
        ImageLayout layout = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT);
        if (layout != null) {
            layout = (ImageLayout)layout.clone();
        } else {
            layout = new ImageLayout(sourceImage);
            layout.unsetTileLayout();
        }
        if ((layout.getValidMask() & 0xF0) == 0) {
            layout.setTileGridXOffset(layout.getMinX(sourceImage));
            layout.setTileGridYOffset(layout.getMinY(sourceImage));
            int width = layout.getWidth(sourceImage);
            int height = layout.getHeight(sourceImage);
            if (layout.getTileWidth(sourceImage) > width) {
                layout.setTileWidth(width);
            }
            if (layout.getTileHeight(sourceImage) > height) {
                layout.setTileHeight(height);
            }
        }
        return layout;
    }

    public static java.awt.Polygon rectangleToPolygon(Rectangle rect) {
        java.awt.Polygon result = new java.awt.Polygon();
        result.addPoint(rect.x, rect.y);
        result.addPoint(rect.x + rect.width, rect.y);
        result.addPoint(rect.x + rect.width, rect.y + rect.height);
        result.addPoint(rect.x, rect.y + rect.height);
        return result;
    }

    private static ROI getAsROI(Geometry theGeom) {
        Envelope env = theGeom.getEnvelopeInternal();
        int x = (int)Math.floor(env.getMinX());
        int y = (int)Math.floor(env.getMinY());
        int w = (int)Math.ceil(env.getMaxX()) - x;
        int h = (int)Math.ceil(env.getMaxY()) - y;
        ParameterBlockJAI pb = new ParameterBlockJAI("VectorBinarize");
        pb.setParameter("minx", x);
        pb.setParameter("miny", y);
        pb.setParameter("width", w);
        pb.setParameter("height", h);
        pb.setParameter("geometry", (Object)PreparedGeometryFactory.prepare((Geometry)theGeom));
        pb.setParameter("antiAliasing", true);
        RenderedOp roiImage = JAI.create((String)"VectorBinarize", (ParameterBlock)pb, null);
        return new ROI((RenderedImage)roiImage);
    }

    static {
        Hints defaultHints = GeoTools.getDefaultHints();
        Object o = defaultHints.get((Object)Hints.JTS_PRECISION_MODEL);
        PrecisionModel pm = o != null ? (PrecisionModel)o : new PrecisionModel();
        GFACTORY = new GeometryFactory(pm, 0);
        CROP_ENVELOPE = new DefaultParameterDescriptor<Object>(Citations.GEOTOOLS, PARAMNAME_ENVELOPE, Bounds.class, null, null, null, null, null, true);
        CROP_ROI = new DefaultParameterDescriptor<Object>(Citations.JAI, PARAMNAME_ROI, Geometry.class, null, null, null, null, null, true);
        ROI_OPTIMISATION_TOLERANCE = new DefaultParameterDescriptor<Double>(Citations.GEOTOOLS, PARAMNAME_ROITOLERANCE, Double.class, null, 0.6, Double.valueOf(0.0), Double.valueOf(1.0), null, true);
        FORCE_MOSAIC = new DefaultParameterDescriptor<Boolean>(Citations.GEOTOOLS, PARAMNAME_FORCEMOSAIC, Boolean.class, null, false, null, null, null, true);
        NODATA = new DefaultParameterDescriptor<Object>(Citations.JAI, PARAMNAME_NODATA, Range.class, null, null, null, null, null, true);
        DEST_NODATA = new DefaultParameterDescriptor<Object>(Citations.JAI, PARAMNAME_DEST_NODATA, double[].class, null, null, null, null, null, true);
    }
}

