/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.ask;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.i18n.MessageFactory;
import nz.org.riskscape.engine.i18n.TranslationContext;
import nz.org.riskscape.engine.types.Floating;
import nz.org.riskscape.engine.types.Integer;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.CliChoice;
import nz.org.riskscape.wizard.CliPrompter;
import nz.org.riskscape.wizard.ExpressionHelper;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.ask.AskRequest;
import nz.org.riskscape.wizard.ask.BaseAsker;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;

public class ExpressionAsker
extends BaseAsker {
    private final List<String> allowedExpressionTypes;
    protected final Messages expressionMessages;

    public ExpressionAsker(TranslationContext messageSource, List<String> allowedExpressionTypes) {
        super(messageSource);
        this.allowedExpressionTypes = allowedExpressionTypes;
        this.expressionMessages = (Messages)messageSource.newFactory(Messages.class);
    }

    protected List<CliChoice<ExpressionHelper.AttributeMetadata>> getAttributeChoices(List<Class<? extends Type>> allowedTypes, ExpressionHelper helper) {
        return helper.getAttributeMetadata(allowedTypes).stream().map(attr -> new CliChoice<ExpressionHelper.AttributeMetadata>(attr.getFullyQualifiedName(), (ExpressionHelper.AttributeMetadata)attr)).collect(Collectors.toList());
    }

    protected List<CliChoice<String>> getValueChoices(ExpressionHelper.AttributeMetadata member, ExpressionHelper helper) {
        List values = helper.getValues(member);
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        List<CliChoice<String>> choiceValues = values.stream().map(s -> new CliChoice<String>(s.getLabel(), Objects.toString(s.getValue()))).collect(Collectors.toList());
        return choiceValues;
    }

    protected String askInteractively(CliPrompter cliPrompter, ExpressionHelper helper) {
        ArrayList<Class<? extends Type>> allowedTypes = new ArrayList<Class<? extends Type>>();
        if ("numeric".equals(helper.getExpressionType().orElse(""))) {
            allowedTypes.add(Integer.class);
            allowedTypes.add(Floating.class);
        }
        CliChoice targetAttr = cliPrompter.choose(this.expressionMessages.chooseAttribute(), this.getAttributeChoices(allowedTypes, helper));
        return ((ExpressionHelper.AttributeMetadata)targetAttr.data).getFullyQualifiedName();
    }

    @Override
    public boolean canAsk(IncrementalBuildState buildState, Question question) {
        return Expression.class.isAssignableFrom(question.getParameterType()) && this.getAllowedExpressionTypes().size() > 0 && this.getAllowedExpressionTypes().contains(question.getAnnotation("expression-helper-expression-type").orElse(null)) && ExpressionHelper.create((IncrementalBuildState)buildState, (Question)question).isPresent();
    }

    @Override
    public ResultOrProblems<Answer.Response> ask(AskRequest input) {
        CliPrompter prompter = input.getCliPrompter();
        IncrementalBuildState state = input.getBuildState();
        Question question = input.getQuestion();
        ExpressionHelper helper = (ExpressionHelper)ExpressionHelper.create((IncrementalBuildState)state, (Question)question).get();
        prompter.getOut().printlnMarkup(question.getDescription(prompter.getLocale()).orElse(question.getId())).println();
        String expressionString = null;
        switch ((AnswerType)((Object)prompter.choose((String)this.expressionMessages.answerType((String)this.getAnswerTypeLabel((ExpressionHelper)helper)), this.getChoices(AnswerType.class)).data)) {
            case CUSTOM: {
                expressionString = prompter.readlineWithTitle(this.expressionMessages.enterExpression(this.getAnswerTypeLabel(helper)));
                break;
            }
            case INTERACTIVELY: {
                expressionString = this.askInteractively(prompter, helper);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled choice");
            }
        }
        return Answer.bind((BindingContext)input.getBindingContext(), (Question)question, (Object)expressionString);
    }

    private String getAnswerTypeLabel(ExpressionHelper helper) {
        switch (helper.getExpressionType().orElse("")) {
            case "boolean": {
                return "true/false value";
            }
            case "numeric": {
                return "number";
            }
        }
        throw new RuntimeException("Unhandled expression type: " + String.valueOf(helper.getExpressionType()));
    }

    @Generated
    protected List<String> getAllowedExpressionTypes() {
        return this.allowedExpressionTypes;
    }

    public static interface Messages
    extends MessageFactory {
        public String chooseAttribute();

        public String answerType(String var1);

        public String enterExpression(String var1);
    }

    public static enum AnswerType {
        INTERACTIVELY,
        CUSTOM;

    }
}

