/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.ask;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.i18n.MessageFactory;
import nz.org.riskscape.engine.i18n.TranslationContext;
import nz.org.riskscape.engine.types.Enumeration;
import nz.org.riskscape.engine.types.Floating;
import nz.org.riskscape.engine.types.Integer;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Text;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.CliChoice;
import nz.org.riskscape.wizard.CliPrompter;
import nz.org.riskscape.wizard.ExpressionHelper;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.ask.AskRequest;
import nz.org.riskscape.wizard.ask.ExpressionAsker;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;

public class BooleanExpressionAsker
extends ExpressionAsker {
    public static final int DEFAULT_PAGE_SIZE = 20;
    private static final CliChoice<String> NEXT_PAGE = new CliChoice<String>("Show more choices", "m", "NEXT PAGE");
    private static final CliChoice<String> PREV_PAGE = new CliChoice<String>("Show previous choices", "p", "PREV PAGE");
    private final int pageSize;
    private final Messages messages;

    public BooleanExpressionAsker(TranslationContext messageSource) {
        this(messageSource, 20);
    }

    BooleanExpressionAsker(TranslationContext messageSource, int pageSize) {
        super(messageSource, Lists.newArrayList((Object[])new String[]{"boolean"}));
        this.pageSize = pageSize;
        this.messages = (Messages)messageSource.newFactory(Messages.class);
    }

    @Override
    protected String askInteractively(CliPrompter cliPrompter, ExpressionHelper helper) {
        cliPrompter.println(this.messages.byAttributeDisclaimer());
        CliChoice targetAttr = cliPrompter.choose(this.expressionMessages.chooseAttribute(), this.getAttributeChoices(Lists.newArrayList((Object[])new Class[]{Text.class, Integer.class, Floating.class, Enumeration.class}), helper));
        boolean numericType = Nullable.unwrap((Type)((ExpressionHelper.AttributeMetadata)targetAttr.data).getType()).isNumeric();
        boolean textType = Nullable.unwrap((Type)((ExpressionHelper.AttributeMetadata)targetAttr.data).getType()).internalType().equals(String.class);
        List choices = this.enumTranslator.getEntries(Comparison.class).stream().filter(e -> ((Comparison)e.getValue()).applicableTo(numericType)).map(e -> new CliChoice<Comparison>(e.getLabelOr(((Comparison)e.getValue()).getOperator(), new Object[0]), (Comparison)e.getValue())).collect(Collectors.toList());
        Comparison comparison = (Comparison)((Object)cliPrompter.choose((String)this.messages.chooseComparison(), choices).data);
        List<Object> knownChoices = comparison.isEquality() ? this.getValueChoices((ExpressionHelper.AttributeMetadata)targetAttr.data, helper) : Collections.emptyList();
        ArrayList attributeValues = new ArrayList();
        Function<String, Boolean> attributeAnswerProcessor = attributeValue -> {
            attributeValues.add(textType ? TokenTypes.quoteTextIfNeeded((String)attributeValue) : attributeValue);
            if (comparison != Comparison.EQUAL && comparison != Comparison.NOT_EQUAL) {
                return true;
            }
            boolean addMore = (Boolean)cliPrompter.choose((String)this.messages.addAnotherValue(), CliPrompter.YES_NO_CHOICES).data;
            return !addMore;
        };
        if (knownChoices.isEmpty()) {
            this.doTextEntry(cliPrompter, attributeAnswerProcessor);
        } else {
            int valueCount = knownChoices.size();
            if (valueCount <= this.pageSize) {
                this.doListEntry(knownChoices, cliPrompter, attributeAnswerProcessor);
            } else {
                switch ((ValueEntryMode)((Object)cliPrompter.choose((String)this.messages.tooManyChoices((int)valueCount), this.getChoices(ValueEntryMode.class)).data)) {
                    case PAGED_LIST: {
                        this.doPagedListEntry(knownChoices, cliPrompter, attributeAnswerProcessor);
                        break;
                    }
                    default: {
                        this.doTextEntry(cliPrompter, attributeAnswerProcessor);
                    }
                }
            }
        }
        String joiner = " or ";
        if (comparison == Comparison.NOT_EQUAL) {
            joiner = " and ";
        }
        return attributeValues.stream().map(value -> String.format("%s %s %s", ((ExpressionHelper.AttributeMetadata)targetAttr.data).getFullyQualifiedName(), comparison.getOperator(), value)).collect(Collectors.joining(joiner));
    }

    private void doTextEntry(CliPrompter cliPrompter, Function<String, Boolean> attributeAnswerProcessor) {
        while (!attributeAnswerProcessor.apply(cliPrompter.readlineWithTitle(this.messages.enterValue())).booleanValue()) {
        }
    }

    private void doListEntry(List<CliChoice<String>> choices, CliPrompter cliPrompter, Function<String, Boolean> attributeAnswerProcessor) {
        while (!attributeAnswerProcessor.apply((String)cliPrompter.choose((String)this.messages.chooseValue(), choices).data).booleanValue()) {
        }
    }

    private void doPagedListEntry(List<CliChoice<String>> choices, CliPrompter cliPrompter, Function<String, Boolean> attributeAnswerProcessor) {
        int page = 0;
        while (true) {
            CliChoice choosen;
            int fromIdx = page * this.pageSize;
            int toIndex = Math.min(fromIdx + this.pageSize, choices.size());
            ArrayList choicesPage = Lists.newArrayList(choices.subList(fromIdx, toIndex));
            if (fromIdx > 0) {
                choicesPage.add(PREV_PAGE);
            }
            if (toIndex < choices.size()) {
                choicesPage.add(NEXT_PAGE);
            }
            if ((choosen = cliPrompter.choose(this.messages.chooseValue(), choicesPage)) == NEXT_PAGE) {
                ++page;
                continue;
            }
            if (choosen == PREV_PAGE) {
                --page;
                continue;
            }
            if (attributeAnswerProcessor.apply((String)choosen.data).booleanValue()) break;
        }
    }

    @Override
    public ResultOrProblems<Answer.Response> ask(AskRequest input) {
        CliPrompter prompter = input.getCliPrompter();
        IncrementalBuildState state = input.getBuildState();
        Question question = input.getQuestion();
        ExpressionHelper helper = (ExpressionHelper)ExpressionHelper.create((IncrementalBuildState)state, (Question)question).get();
        prompter.println(prompter.getPrompt(question));
        return Answer.bind((BindingContext)state.getBindingContext(), (Question)question, (Object)this.askInteractively(prompter, helper));
    }

    public static interface Messages
    extends MessageFactory {
        public String chooseComparison();

        public String addAnotherValue();

        public String tooManyChoices(int var1);

        public String enterValue();

        public String chooseValue();

        public String byAttributeDisclaimer();
    }

    public static enum Comparison {
        EQUAL("=", false),
        NOT_EQUAL("!=", false),
        LESS_THAN("<", true),
        LESS_THAN_EQUAL("<=", true),
        GREATER_THAN(">", true),
        GREATER_THAN_EQUAL(">=", true);

        private final String operator;
        private final boolean numericOnly;

        boolean applicableTo(boolean numericType) {
            if (this.numericOnly) {
                return numericType;
            }
            return true;
        }

        boolean isEquality() {
            return this == EQUAL || this == NOT_EQUAL;
        }

        @Generated
        private Comparison(String operator, boolean numericOnly) {
            this.operator = operator;
            this.numericOnly = numericOnly;
        }

        @Generated
        public String getOperator() {
            return this.operator;
        }
    }

    public static enum ValueEntryMode {
        ENTER_VALUE,
        PAGED_LIST;

    }
}

