/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.ask;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.i18n.EnumTranslator;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.i18n.TranslationContext;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.Choice;
import nz.org.riskscape.wizard.CliChoice;
import nz.org.riskscape.wizard.CliPrompter;
import nz.org.riskscape.wizard.ask.AskRequest;
import nz.org.riskscape.wizard.ask.Asker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAsker
implements Asker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAsker.class);
    protected final TranslationContext translationContext;
    protected final EnumTranslator enumTranslator;

    public BaseAsker(TranslationContext context) {
        this.translationContext = context;
        this.enumTranslator = new EnumTranslator(context);
    }

    protected <T extends Enum<?>> List<CliChoice<T>> getChoices(Class<T> enumClass) {
        return this.enumTranslator.getEntries(enumClass).stream().map(e -> this.toChoice((EnumTranslator.EnumEntry)e)).toList();
    }

    protected <T extends Enum<?>> CliChoice<T> toChoice(EnumTranslator.EnumEntry<T> entry) {
        return new CliChoice<Enum>(entry.getLabel(new Object[0]), entry.getValue());
    }

    protected String getMessage(String suffix, Object ... args) {
        return this.getOptionalMessage(suffix, args).orElseGet(() -> {
            log.warn("Failed i18n lookup for class {} and suffix {}", this.getClass(), (Object)suffix);
            return "???" + this.getClass().getName() + "." + suffix + "???";
        });
    }

    protected Optional<String> getOptionalMessage(String suffix, Object ... args) {
        Class<?> ptr = this.getClass();
        while (!ptr.equals(Object.class)) {
            String code = ptr.getCanonicalName() + "." + suffix;
            String resolved = this.translationContext.getMessage(code, args);
            if (resolved != null) {
                return Optional.of(resolved);
            }
            code = ptr.getSimpleName() + "." + suffix;
            resolved = this.translationContext.getMessage(code, args);
            if (resolved != null) {
                return Optional.of(resolved);
            }
            ptr = ptr.getSuperclass();
        }
        return Optional.empty();
    }

    public abstract ResultOrProblems<Answer.Response> ask(AskRequest var1);

    @Override
    public ResultOrProblems<Object> askUnbound(AskRequest input) {
        return this.ask(input).map(r -> r.getOriginalInput());
    }

    protected Locale getLocale() {
        return this.translationContext.getLocale();
    }

    protected MessageSource getMessageSource() {
        return this.translationContext.getMessageSource();
    }

    public Choice pickChoice(List<Choice> choices, CliPrompter prompter, CommandLine.Help.Ansi.Text prompt) {
        CliChoice chosen = prompter.choose(prompt, choices.stream().map(c -> this.toChoice((Choice)c)).toList());
        return (Choice)chosen.data;
    }

    private CliChoice<Choice> toChoice(Choice choice) {
        return new CliChoice<Choice>(choice.getLabel(this.translationContext), choice).subtitled(choice.getDescription(this.translationContext));
    }
}

