/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.ask;

import java.util.Optional;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.i18n.MessageFactory;
import nz.org.riskscape.engine.i18n.TranslationContext;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.PropertyAccess;
import nz.org.riskscape.rl.ast.StructDeclaration;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.Choice;
import nz.org.riskscape.wizard.CliPrompter;
import nz.org.riskscape.wizard.ExpressionHelper;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.ask.AskRequest;
import nz.org.riskscape.wizard.ask.BaseAsker;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;

public class AttributeAsker
extends BaseAsker {
    private final Messages messages;

    public AttributeAsker(TranslationContext context) {
        super(context);
        this.messages = (Messages)context.newFactory(Messages.class);
    }

    @Override
    public boolean canAsk(IncrementalBuildState buildState, Question question) {
        return StructDeclaration.class.isAssignableFrom(question.getParameterType()) || PropertyAccess.class.isAssignableFrom(question.getParameterType());
    }

    @Override
    public ResultOrProblems<Answer.Response> ask(AskRequest request) {
        String newName;
        String expression;
        Question question = request.getQuestion();
        CliPrompter prompter = request.getCliPrompter();
        Choice choice = this.pickChoice(question.getChoices(request.getBuildState()), prompter, prompter.getPrompt(request.getQuestion()));
        Optional metadata = choice.isA(ExpressionHelper.AttributeMetadata.class);
        if (metadata.isPresent()) {
            ExpressionHelper.AttributeMetadata targetAttr = (ExpressionHelper.AttributeMetadata)metadata.get();
            expression = targetAttr.getFullyQualifiedName();
            newName = targetAttr.getName();
        } else {
            expression = choice.getValue();
            newName = choice.getLabel(this.translationContext);
        }
        boolean hasName = StructDeclaration.class.isAssignableFrom(question.getParameterType());
        if (hasName) {
            if (((Boolean)prompter.choose((String)this.messages.renameYesNo(), CliPrompter.YES_NO_CHOICES).data).booleanValue()) {
                newName = prompter.readlineWithTitle(this.messages.enterNewName());
            }
            expression = String.format("%s as %s", expression, TokenTypes.quoteIdent((String)newName));
        }
        return Answer.bind((BindingContext)request.getBuildState().getBindingContext(), (Question)question, (Object)expression);
    }

    public static interface Messages
    extends MessageFactory {
        public String renameYesNo();

        public String enterNewName();
    }
}

