/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.ask;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.i18n.MessageFactory;
import nz.org.riskscape.engine.i18n.TranslationContext;
import nz.org.riskscape.engine.rl.FunctionCallPrototype;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.Choice;
import nz.org.riskscape.wizard.CliPrompter;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.ask.CompatAsker;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.survey2.Choices;

public class AggregationFunctionPrototypeAsker
extends CompatAsker {
    private final Messages messages;
    static final String VALUE_PLACEHOLDER = "x";

    public AggregationFunctionPrototypeAsker(TranslationContext context) {
        super(context);
        this.messages = (Messages)context.newFactory(Messages.class);
    }

    @Override
    public boolean canAsk(IncrementalBuildState buildState, Question question) {
        return question.getParameterType().equals(FunctionCallPrototype.class) && question.hasAnnotation("aggregation");
    }

    public ResultOrProblems<Answer.Response> chooseAggregationFunction(CliPrompter cliPrompter, IncrementalBuildState buildState, Question question) {
        List choices = Choices.forAggregation((IncrementalBuildState)buildState);
        if (choices.size() == 0) {
            cliPrompter.printError(this.messages.noSuitableDefined(IdentifiedFunction.class.getSimpleName()));
            throw new ExitException(1, "Please ensure the --project file or --home directory being used has " + IdentifiedFunction.class.getSimpleName() + "s defined and try again", new Object[0]);
        }
        Choice chosen = this.pickChoice(choices, cliPrompter, cliPrompter.getPrompt(question));
        return Answer.bind((BindingContext)buildState.getBindingContext(), (Question)question, (Object)chosen.getValue());
    }

    @Override
    public ResultOrProblems<Answer.Response> ask(CliPrompter cliPrompter, IncrementalBuildState buildState, Question question) {
        ResultOrProblems<Answer.Response> responseOr = this.chooseAggregationFunction(cliPrompter, buildState, question);
        if (responseOr.hasErrors()) {
            return responseOr;
        }
        Answer.Response response = (Answer.Response)responseOr.get();
        FunctionCallPrototype aggFunctionPrototype = (FunctionCallPrototype)response.getBoundValue();
        IdentifiedFunction aggFunction = (IdentifiedFunction)buildState.getBindingContext().bind((Object)aggFunctionPrototype.getPrototype().getIdentifier().getValue(), IdentifiedFunction.class).get();
        if (aggFunction.getArguments().size() <= 1) {
            return responseOr;
        }
        Optional firstArgList = ((Type)aggFunction.getArgumentTypes().get(0)).find(RSList.class);
        if (!firstArgList.isPresent()) {
            return responseOr;
        }
        aggFunctionPrototype.addArgument(Optional.empty(), VALUE_PLACEHOLDER, new Object[0]);
        for (int i = 1; i < aggFunction.getArguments().size(); ++i) {
            String argQuestion;
            FunctionArgument arg = aggFunction.getArguments().get(i);
            Type argType = arg.getType();
            boolean allowMany = false;
            Optional listArg = arg.getType().find(RSList.class);
            if (listArg.isPresent()) {
                allowMany = true;
                argType = ((RSList)listArg.get()).getMemberType();
            }
            Optional<Object> argName = Optional.empty();
            if (arg.hasKeyword()) {
                argName = Optional.of(arg.getKeyword());
                argQuestion = String.format("Please specify a `%s` [%s] value to use for the '%s' aggregation", arg.getKeyword(), argType, aggFunction.getId());
            } else {
                argQuestion = String.format("Please specify argument %d [%s] to use for the '%s' aggregation", arg.getIndex() + 1, argType, aggFunction.getId());
            }
            ArrayList argumentAnswers = Lists.newArrayList();
            argumentAnswers.add(cliPrompter.readlineWithTitle(cliPrompter.title(argQuestion)));
            while (allowMany && cliPrompter.askIf("Do you want to specify another value")) {
                argumentAnswers.add(cliPrompter.readlineWithTitle(cliPrompter.title(argQuestion)));
            }
            String argumentAnswer = (String)argumentAnswers.get(0);
            if (allowMany) {
                argumentAnswer = argumentAnswers.stream().collect(Collectors.joining(",", "[", "]"));
            }
            aggFunctionPrototype.setArgument(i, argName, argumentAnswer, new Object[0]);
        }
        FunctionCall aggFunctionCall = aggFunctionPrototype.build();
        return ResultOrProblems.of((Object)new Answer.Response((Object)new FunctionCallPrototype(aggFunctionCall), (Object)aggFunctionCall.toSource()));
    }

    public static interface Messages
    extends MessageFactory {
        public String noSuitableDefined(String var1);
    }
}

