/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import nz.org.riskscape.engine.FileProblems;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.cli.PipelineRenderer;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.pipeline.SinkConstructor;
import nz.org.riskscape.engine.resource.UriHelper;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.wizard.Action;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.CliChoice;
import nz.org.riskscape.wizard.CliPrompter;
import nz.org.riskscape.wizard.ConfigParser;
import nz.org.riskscape.wizard.QuestionSet;
import nz.org.riskscape.wizard.UndoException;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;

public class WizardActions
implements PipelineRenderer {
    public static final Action CONTINUE_ACTION = () -> {};
    private final CliPrompter cli;
    private final URI outTo;

    private boolean writeFile(String filename, String fileDescription, Consumer<Formatter> writer) {
        ResultOrProblems uriResult = UriHelper.uriFromLocation((String)filename, (URI)this.outTo);
        if (uriResult.hasProblems()) {
            this.cli.displayProblems("Failed to write file", uriResult.getProblems());
            return false;
        }
        File outputFile = new File(((URI)uriResult.get()).getPath());
        try (Formatter f = new Formatter(new FileOutputStream(outputFile));){
            writer.accept(f);
        }
        catch (IOException ex) {
            this.cli.displayProblems("Failed to write file", FileProblems.get().cantWriteTo(outputFile.toPath()).withChildren(new Problems[]{Problems.caught((Throwable)ex)}));
            return false;
        }
        this.cli.showSuccessMessage(String.format("Saved %s to %s", fileDescription, ((URI)uriResult.get()).getPath()));
        return true;
    }

    public void saveModelIniAndPipeline(IncrementalBuildState buildState) {
        String modelName = this.cli.readlineWithTitle("Enter a name for the new model");
        this.saveModelIni(buildState, modelName);
        this.savePipelineDsl(buildState, modelName, false);
    }

    public void savePipelineDsl(IncrementalBuildState buildState, String pipelineName, boolean writeModelFile) {
        String pipelineLocation = String.format("pipeline_%s.txt", pipelineName);
        boolean success = this.writeFile(pipelineLocation, "pipeline", f -> f.format(buildState.getAst().toSource() + "%n", new Object[0]));
        if (success && writeModelFile) {
            this.writeFile(String.format("models_pipeline_%s.ini", pipelineName), "pipeline model", f -> f.format("[model %s-pipeline]%nframework = pipeline%nlocation = %s%n", pipelineName, pipelineLocation));
        }
    }

    public void savePipelineDsl(IncrementalBuildState buildState) {
        String pipelineName = this.cli.readlineWithTitle("Enter a name for your pipeline");
        this.savePipelineDsl(buildState, pipelineName, true);
        this.cli.println("");
    }

    public void saveModelIni(IncrementalBuildState buildState) {
        String modelName = this.cli.readlineWithTitle("Enter a name for a new model ini file");
        this.saveModelIni(buildState, modelName);
        this.cli.println("");
    }

    private void saveModelIni(IncrementalBuildState buildState, String modelName) {
        ConfigParser parser = new ConfigParser(ignored -> buildState.getSurvey());
        this.writeFile(String.format("models_%s.ini", modelName), "model", f -> {
            f.format("[model %s]%nframework = wizard%n", modelName);
            parser.getConfigToWrite(buildState).forEach(pair -> f.format("%s = %s%n", pair.getLeft(), pair.getRight()));
        });
    }

    public String getRenderedPipeline(RealizedPipeline pipeline) {
        StringBuilder sb = new StringBuilder();
        this.printPipeline(pipeline, new Formatter(sb), this.cli.getMessages(), this.cli.getLocale());
        return sb.toString();
    }

    public List<CliChoice<Action>> getSaveOrShowActions(IncrementalBuildState buildState) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(new CliChoice<Action>("Undo", "U", () -> {
            throw new UndoException();
        }));
        builder.addAll(Arrays.asList(new CliChoice<Action>("List the attributes currently available in the pipeline", "L", () -> this.showInputScope(buildState)), new CliChoice<Action>("Save your current progress as a model INI file", "m", () -> this.saveModelIni(buildState)), new CliChoice<Action>("Save your current progress as a pipeline", "S", () -> this.savePipelineDsl(buildState)), new CliChoice<Action>("Print the current model pipeline", "P", () -> this.cli.println(buildState.getAst().toSource()).println()), new CliChoice<Action>("Print all answers given so far", "a", () -> this.showAnswers(buildState)), new CliChoice<Action>("Print very detailed information for the current model pipeline (for advanced users)", "d", () -> {
            ResultOrProblems pipeline = buildState.realizePipeline(buildState.getAst());
            if (pipeline.hasErrors()) {
                this.cli.displayProblems("Failed to construct a realized pipeline", pipeline.getProblems());
            } else {
                this.cli.println(this.getRenderedPipeline((RealizedPipeline)pipeline.get()));
            }
        }), new CliChoice<Action>("Continue - Go back and continue the wizard process", "C", CONTINUE_ACTION), new CliChoice<Action>("Exit RiskScape", "E", () -> ExitException.quit())));
        return builder.build();
    }

    public List<CliChoice<Action>> getSurveyCompleteActions(IncrementalBuildState buildState) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(Arrays.asList(new CliChoice<Action>("Save and run", "S", () -> {
            this.saveModelIniAndPipeline(buildState);
            this.cli.println("");
        }), new CliChoice<Action>("Save and quit (without running it)", "q", () -> {
            this.saveModelIniAndPipeline(buildState);
            ExitException.quit();
        }), new CliChoice<Action>("Run it (without saving it)", "R", () -> this.cli.println(buildState.getAst().toSource()).println((Object)""))));
        return builder.build();
    }

    private List<RealizedStep> getStepsInScope(IncrementalBuildState buildState) {
        ArrayList<RealizedStep> endSteps = new ArrayList<RealizedStep>();
        int cappedSteps = 0;
        for (RealizedStep step2 : buildState.getRealizedPipeline().getEndSteps()) {
            if (step2.getStepType() == SinkConstructor.class) {
                ++cappedSteps;
                continue;
            }
            if (step2.getProduces().equals((Object)Struct.EMPTY_STRUCT)) continue;
            endSteps.add(step2);
        }
        if (endSteps.isEmpty() && cappedSteps > 0) {
            Optional stepOr = buildState.getContext().getSurvey().getAnalysisOutputStepName().flatMap(analysisStep -> buildState.getRealizedPipeline().getStep(analysisStep));
            stepOr.ifPresent(step -> endSteps.add((RealizedStep)step));
        }
        return endSteps;
    }

    public void showInputScope(IncrementalBuildState buildState) {
        for (RealizedStep step : this.getStepsInScope(buildState)) {
            this.cli.println(this.cli.title("Showing the attributes produced by the current pipeline:")).println();
            this.cli.println("The current end step '" + step.getStepName() + "' produces:");
            this.printStruct(step.getProduces(), "");
            this.cli.println("");
        }
    }

    private void printStruct(Struct struct, String memberPrefix) {
        for (Struct.StructMember member : struct.getMembers()) {
            Type memberType = Nullable.strip((Type)member.getType());
            Struct memberStruct = memberType.find(Struct.class).orElse(null);
            if (memberStruct == null) {
                this.cli.println("  " + memberPrefix + member.getKey() + " - " + String.valueOf(memberType));
                continue;
            }
            this.printStruct(memberStruct, memberPrefix + member.getKey() + ".");
        }
    }

    public void showAnswers(IncrementalBuildState buildState) {
        List answers = buildState.getAllAnswers();
        Collections.reverse(answers);
        this.cli.println(this.cli.title("Showing all answers:")).println();
        QuestionSet lastQuestionSet = IncrementalBuildState.EMPTY_QUESTION_SET;
        for (Answer answer : answers) {
            if (!answer.getQuestionSet().equals(lastQuestionSet)) {
                lastQuestionSet = answer.getQuestionSet();
                if (lastQuestionSet != IncrementalBuildState.EMPTY_QUESTION_SET) {
                    this.cli.println("");
                }
                this.cli.println(lastQuestionSet.getId() + " - " + String.valueOf(lastQuestionSet.getDescription(this.cli.getTerminal().getLocale())));
            }
            this.cli.println(String.format("  %s - %s", answer.getQuestion().getName(), answer.getOriginalResponses()));
        }
        this.cli.println("");
    }

    @Generated
    public WizardActions(CliPrompter cli, URI outTo) {
        this.cli = cli;
        this.outTo = outTo;
    }
}

