/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import nz.org.riskscape.cli.InterruptHandler;
import nz.org.riskscape.cli.Terminal;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.cli.Main;
import nz.org.riskscape.engine.cli.ReadlineInterruptedException;
import nz.org.riskscape.engine.cli.pipeline.CliPipelineRunner;
import nz.org.riskscape.engine.cli.pipeline.CliPipelineRunnerOptions;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.Pipeline;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.wizard.Action;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.CliPrompter;
import nz.org.riskscape.wizard.EmptyQuestionSet;
import nz.org.riskscape.wizard.EmptySurvey;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.QuestionSet;
import nz.org.riskscape.wizard.Survey;
import nz.org.riskscape.wizard.UndoException;
import nz.org.riskscape.wizard.WizardActions;
import nz.org.riskscape.wizard.WizardProcessor;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.survey2.PickQuestionSet;

public class CliWizardProcessor2 {
    private final Project project;
    private final CliPrompter prompter;
    private final WizardActions actions;
    private final Question skipAll;
    private final MessageSource wizardMessages;
    private AtomicBoolean interrupted = new AtomicBoolean(false);
    private WizardProcessor processor;

    public CliWizardProcessor2(Project project, CliPrompter prompter, WizardActions actions) {
        this.project = project;
        this.prompter = prompter;
        this.actions = actions;
        this.wizardMessages = prompter.getMessages().newMessageSource("wizard");
        this.skipAll = new Question("skip", Question.class).inSet((QuestionSet)new EmptyQuestionSet("cli", (Survey)new EmptySurvey("cli", this.wizardMessages)));
    }

    void newProcessor(Survey survey) {
        this.processor = new WizardProcessor(this.project.newExecutionContext(), survey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Survey survey) {
        this.newProcessor(survey);
        this.prompter.println(Main.COPYRIGHT_NOTICE);
        survey.getDescription(this.prompter.getLocale()).ifPresent(description -> this.prompter.println(description));
        Terminal terminal = this.prompter.getTerminal();
        InterruptHandler toRestore = terminal.setFallbackHandler(() -> {
            if (this.interrupted.get()) {
                System.exit(1);
            } else {
                this.interrupted.set(true);
            }
        });
        try (ExecutionContext ctx = this.processor.getExecutionContext();){
            try {
                this.runInsideInterrupt();
                this.completionMenu();
            }
            finally {
                terminal.setFallbackHandler(toRestore);
            }
            this.runSurveyPipeline();
        }
    }

    IncrementalBuildState runInsideInterrupt() {
        while (true) {
            try {
                while (!this.processor.isDone()) {
                    List next = this.processor.getNextQuestions();
                    Question chosen = this.chooseQuestion(next);
                    if (chosen == this.skipAll) {
                        this.processor.skipAll(next);
                        continue;
                    }
                    Answer answer = this.answerQuestion(chosen);
                    this.processor.applyAnswer(answer);
                    if (!this.processor.isFailed()) continue;
                    this.prompter.displayProblems("", this.processor.getFailures());
                    this.processor.undo();
                }
            }
            catch (UndoException ex) {
                this.processor.undo();
                continue;
            }
            break;
        }
        return this.processor.getBuildState();
    }

    private void runSurveyPipeline() {
        CliPipelineRunner runner = new CliPipelineRunner(this.prompter.getTerminal());
        RealizedPipeline realized = this.processor.getBuildState().getRealizedPipeline();
        realized = realized.withMetadata(realized.getMetadata().withName("wizard"));
        try {
            runner.run(realized, this.processor.getExecutionContext().getPipelineExecutor(), this.project, new CliPipelineRunnerOptions());
        }
        catch (RiskscapeException ex) {
            throw new ExitException((Problems)Problems.foundWith(Pipeline.class, (Problems)Problems.caught((Throwable)ex)), (Throwable)ex);
        }
    }

    private Question chooseQuestion(List<Question> questions) {
        ArrayList options = Lists.newArrayList();
        if (questions.isEmpty()) {
            throw new AssertionError((Object)("shouldn't ever happen - empty questions from " + String.valueOf(questions)));
        }
        options.addAll(questions);
        boolean allOptional = options.stream().allMatch(q -> !q.isRequired());
        if (allOptional) {
            options.add(this.skipAll);
        }
        if (options.size() == 1) {
            return (Question)options.get(0);
        }
        return this.handleInterrupted(() -> this.prompter.choose("Pick A Question", options, q -> q.getTitle(this.prompter.getLocale()).orElse(q.getId())));
    }

    private Answer answerQuestion(Question chosen) {
        boolean another;
        LinkedList<Answer.Response> collected = new LinkedList<Answer.Response>();
        do {
            Answer.Response value = this.handleInterrupted(() -> {
                ResultOrProblems responseOr;
                if (!chosen.getParameterType().equals(PickQuestionSet.class)) {
                    this.prompter.printBreadcrumb(this.processor.getQuestionTree(), chosen);
                }
                while (true) {
                    Object unbound = this.prompter.askWithRepeat(this.processor.getBuildState(), chosen);
                    responseOr = Answer.bind((BindingContext)this.processor.getBindingContext(), (Question)chosen, (Object)unbound);
                    if (!responseOr.hasErrors()) break;
                    this.prompter.displayProblems(this.wizardMessages.getMessage("cli.could-not-bind", new Object[]{unbound}, this.prompter.getLocale()), responseOr.getProblems());
                }
                return (Answer.Response)responseOr.getWithProblemsIgnored();
            });
            collected.add(value);
        } while (!chosen.isSingleValueQuestion() && (another = this.handleInterrupted(() -> this.prompter.askIf("You can specify multiple responses for this question. Do you want to give another response")).booleanValue()));
        return new Answer(chosen, collected);
    }

    private <T> T handleInterrupted(Supplier<T> r) {
        if (this.interrupted.compareAndSet(true, false)) {
            this.interruptMenuLoop(this.processor.getBuildState());
        }
        while (true) {
            try {
                return r.get();
            }
            catch (ReadlineInterruptedException e) {
                this.interruptMenuLoop(this.processor.getBuildState());
                continue;
            }
            break;
        }
    }

    private void interruptMenuLoop(IncrementalBuildState buildState) {
        while (!this.interruptMenu(buildState, false) && this.prompter.askIf("See wizard actions menu again")) {
        }
    }

    private boolean interruptMenu(IncrementalBuildState buildState, boolean allowBack) {
        List choices = this.actions.getSaveOrShowActions(buildState);
        Action chosen = (Action)this.prompter.choose((CommandLine.Help.Ansi.Text)this.prompter.title((String)"Choose an action"), choices).data;
        chosen.run();
        return chosen == WizardActions.CONTINUE_ACTION;
    }

    private void completionMenu() {
        List choices = this.actions.getSurveyCompleteActions(this.processor.getBuildState());
        Action chosen = (Action)this.prompter.choose((CommandLine.Help.Ansi.Text)this.prompter.title((String)"There are no further questions to answer. What do you want to do with your completed model?"), choices).data;
        chosen.run();
    }
}

