/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.cli.AnsiPrintStream;
import nz.org.riskscape.cli.Terminal;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.cli.Table;
import nz.org.riskscape.engine.i18n.Messages;
import nz.org.riskscape.engine.i18n.TranslationContext;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.wizard.CliChoice;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.ask.AskRequest;
import nz.org.riskscape.wizard.ask.Asker;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.survey2.QuestionTree;

public class CliPrompter {
    public static final int DEFAULT_DISPLAY_WIDTH = 110;
    public static final int DEFAULT_INDENT_WIDTH = 16;
    public static final int CHOICE_INDENT_WIDTH = 4;
    public static final List<CliChoice<Boolean>> YES_NO_CHOICES = Arrays.asList(new CliChoice<Boolean>("yes", "y", Boolean.TRUE), new CliChoice<Boolean>("no", "n", Boolean.FALSE));
    private final Terminal terminal;
    private final List<Asker> askers;
    private final Asker defaultAsker;
    private int terminalWidth;
    private final TranslationContext translationContext;
    private final Messages messages;
    private final AnsiPrintStream out;

    public CliPrompter(Terminal terminal, List<Asker> askers, Asker defaultAsker, Messages messages, TranslationContext context) {
        this.terminal = terminal;
        this.askers = askers;
        this.defaultAsker = defaultAsker;
        this.messages = messages;
        this.translationContext = context;
        this.terminalWidth = terminal.getDisplayWidth();
        this.out = terminal.getAnsiOut();
    }

    public AnsiPrintStream println(Object message) {
        return this.out.println(message);
    }

    public boolean askIf(String question) {
        try {
            boolean bl = (Boolean)this.choose((CommandLine.Help.Ansi.Text)this.terminal.getAnsi().text((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"@|white \u0001?|@ "}, (String)question))), CliPrompter.YES_NO_CHOICES).data;
            return bl;
        }
        finally {
            this.out.println();
        }
    }

    public <T> T choose(String prompt, List<T> choiceObjects, Function<T, String> labelFunc, Function<CliChoice<T>, CliChoice<T>> modifier) {
        Function composed = modifier.compose(t -> new CliChoice<Object>((String)labelFunc.apply(t), "", t));
        List choices = Lists.transform(choiceObjects, t -> (CliChoice)composed.apply(t));
        return this.choose((CommandLine.Help.Ansi.Text)this.title((String)prompt), choices).data;
    }

    public <T> T choose(String prompt, List<T> choiceObjects, Function<T, String> labelFunc) {
        return this.choose(prompt, choiceObjects, labelFunc, Function.identity());
    }

    public <T> Optional<T> chooseOptional(String prompt, String cancelLabel, List<T> choiceObjects, Function<T, String> labelFunc, Function<CliChoice<T>, CliChoice<T>> modifier) {
        Function composed = modifier.compose(t -> new CliChoice<Object>((String)labelFunc.apply(t), "", t));
        List choices = Lists.transform(choiceObjects, f -> (CliChoice)composed.apply(f));
        choices = ImmutableList.builder().addAll((Iterable)choices).add(new CliChoice<Object>(cancelLabel, cancelLabel.substring(0, 1), null)).build();
        return Optional.ofNullable(this.choose((CommandLine.Help.Ansi.Text)this.title((String)prompt), choices).data);
    }

    public ResultOrProblems<Object> ask(IncrementalBuildState buildState, Question chosen) {
        Asker asker = this.findAsker(buildState, chosen);
        return asker.askUnbound(AskRequest.create(this, buildState, chosen));
    }

    public Asker findAsker(IncrementalBuildState buildState, Question chosen) {
        for (Asker asker : this.askers) {
            if (!asker.canAsk(buildState, chosen)) continue;
            return asker;
        }
        return this.defaultAsker;
    }

    public <T> CliChoice<T> choose(String prompt, List<CliChoice<T>> choices) {
        return this.choose(this.out.applyStyles(prompt, new CommandLine.Help.Ansi.IStyle[0]), choices);
    }

    private int getDisplayWidth() {
        return Math.min(110, this.terminalWidth);
    }

    private CommandLine.Help.Ansi.Text padChoiceLabel(CommandLine.Help.Ansi.Text label) {
        CommandLine.Help.Ansi.Text formatted = label.concat(": ");
        int padSize = 16 - (4 + formatted.getCJKAdjustedLength());
        if (padSize > 0) {
            formatted = formatted.concat(Strings.repeat((String)" ", (int)padSize));
        } else if (padSize < 0) {
            formatted = formatted.concat(" ");
        }
        return formatted;
    }

    public CommandLine.Help.Ansi.Text getPrompt(Question question) {
        String title = question.getTitle(this.translationContext.getLocale()).orElse(this.translationContext.getMessage("question.title.fallback", new Object[]{question.getName(), question.getParameterType()}));
        CommandLine.Help.Ansi.Text prompt = this.format(title, CommandLine.Help.Ansi.Style.fg_white, this.getDisplayWidth());
        String description = question.getDescription(this.translationContext.getLocale()).orElse("");
        if (!Strings.isNullOrEmpty((String)description)) {
            prompt = prompt.concat(Table.LINE_BREAK).concat(this.format(description, CommandLine.Help.Ansi.Style.italic, this.getDisplayWidth()));
        }
        return prompt;
    }

    private CommandLine.Help.Ansi.Text format(String message, CommandLine.Help.Ansi.Style style, int wrapWidth) {
        return this.lineWrap(this.out.applyStyles(message, new CommandLine.Help.Ansi.IStyle[]{style}), wrapWidth);
    }

    private CommandLine.Help.Ansi.Text lineWrap(CommandLine.Help.Ansi.Text message, int wrapWidth) {
        CommandLine.Help.Ansi.Text formatted = message;
        if (message.getCJKAdjustedLength() > 0) {
            List splitMessage = Table.splitText((int)wrapWidth, (CommandLine.Help.Ansi.Text)message);
            formatted = (CommandLine.Help.Ansi.Text)splitMessage.get(0);
            for (CommandLine.Help.Ansi.Text text : splitMessage.subList(1, splitMessage.size())) {
                formatted = formatted.concat(OsUtils.LINE_SEPARATOR).concat(text);
            }
        }
        return formatted;
    }

    private <T> CommandLine.Help.Ansi.Text getFormattedLabel(CliChoice<T> choice, CommandLine.Help.Ansi ansi) {
        CommandLine.Help.Ansi.Text formatted;
        int shortcutIndex;
        String shortcut = choice.shortcut;
        String label = choice.label;
        int n = shortcutIndex = shortcut.equals("") ? -1 : label.indexOf(shortcut);
        if (shortcutIndex == -1) {
            formatted = ansi.apply(label, Terminal.NO_STYLES);
        } else {
            String prefix = label.substring(0, shortcutIndex);
            String suffix = label.substring(shortcutIndex + shortcut.length(), label.length());
            formatted = ansi.text(String.format("%s@|blue %s|@%s", prefix, shortcut, suffix));
        }
        if (!Strings.isNullOrEmpty((String)choice.subtitle)) {
            formatted = this.padChoiceLabel(formatted);
            String indent = Strings.repeat((String)" ", (int)16);
            int indentIndex = 12;
            CommandLine.Help.Ansi.Text overhang = formatted.substring(indentIndex);
            formatted = formatted.substring(0, indentIndex);
            List splitSubtitle = Table.splitText((int)(this.getDisplayWidth() - 16), (CommandLine.Help.Ansi.Text)overhang.concat(ansi.apply(choice.subtitle, Arrays.asList(CommandLine.Help.Ansi.Style.italic))));
            formatted = formatted.concat((CommandLine.Help.Ansi.Text)splitSubtitle.get(0)).concat(OsUtils.LINE_SEPARATOR);
            for (CommandLine.Help.Ansi.Text text : splitSubtitle.subList(1, splitSubtitle.size())) {
                formatted = formatted.concat(indent).concat(text).concat(OsUtils.LINE_SEPARATOR);
            }
        } else {
            formatted = formatted.concat(OsUtils.LINE_SEPARATOR);
        }
        return formatted;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public <T> CliChoice<T> choose(CommandLine.Help.Ansi.Text prompt, List<CliChoice<T>> choices) {
        try {
            this.println(prompt).println();
            while (true) {
                for (i = 0; i < choices.size(); ++i) {
                    choice = choices.get(i);
                    choiceText = this.out.applyMarkup(String.format("@|white %d: |@ ", new Object[]{i + 1}));
                    choiceText = choiceText.concat(this.getFormattedLabel(choice, this.out.getAnsi()));
                    this.out.print((Object)choiceText.toString());
                }
                this.out.println();
                input = this.readline().trim();
                if (input.equals("")) ** continue;
                for (CliChoice choice : choices) {
                    if (!input.toLowerCase().equals(choice.shortcut.toLowerCase())) continue;
                    var6_9 = choice;
                    return var6_9;
                }
                try {
                    inputInt = Integer.parseInt(input);
                    var5_8 = choices.get(inputInt - 1);
                    return var5_8;
                }
                catch (IndexOutOfBoundsException | NumberFormatException ex) {
                    this.out.printlnStyles("huh?", new CommandLine.Help.Ansi.Style[]{CommandLine.Help.Ansi.Style.fg_red});
                    continue;
                }
                break;
            }
        }
        finally {
            this.out.println((Object)"");
        }
    }

    public String readlineWithTitle(String title) {
        return this.readlineWithTitle(this.out.applyStyles(title, Terminal.NO_STYLES));
    }

    public String readlineWithTitle(CommandLine.Help.Ansi.Text title) {
        if (title != null) {
            this.out.println((Object)title);
        }
        this.out.print((Object)this.out.applyStyles("> ", new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.fg_white, CommandLine.Help.Ansi.Style.bold}));
        try {
            return this.terminal.readline();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String readline() {
        return this.readlineWithTitle((CommandLine.Help.Ansi.Text)null);
    }

    public CommandLine.Help.Ansi.Text title(String prompt) {
        return this.out.applyStyles("*** " + prompt + " ***", new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.fg_white});
    }

    public AnsiPrintStream printlnTitle(String prompt) {
        return this.out.println((Object)this.title(prompt));
    }

    public Object askWithRepeat(IncrementalBuildState buildState, Question chosen) {
        ResultOrProblems<Object> result;
        do {
            if (!(result = this.ask(buildState, chosen)).hasProblems()) continue;
            this.out.println((Object)"Some problems were detected with the value given:");
            for (Problem problem : result.getProblems()) {
                this.terminal.log(problem);
            }
            this.out.println();
        } while (result.hasErrors());
        return result.getWithProblemsIgnored();
    }

    public void displayProblems(String header, Problem ... problems) {
        this.displayProblems(header, Arrays.asList(problems));
    }

    public void displayProblems(String header, List<Problem> problemList) {
        if (!Strings.isNullOrEmpty((String)header)) {
            this.out.println((Object)header);
        }
        for (Problem problem : problemList) {
            this.out.println((Object)this.messages.renderProblem(problem)).println();
        }
    }

    public void showSuccessMessage(String successMessage) {
        this.out.printlnMarkup("@|green [OK]|@ " + successMessage);
    }

    public void printError(String message) {
        this.out.printlnStyles("Error: " + message, new CommandLine.Help.Ansi.Style[]{CommandLine.Help.Ansi.Style.fg_red});
    }

    public Locale getLocale() {
        return this.terminal.getLocale();
    }

    public void printBreadcrumb(QuestionTree tree, Question chosen) {
        QuestionTree.Node node = tree.findQuestion(chosen).orElse(null);
        if (node == null) {
            return;
        }
        LinkedList<String> chunks = new LinkedList<String>();
        while (!node.isTopLevel()) {
            chunks.add(node.getQuestion().getSummary(this.getLocale()).orElse(Question.formatName((String)node.getQuestion().getName())));
            node = node.getParent();
        }
        chunks.add(chosen.getQuestionSet().getId());
        Collections.reverse(chunks);
        String string = chunks.stream().collect(Collectors.joining(" >> "));
        this.out.printlnStyles(string, new CommandLine.Help.Ansi.Style[]{CommandLine.Help.Ansi.Style.italic}).println();
    }

    @Generated
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Generated
    public Messages getMessages() {
        return this.messages;
    }

    @Generated
    public AnsiPrintStream getOut() {
        return this.out;
    }

    public static enum ChooseSwitch {
        SHOW_CANCEL;

    }
}

