/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli.pipeline;

import java.net.URI;
import java.nio.file.Paths;
import java.util.List;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.Problems;

public class CliPipelineRunnerOptions {
    @CommandLine.Option(names={"-o", "--output"}, descriptionKey="common.run.output")
    public String output;
    @CommandLine.Option(names={"-r", "--replace"}, descriptionKey="common.run.replace")
    public boolean replace;
    @CommandLine.Option(names={"--checksum"}, descriptionKey="common.run.checksum")
    public boolean checksum;
    @CommandLine.Option(names={"--progress-indicator"}, descriptionKey="common.run.progress-indicator")
    public String progressIndicator = "cli";
    @CommandLine.Option(names={"--show-engine-stats"}, descriptionKey="common.run.engine-stats")
    public boolean engineStats;
    @CommandLine.Option(names={"-f", "--format"}, descriptionKey="common.run.format")
    public String format;

    public URI getOutputBase(Project project) throws ExitException {
        BindingContext ctx = project.newBindingContext().withNewRelativeTo(Paths.get("", new String[0]).toUri());
        return (URI)ctx.bind((Object)this.output, URI.class).orElseThrow(problems -> new ExitException((Problems)Problems.foundWith((Object)"--output", (List)problems)));
    }

    public Format getFormat(Project project) {
        if (this.format != null) {
            return (Format)project.newBindingContext().bind((Object)this.format, Format.class).orElseThrow(problems -> {
                throw new ExitException((Problems)Problems.foundWith((Object)"--format", (List)problems));
            });
        }
        return null;
    }
}

