/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli.pipeline;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import nz.org.riskscape.cli.Terminal;
import nz.org.riskscape.engine.HasMeter;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.cli.CliProgressNotifier;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.cli.pipeline.CliPipelineRunnerOptions;
import nz.org.riskscape.engine.output.PipelineJobContext;
import nz.org.riskscape.engine.output.PipelineOutputContainer;
import nz.org.riskscape.engine.output.PipelineOutputOptions;
import nz.org.riskscape.engine.output.PipelineOutputStores;
import nz.org.riskscape.engine.pipeline.ExecutionResult;
import nz.org.riskscape.engine.pipeline.PipelineExecutor;
import nz.org.riskscape.engine.pipeline.PipelineProblems;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.util.FileProgressNotifier;
import nz.org.riskscape.engine.util.ParentingListener;
import nz.org.riskscape.engine.util.ProgressNotifier;
import nz.org.riskscape.problem.Problems;

public class CliPipelineRunner {
    private static final String MONITOR_PROGRESS_CLI = "cli";
    private static final String MONITOR_PROGRESS_NONE = "none";
    public static final String MONITOR_PROGRESS_DEFAULT = "cli";
    private final Terminal terminal;
    private final Supplier<LocalDateTime> currentTime;

    public static String createDirFriendlyTimestamp(LocalDateTime dateTime) {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(dateTime.truncatedTo(ChronoUnit.SECONDS)).replace(":", "_");
    }

    public CliPipelineRunner(Terminal terminal) {
        this(terminal, () -> LocalDateTime.now());
    }

    public void run(RealizedPipeline realized, PipelineExecutor executor, Project useProject, CliPipelineRunnerOptions options) {
        ExecutionResult result;
        MetricRegistry progressMetrics = new MetricRegistry();
        PipelineOutputContainer outputContainer = this.createContainer(options, realized);
        for (RealizedStep step : realized.getRealizedSteps()) {
            step.getResult().ifPresent(r -> {
                if (r instanceof HasMeter) {
                    MetricRegistry registry = ((HasMeter)r).getRegistry();
                    MetricRegistry master = realized.getContext().getMetricRegistry();
                    for (String names : registry.getNames()) {
                        master.register(step.getStepName() + "." + names, (Metric)registry.getMetrics().get(names));
                    }
                }
            });
        }
        if (options.engineStats) {
            MetricRegistry engineMetrics = useProject.getEngine().getDiagnostics().getMetricRegistry();
            ParentingListener.mirror((MetricRegistry)engineMetrics, (MetricRegistry)progressMetrics, (String)"engine.");
        }
        Optional<ProgressNotifier> progressNotifier = this.createProgressNotifier(options, progressMetrics, useProject);
        try {
            result = (ExecutionResult)executor.execute(this.createJobContext(realized, outputContainer, progressMetrics)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ExitException((Problems)PipelineProblems.get().executionFailed().withChildren(new Problems[]{Problems.caught((Throwable)e.getCause())}));
        }
        finally {
            progressNotifier.ifPresent(pn -> pn.finish());
        }
        outputContainer.close();
        for (Map.Entry entry : result.getPipelineOutputs().entrySet()) {
            this.terminal.getOut().println(entry.getValue());
        }
    }

    public PipelineOutputContainer createContainer(CliPipelineRunnerOptions cliOptions, RealizedPipeline pipeline) {
        Project project = pipeline.getContext().getProject();
        String name = pipeline.getMetadata().getName();
        PipelineOutputStores stores = pipeline.getContext().getEngine().getPipelineOutputStores();
        URI outputBaseToUse = cliOptions.output == null ? pipeline.getContext().getProject().getOutputBaseLocation() : cliOptions.getOutputBase(project);
        return (PipelineOutputContainer)stores.getStoreForURI(outputBaseToUse).flatMap(store -> {
            PipelineOutputOptions outputOptions = store.newOutputOptions(name);
            outputOptions.setReplace(cliOptions.replace);
            outputOptions.setChecksum(cliOptions.checksum);
            outputOptions.setFormat(cliOptions.getFormat(project));
            outputOptions.setPipelineDeclaration(Optional.of(pipeline.getAst()));
            URI outputTo = outputBaseToUse;
            if ("filesystem".equals(store.getId()) && cliOptions.output == null && "file".equals(outputBaseToUse.getScheme())) {
                Path outputDir = Paths.get(outputBaseToUse);
                outputDir = outputDir.resolve(name).resolve(CliPipelineRunner.createDirFriendlyTimestamp(this.currentTime.get()));
                outputTo = outputDir.toUri();
            }
            return store.create(outputTo, pipeline, outputOptions);
        }).drainWarnings((Consumer)this.terminal, (severity, problems) -> Problems.foundWith((Object)"--output", (List)problems)).orElseThrow(probs -> new ExitException(1, (Problems)Problems.foundWith((Object)"--output", (List)probs)));
    }

    private PipelineJobContext createJobContext(final RealizedPipeline realized, final PipelineOutputContainer outputContainer, final MetricRegistry progressMetrics) {
        return new PipelineJobContext(){

            public PipelineOutputContainer getOutputContainer() {
                return outputContainer;
            }

            public RealizedPipeline getPipeline() {
                return realized;
            }

            public MetricRegistry getProgressMetrics() {
                return progressMetrics;
            }
        };
    }

    public Optional<ProgressNotifier> createProgressNotifier(CliPipelineRunnerOptions options, MetricRegistry metrics, Project useProject) {
        if ("cli".equals(options.progressIndicator)) {
            return Optional.of(new CliProgressNotifier(metrics, this.terminal));
        }
        if (MONITOR_PROGRESS_NONE.equals(options.progressIndicator)) {
            return Optional.empty();
        }
        return Optional.of(new FileProgressNotifier(metrics, Paths.get(options.progressIndicator, new String[0]), useProject.getProblemSink()));
    }

    @Generated
    public CliPipelineRunner(Terminal terminal, Supplier<LocalDateTime> currentTime) {
        this.terminal = terminal;
        this.currentTime = currentTime;
    }
}

