/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli.model;

import java.util.Arrays;
import java.util.Formatter;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.cli.ApplicationCommand;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.cli.TerminalCommand;
import nz.org.riskscape.engine.cli.model.BaseModelRunCommand;
import nz.org.riskscape.engine.cli.pipeline.CliPipelineRunner;
import nz.org.riskscape.engine.model.IdentifiedModel;
import nz.org.riskscape.engine.model.Model;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.PipelineExecutor;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;

@CommandLine.Command(name="run")
public class RunCommand
extends BaseModelRunCommand {
    @CommandLine.Option(names={"--print"})
    public Boolean printPipeline = false;
    @CommandLine.Option(names={"--graph"})
    public Boolean graphPipeline = false;

    public Object doCommand(Project useProject) {
        boolean parametersNeedUpdating = !this.parameters.isEmpty() || this.parametersFile != null;
        IdentifiedModel identifiedModel = (IdentifiedModel)ApplicationCommand.getObject((IdentifiedCollection)useProject.getIdentifiedModels(), (String)this.modelId, (ProblemSink)(parametersNeedUpdating ? ProblemSink.DEVNULL : this.getTerminal()));
        Model model = identifiedModel.getModel();
        if (parametersNeedUpdating) {
            model = this.updateParameters(model, this.getCliParameterMap());
        }
        PipelineExecutor executor = useProject.getEngine().getPipelineExecutor();
        try (ExecutionContext executionContext = executor.newExecutionContext(useProject);){
            if (this.printPipeline.booleanValue()) {
                this.printPipeline(this.realize(model, executionContext, true), new Formatter(this.stdout()), (TerminalCommand)this);
                Object var7_7 = null;
                return var7_7;
            }
            RealizedPipeline realizedPipeline = this.realize(model, executionContext);
            realizedPipeline = realizedPipeline.withMetadata(realizedPipeline.getMetadata().withName(this.modelId));
            if (this.graphPipeline.booleanValue()) {
                this.graph(realizedPipeline, this.stdout(), "digraph", this.modelId, Arrays.asList("compound=true"));
                Object var8_10 = null;
                return var8_10;
            }
            CliPipelineRunner runner = new CliPipelineRunner(this.getTerminal());
            this.warnIfCannotOverrideFormat(realizedPipeline, useProject.getEngine().getProblemSink());
            try {
                runner.run(realizedPipeline, executor, useProject, this.runnerOptions);
            }
            catch (RiskscapeException ex) {
                throw new ExitException((Problems)Problems.foundWith((Object)model, (Problems)Problems.caught((Throwable)ex)), (Throwable)ex);
            }
            Object var9_14 = null;
            return var9_14;
        }
    }
}

