/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli.model;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.cli.ApplicationCommand;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.cli.model.BaseModelRunCommand;
import nz.org.riskscape.engine.cli.pipeline.CliPipelineRunner;
import nz.org.riskscape.engine.model.IdentifiedModel;
import nz.org.riskscape.engine.model.Model;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.PipelineExecutor;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;

@CommandLine.Command(name="batch")
public class BatchCommand
extends BaseModelRunCommand {
    public static final String VARY_TOKEN = "{}";
    public static final String VARY_TOKEN_PATTERN = Pattern.quote("{}");
    @CommandLine.Option(names={"--vary-parameter"}, required=false)
    public String varyParameter;
    @CommandLine.Option(names={"--vary-input"}, required=true)
    public String varyInputString;
    @CommandLine.Option(names={"--failure-mode"}, required=false)
    public BatchFailureMode failureMode = BatchFailureMode.WARN;

    public Object doCommand(Project useProject) {
        if (this.runnerOptions.output != null) {
            String mockOutputPath = this.runnerOptions.output.replaceAll(VARY_TOKEN_PATTERN, "VARY-VALUE");
            this.bindOutput(mockOutputPath);
        }
        int batchesToRun = 0;
        int batchesAttempted = 0;
        int batchesSuccessful = 0;
        int batchesFailed = 0;
        Model model = ((IdentifiedModel)ApplicationCommand.getObject((IdentifiedCollection)useProject.getIdentifiedModels(), (String)this.modelId, (ProblemSink)this.getTerminal())).getModel();
        Map<String, List<String>> cliParameterMap = this.getCliParameterMap();
        Vary varying = this.findVary(model, cliParameterMap);
        if (!this.parameters.isEmpty() || this.parametersFile != null) {
            model = this.updateParameters(model, cliParameterMap);
        }
        List<String> varyInputs = this.processVaryInput();
        batchesToRun = varyInputs.size();
        ArrayList<Problem> parameterErrors = new ArrayList<Problem>();
        ArrayList batches = Lists.newArrayListWithCapacity((int)varyInputs.size());
        for (String varyInput : varyInputs) {
            HashMap<String, List<String>> varyParameterMap = new HashMap<String, List<String>>();
            varyParameterMap.put(varying.modelParameter.getName(), Arrays.asList(varying.replacementPattern.replaceAll(VARY_TOKEN_PATTERN, Matcher.quoteReplacement(varyInput))));
            try {
                batches.add(this.updateParameters(model, varyParameterMap));
            }
            catch (ExitException e) {
                parameterErrors.add(Problems.foundWith((Object)varyInput, (Problems)e.getProblem()));
            }
        }
        if (!parameterErrors.isEmpty()) {
            throw new ExitException((Problems)Problems.foundWith((Object)"--vary-parameter", parameterErrors));
        }
        String batchStartTimestamp = CliPipelineRunner.createDirFriendlyTimestamp(this.getCurrentTime());
        CliPipelineRunner runner = new CliPipelineRunner(this.getTerminal());
        boolean outputSwitchGiven = this.runnerOptions.output != null;
        String outPattern = outputSwitchGiven && this.runnerOptions.output.contains(VARY_TOKEN) ? this.runnerOptions.output : null;
        for (int i = 0; i < batches.size(); ++i) {
            ++batchesAttempted;
            Model toRun = (Model)batches.get(i);
            PipelineExecutor executor = useProject.getEngine().getPipelineExecutor();
            try (ExecutionContext executionContext = executor.newExecutionContext(useProject);){
                RealizedPipeline realizedPipeline = this.realize(toRun, executionContext);
                if (i == 0 && this.runnerOptions.format != null) {
                    this.warnIfCannotOverrideFormat(realizedPipeline, useProject.getEngine().getProblemSink());
                }
                if (outputSwitchGiven) {
                    if (outPattern != null) {
                        String pvAsBasename = com.google.common.io.Files.getNameWithoutExtension((String)varyInputs.get(i));
                        this.runnerOptions.output = outPattern.replaceAll(VARY_TOKEN_PATTERN, pvAsBasename);
                    }
                } else {
                    this.runnerOptions.output = useProject.getOutputBaseLocation().resolve(String.format("%s/%s/batch%d/", this.modelId, batchStartTimestamp, i + 1)).toString();
                }
                runner.run(realizedPipeline, executor, useProject, this.runnerOptions);
                ++batchesSuccessful;
                continue;
            }
            catch (RiskscapeException ex) {
                ++batchesFailed;
                this.stderr().format("Could not execute batch %d of %d%n", batchesAttempted, batchesToRun);
                this.stderr().format("  Vary parameter value: %s%n", varyInputs.get(i));
                this.stderr().format("  Reason: %s%n%n", this.getMessages().renderProblem((Throwable)ex));
                if (this.failureMode != BatchFailureMode.ABORT) continue;
                throw new ExitException(1, "Batch failed with --vary-parameter value: %s", new Object[]{varyInputs.get(i)});
            }
        }
        this.stdout().format("Batch complete. Success %d of %d%n", batchesSuccessful, batchesToRun);
        if (batchesFailed > 0) {
            String message = String.format("There were %d batch(s) that did not complete successfully", batchesFailed);
            if (this.failureMode == BatchFailureMode.EXIT_ERROR) {
                throw new ExitException(1, message, new Object[0]);
            }
            this.stderr().println(message);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Vary findVary(Model model, Map<String, List<String>> cliParameterMap) {
        String varyPattern;
        String paramName;
        block5: {
            paramName = this.varyParameter;
            if (paramName == null) {
                List withToken = cliParameterMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().filter(v -> v.contains(VARY_TOKEN)).findFirst().isPresent()).collect(Collectors.toList());
                if (withToken.size() == 1) {
                    Map.Entry entry2 = (Map.Entry)withToken.get(0);
                    if (((List)entry2.getValue()).size() != 1) {
                        throw new ExitException(1, "The batch command does not support being run against parameters with more than one argument.  Parameter %s has been supplied %d time(s)", new Object[]{entry2.getKey(), entry2.getValue()});
                    }
                    paramName = (String)entry2.getKey();
                    varyPattern = (String)((List)entry2.getValue()).get(0);
                    cliParameterMap.remove(entry2.getKey());
                    break block5;
                } else {
                    if (withToken.isEmpty()) {
                        throw new ExitException(1, "--vary-parameter not set, and no %s pattern found in any parameters", new Object[]{VARY_TOKEN});
                    }
                    throw new ExitException(1, "Only one parameter may contain the vary-input pattern `%s`", new Object[]{VARY_TOKEN});
                }
            }
            varyPattern = VARY_TOKEN;
        }
        String toFind = paramName;
        Parameter param = model.getBoundParameters().getBoundTo().getDeclared().stream().filter(p -> p.getName().equals(toFind)).findFirst().orElseThrow(() -> new ExitException(1, "--vary-parameter '%s' does not exist on model %s - did you mean one of %s?", new Object[]{this.varyParameter, this.modelId, model.getBoundParameters().getBoundTo().getDeclared().stream().map(Parameter::getName).collect(Collectors.toList())}));
        return new Vary(param, varyPattern);
    }

    private List<String> processVaryInput() {
        List<String> beingBuilt;
        try {
            File varyInput = new File(this.varyInputString);
            if (varyInput.isDirectory()) {
                beingBuilt = Files.list(varyInput.toPath()).map(Path::toUri).map(p -> p.toString()).collect(Collectors.toList());
                beingBuilt.sort(String::compareTo);
            } else if (!this.containsGlobs(this.varyInputString)) {
                if (!varyInput.exists()) {
                    throw new ExitException(1, String.format("vary-input file: %s does not exist", varyInput), new Object[0]);
                }
                if (!varyInput.canRead() || !varyInput.isFile()) {
                    throw new ExitException(1, String.format("vary-input file: %s cannot be read is or not a file", this.varyInputString), new Object[0]);
                }
                beingBuilt = Files.readAllLines(varyInput.toPath()).stream().filter(l -> !"".equals(l.trim())).collect(Collectors.toList());
            } else {
                String namePart = varyInput.getName();
                String namePattern = namePart.replace(".", "\\.").replace("*", ".*").replace(VARY_TOKEN, ".*");
                File parent = varyInput.getParentFile();
                if (parent == null) {
                    parent = new File("");
                }
                beingBuilt = Files.list(parent.toPath()).filter(p -> p.toFile().isFile()).filter(p -> p.toFile().getName().matches(namePattern)).sorted().map(Path::toUri).map(p -> p.toString()).collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            throw new ExitException(1, String.format("Could not read vary-input file: %s", this.varyInputString), new Object[]{e});
        }
        if (beingBuilt.isEmpty()) {
            throw new ExitException(1, String.format("vary-input: %s is empty", this.varyInputString), new Object[0]);
        }
        return beingBuilt;
    }

    private boolean containsGlobs(String toCheck) {
        return toCheck.contains("*") || toCheck.contains(VARY_TOKEN);
    }

    public static enum BatchFailureMode {
        WARN,
        ABORT,
        EXIT_ERROR;

    }

    public static class Vary {
        final Parameter modelParameter;
        final String replacementPattern;

        @Generated
        public Vary(Parameter modelParameter, String replacementPattern) {
            this.modelParameter = modelParameter;
            this.replacementPattern = replacementPattern;
        }
    }
}

