/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.cli.ApplicationCommand;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.cli.PipelineRenderer;
import nz.org.riskscape.engine.cli.pipeline.CliPipelineRunnerOptions;
import nz.org.riskscape.engine.ini.IniParser;
import nz.org.riskscape.engine.model.Model;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.PipelineProblems;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.pipeline.SinkConstructor;
import nz.org.riskscape.engine.pipeline.sink.SaveSinkConstructor;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.resource.FileResourceLoader;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceLoadingException;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.ini4j.Ini;
import org.ini4j.Profile;

public abstract class BaseModelRunCommand
extends ApplicationCommand
implements PipelineRenderer {
    @CommandLine.Parameters(arity="1", index="0")
    public String modelId;
    @CommandLine.Mixin
    public CliPipelineRunnerOptions runnerOptions = new CliPipelineRunnerOptions();
    @CommandLine.Option(names={"--parameters"})
    public Path parametersFile;
    @CommandLine.Option(names={"-p", "--param", "--parameter"})
    public List<String> parameters = new ArrayList<String>();

    protected void warnIfCannotOverrideFormat(RealizedPipeline pipeline, ProblemSink problemSink) {
        if (this.runnerOptions.format == null) {
            return;
        }
        Format formatOverride = this.runnerOptions.getFormat(pipeline.getContext().getProject());
        for (RealizedStep step : pipeline.getRealizedSteps()) {
            Optional explicitSaveFormat;
            if (step.getStepType() != SinkConstructor.class || !(explicitSaveFormat = (Optional)step.getResult().map(save -> ((SaveSinkConstructor)save).getParameters().format).orElse(Optional.empty())).isPresent() || explicitSaveFormat.get() == formatOverride) continue;
            problemSink.log(((LocalProblems)Problems.get(LocalProblems.class)).cannotOverrideSaveFormat(this.runnerOptions.format).withSeverity(Problem.Severity.WARNING));
            return;
        }
    }

    protected Map<String, List<String>> getCliParameterMap() {
        Map<Object, Object> cliParameters = this.parametersFile != null ? this.getParametersFromFile() : Maps.newHashMap();
        cliParameters.putAll(this.getIndividualCliParameters());
        return cliParameters;
    }

    private Map<String, List<String>> getIndividualCliParameters() {
        HashMap<String, List<String>> cliParameters = new HashMap<String, List<String>>(this.parameters.size());
        for (String string : this.parameters) {
            String[] keyValue = string.split("=", 2);
            if (keyValue.length != 2) {
                cliParameters.put(keyValue[0], Collections.emptyList());
                continue;
            }
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            cliParameters.computeIfAbsent(key, k -> new ArrayList(1)).add(value);
        }
        this.makeRelativeTo(Paths.get(".", new String[0]).toUri(), cliParameters);
        return cliParameters;
    }

    private Map<String, List<String>> getParametersFromFile() {
        Ini parametersIni;
        Resource parameterFileResource;
        HashMap<String, List<String>> fileParameters = new HashMap<String, List<String>>();
        try {
            parameterFileResource = new FileResourceLoader().load(this.parametersFile.toUri());
            parametersIni = IniParser.parse((InputStream)parameterFileResource.getContentStream());
        }
        catch (RiskscapeIOException | ResourceLoadingException e) {
            throw new ExitException((Problems)Problems.foundWith((Object)"--parameters", (Problems)Problems.caught((Throwable)e)));
        }
        Profile.Section section = (Profile.Section)parametersIni.get((Object)this.modelId);
        if (section == null) {
            if (parametersIni.size() == 1) {
                section = (Profile.Section)parametersIni.values().iterator().next();
            } else {
                throw new ExitException((Problems)Problems.foundWith((Object)"--parameters", (Problems)((LocalProblems)Problems.get(LocalProblems.class)).noModelOrSingleSection(this.parametersFile, this.modelId)));
            }
        }
        for (String key : section.keySet()) {
            fileParameters.computeIfAbsent(key, k -> Lists.newArrayList()).addAll(section.getAll((Object)key));
        }
        this.makeRelativeTo(parameterFileResource.getLocation(), fileParameters);
        return fileParameters;
    }

    private void makeRelativeTo(URI relativeTo, Map<String, List<String>> parameterMap) {
        for (Map.Entry<String, List<String>> entry : parameterMap.entrySet()) {
            entry.setValue(entry.getValue().stream().map(e -> {
                if (e.startsWith("./")) {
                    return relativeTo.resolve((String)e).toString();
                }
                return e;
            }).collect(Collectors.toList()));
        }
    }

    protected Model updateParameters(Model model, Map<String, List<String>> cliParameters) {
        BoundParameters origBuildParameters = model.getFrameworkParameters();
        Project project = origBuildParameters.getContext().getProject();
        LinkedHashMap<String, List<String>> newUnboundParams = new LinkedHashMap<String, List<String>>();
        for (Map.Entry originalEntry : origBuildParameters.getUnbound().entrySet()) {
            List override = cliParameters.remove(originalEntry.getKey());
            newUnboundParams.put((String)originalEntry.getKey(), override == null ? (List)originalEntry.getValue() : override);
        }
        newUnboundParams.putAll(cliParameters);
        BoundParameters newParameters = origBuildParameters.getBoundTo().bind(origBuildParameters.getContext(), newUnboundParams);
        ResultOrProblems newModel = newParameters.flatMap(p -> model.getFramework().build(project, p));
        if (newModel.hasErrors()) {
            throw new ExitException((Problems)ParamProblems.get().invalidFor((Object)model).withChildren(newModel.getProblems()));
        }
        return (Model)newModel.drainWarnings((Consumer)this.getTerminal()).get();
    }

    protected RealizedPipeline realize(Model model, ExecutionContext executionContext) {
        return this.realize(model, executionContext, false);
    }

    protected RealizedPipeline realize(Model model, ExecutionContext executionContext, boolean allowFailures) {
        ResultOrProblems realizedOr = model.realize(executionContext);
        if (realizedOr.hasErrors()) {
            throw new ExitException((Problems)PipelineProblems.get().cannotRealize(Model.class).withChildren(realizedOr.getProblems()));
        }
        if (!allowFailures && ((RealizedPipeline)realizedOr.get()).hasFailures()) {
            throw new ExitException((Problems)PipelineProblems.get().cannotRealize(Model.class).withChildren(((RealizedPipeline)realizedOr.get()).getFailures()));
        }
        return (RealizedPipeline)realizedOr.get();
    }

    protected LocalDateTime getCurrentTime() {
        return LocalDateTime.now();
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem cannotOverrideSaveFormat(String var1);

        public Problem noModelOrSingleSection(Path var1, String var2);
    }
}

