/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.util.Arrays;
import java.util.List;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.Reference;
import nz.org.riskscape.engine.cli.ApplicationCommand;
import nz.org.riskscape.engine.cli.StubCommand;
import nz.org.riskscape.engine.cli.Table;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.typeset.CanonicalType;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.ProblemSink;

@CommandLine.Command(name="type", subcommands={InfoCommand.class, ListCommand.class})
public class TypesCommand
extends StubCommand {

    @CommandLine.Command(name="info")
    public static class InfoCommand
    extends ApplicationCommand {
        @CommandLine.Parameters(index="0")
        public String id;

        public Object doCommand(Project project) {
            CanonicalType ct = (CanonicalType)ApplicationCommand.getObject((IdentifiedCollection)project.getTypeSet(), (String)this.id, (ProblemSink)this.getTerminal());
            return String.format("%s%n%s%n", this.id, ct.getUnderlyingType().toString());
        }
    }

    @CommandLine.Command(name="list")
    public static class ListCommand
    extends ApplicationCommand {
        public Object doCommand(Project project) {
            return Table.fromList((List)project.getTypeSet().getReferences(), CanonicalType.class, (MessageSource)this.getMessages().getLabels(), Arrays.asList(Table.Property.of((String)"id", Reference::getId), Table.Property.of((String)"description", ref -> (String)ref.getResult().map(t -> t.getUnderlyingType().toString()).orElse((Object)this.formatFailedObjectErrorsForTable((Reference)ref)))));
        }
    }
}

