/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.io.File;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.function.Consumer;
import nz.org.riskscape.dsl.LexerException;
import nz.org.riskscape.dsl.ParseException;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.cli.ApplicationCommand;
import nz.org.riskscape.engine.cli.EngineOnlyCommand;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.cli.PipelineRenderer;
import nz.org.riskscape.engine.cli.StubCommand;
import nz.org.riskscape.engine.cli.Table;
import nz.org.riskscape.engine.cli.TerminalCommand;
import nz.org.riskscape.engine.cli.pipeline.CliPipelineRunner;
import nz.org.riskscape.engine.cli.pipeline.CliPipelineRunnerOptions;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.PipelineExecutor;
import nz.org.riskscape.engine.pipeline.PipelineSteps;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.Step;
import nz.org.riskscape.engine.resource.FileResourceLoader;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceLoadingException;
import nz.org.riskscape.engine.resource.StreamResource;
import nz.org.riskscape.engine.resource.StringResource;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.pipeline.PipelineMetadata;
import nz.org.riskscape.pipeline.PipelineParser;
import nz.org.riskscape.pipeline.ast.PipelineDeclaration;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;

@CommandLine.Command(name="pipeline", subcommands={StepCmd.class, Eval.class})
public class PipelineCommand
extends StubCommand {

    static abstract class AbstractPipelineRunner
    extends ApplicationCommand
    implements PipelineRenderer {
        @CommandLine.Option(names={"--print"})
        public Boolean printPipeline = false;
        @CommandLine.Mixin
        public CliPipelineRunnerOptions runnerOptions = new CliPipelineRunnerOptions();

        AbstractPipelineRunner() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Object run(Project useProject, PipelineDeclaration ast) {
            PipelineExecutor executor = useProject.getEngine().getPipelineExecutor();
            try (ExecutionContext executionContext = executor.newExecutionContext(useProject);){
                RealizedPipeline realized = executionContext.realize(ast);
                if (this.printPipeline.booleanValue()) {
                    this.printPipeline(realized, new Formatter(this.stdout()), (TerminalCommand)this);
                    Object var6_8 = null;
                    return var6_8;
                }
                if (realized.hasFailures()) {
                    Problem problem = Problem.composite((List)realized.getFailures(), (String)"There were pipeline failures", (Object[])new Object[0]);
                    return problem;
                }
                this.execute(realized.drainWarnings((Consumer)useProject.getProblemSink()), executor, useProject);
                Object var6_10 = null;
                return var6_10;
            }
            catch (RiskscapeException ex) {
                throw new ExitException((Problems)Problems.foundWith((Object)ast, (Problems)Problems.caught((Throwable)ex)), (Throwable)ex);
            }
        }

        private void execute(RealizedPipeline realized, PipelineExecutor executor, Project useProject) {
            CliPipelineRunner runner = new CliPipelineRunner(this.getTerminal());
            runner.run(realized, executor, useProject, this.runnerOptions);
        }

        protected LocalDateTime getCurrentTime() {
            return LocalDateTime.now();
        }
    }

    @CommandLine.Command(name="eval", aliases={"evaluate"})
    public static class Eval
    extends AbstractPipelineRunner {
        @CommandLine.Parameters(index="0")
        public String pipelineFile;

        public Object doCommand(Project useProject) {
            PipelineDeclaration ast = this.parsePipeline();
            return this.run(useProject, ast);
        }

        private PipelineDeclaration parsePipeline() throws RiskscapeException {
            Resource resource = this.getResourceFrom(this.pipelineFile);
            String pipelineSource = resource.getContentAsString();
            try {
                return PipelineParser.INSTANCE.parsePipeline(pipelineSource).withMetadata(new PipelineMetadata(resource.getLocation(), "pipeline-eval", ""));
            }
            catch (LexerException | ParseException e) {
                throw new ExitException((Problems)this.appendFileTip(Problem.error((String)("Failed to parse pipeline from " + String.valueOf(resource.getLocation())), (Object[])new Object[0]).withChildren(new Problems[]{e.getProblem()})));
            }
        }

        private Problem appendFileTip(Problem problem) {
            String examplePath = OsUtils.isWindows() ? ".\\pipeline.txt, C:\\Users\\Ronnie\\Projects\\pipeline.txt" : "./pipeline.txt, /home/ronnie/riskscape/pipeline.txt";
            return problem.withChildren(new Problems[]{Problem.info((String)("To evaluate from a file, prefix the filename e.g. " + examplePath), (Object[])new Object[0])});
        }

        public boolean isThisDefinitelyAFile(String pipelineArg, File file) {
            return file.exists() || pipelineArg.startsWith("/") || pipelineArg.startsWith("\\") || pipelineArg.startsWith("./") || pipelineArg.startsWith(".\\");
        }

        public Resource getResourceFrom(String pipelineArg) {
            File file = new File(pipelineArg.trim());
            if (file.getName().equals("-")) {
                return new StreamResource(Resource.UNKNOWN_URI, this.getTerminal().getIn()){

                    public String toString() {
                        return "<STDIN>";
                    }

                    public URI getLocation() {
                        return URI.create("STDIN");
                    }
                };
            }
            if (this.isThisDefinitelyAFile(pipelineArg, file)) {
                try {
                    return new FileResourceLoader().load(file.toURI());
                }
                catch (ResourceLoadingException e) {
                    throw new ExitException(1, (Problems)Problem.warning((String)"Failed to load pipeline from file", (Object[])new Object[0]).withChildren(new Problems[]{Problems.caught((Throwable)e)}));
                }
            }
            return new StringResource(URI.create("command-line-argument"), pipelineArg);
        }
    }

    @CommandLine.Command(name="info")
    public static class StepInfo
    extends EngineOnlyCommand {
        @CommandLine.Parameters(arity="1", index="0")
        public String stepId;

        public Object doCommand(Engine useEngine) {
            Step step = (Step)ApplicationCommand.getObject((IdentifiedCollection)useEngine.getPipelineSteps(), (String)this.stepId, (ProblemSink)this.getTerminal());
            List parameters = step.getParameterSet().toList();
            return Table.fromList((List)parameters, Parameter.class, (MessageSource)this.getMessages().getLabels(), Arrays.asList(Table.Property.of((String)"name", Parameter::getName), Table.Property.of((String)"typeName", Parameter::getTypeName), Table.Property.of((String)"arity", Parameter::getArity), Table.Property.of((String)"description", p -> this.getMessages().getHelpMessage((Object)step, new String[]{"params", p.getName()}).orElse(null))));
        }
    }

    @CommandLine.Command(name="list")
    public static class StepList
    extends EngineOnlyCommand {
        public Object doCommand(Engine useEngine) {
            PipelineSteps steps = useEngine.getPipelineSteps();
            return Table.fromList((List)steps.getAll(), Step.class, (MessageSource)this.getMessages().getLabels(), Arrays.asList(Table.Property.of((String)"id", Identified::getId), Table.Property.of((String)"inputNames", s -> {
                if (s.getInputNames().isEmpty()) {
                    return "";
                }
                return s.getInputNames().toString();
            }), Table.Property.of((String)"description", s -> this.getMessages().getHelpMessage(s, new String[]{"description"}).orElse(null))));
        }
    }

    @CommandLine.Command(name="step", subcommands={StepList.class, StepInfo.class})
    public static class StepCmd
    extends StubCommand {
    }
}

