/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.cli.Table;
import nz.org.riskscape.picocli.CommandLine;

public class MarkdownHelper {
    private StringBuilder builder = new StringBuilder();

    public String build() {
        return this.builder.toString();
    }

    public void addHeading(String text) {
        this.addHeading(text, 1);
    }

    public void addHeading(String text, int level) {
        this.addLine("#".repeat(level) + " " + text);
    }

    public void addLine() {
        this.addLine("");
    }

    public void addLine(String text) {
        this.addText(text + "\n\n");
    }

    public void addText(String text) {
        this.builder.append(text);
    }

    public void addTable(Table table) {
        this.addTable(table, Optional.empty());
    }

    public void addTable(Table table, Optional<String> emptyTableMessage) {
        List header = table.getHeader();
        List rows = table.getRows();
        List<String> stringHeader = header.stream().map(CommandLine.Help.Ansi.Text::plainString).toList();
        if (rows.isEmpty()) {
            emptyTableMessage.ifPresent(msg -> this.addLine((String)msg));
            return;
        }
        this.builder.append(this.markdownRow(stringHeader));
        this.builder.append(this.markdownRow(Collections.nCopies(stringHeader.size(), "---")));
        for (List row : rows) {
            List<String> stringRow = this.buildRow(row);
            this.builder.append(this.markdownRow(stringRow));
        }
    }

    private List<String> buildRow(List<CommandLine.Help.Ansi.Text> row) {
        return row.stream().map(CommandLine.Help.Ansi.Text::plainString).map(col -> {
            StringBuilder sb = new StringBuilder();
            String[] lines = col.split("\n");
            boolean first = true;
            boolean list = false;
            for (String line : lines) {
                if ((line = line.trim()).startsWith("-")) {
                    if (!list) {
                        sb.append("<ul>");
                        list = true;
                    }
                    sb.append("<li>").append(line.substring(1)).append("</li>");
                } else {
                    if (list) {
                        sb.append("</ul>");
                        list = false;
                    } else if (!first) {
                        sb.append("<br><br>");
                    }
                    sb.append(line);
                }
                first = false;
            }
            if (list) {
                sb.append("</ul>");
            }
            return sb.toString();
        }).toList();
    }

    private String markdownRow(List<String> row) {
        return "| " + String.join((CharSequence)" | ", row) + " |\n";
    }

    public Path writeToFile(Path path, String filename) throws IOException {
        Files.createDirectories(path, new FileAttribute[0]);
        return Files.writeString(path.resolve(filename), (CharSequence)this.builder, new OpenOption[0]);
    }
}

