/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import it.geosolutions.jaiext.JAIExt;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import lombok.Generated;
import nz.org.riskscape.engine.BuildInfo;
import nz.org.riskscape.engine.DefaultEngine;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.cli.ApplicationCommand;
import nz.org.riskscape.engine.cli.BaseTerminal;
import nz.org.riskscape.engine.cli.BetaCommand;
import nz.org.riskscape.engine.cli.BookmarksCommand;
import nz.org.riskscape.engine.cli.ChildCommand;
import nz.org.riskscape.engine.cli.CliBootstrap;
import nz.org.riskscape.engine.cli.CliRoot;
import nz.org.riskscape.engine.cli.DocsCommand;
import nz.org.riskscape.engine.cli.EngineCommand;
import nz.org.riskscape.engine.cli.ExitCode;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.cli.ExpressionCommand;
import nz.org.riskscape.engine.cli.FormatsCommand;
import nz.org.riskscape.engine.cli.FunctionCommand;
import nz.org.riskscape.engine.cli.I18nCommand;
import nz.org.riskscape.engine.cli.InvalidUsageException;
import nz.org.riskscape.engine.cli.JlineTerminal;
import nz.org.riskscape.engine.cli.PipelineCommand;
import nz.org.riskscape.engine.cli.ResourceCommand;
import nz.org.riskscape.engine.cli.StubCommand;
import nz.org.riskscape.engine.cli.Table;
import nz.org.riskscape.engine.cli.TerminalCommand;
import nz.org.riskscape.engine.cli.TypeRegistryCommand;
import nz.org.riskscape.engine.cli.TypesCommand;
import nz.org.riskscape.engine.cli.model.ModelCommand;
import nz.org.riskscape.engine.i18n.Messages;
import nz.org.riskscape.engine.plugin.Plugin;
import nz.org.riskscape.engine.plugin.PluginRepository;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.spi.CliCommand;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.Problem;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Main
implements CommandLine.IVersionProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    public static final String COPYRIGHT_NOTICE = Main.readTextFile("COPYRIGHT");
    public static final String LICENSE_NOTICE = Main.readTextFile("LICENSE");
    public static final String CLI_HELP_RESOURCE_BUNDLE_NAME = "cli-help";
    protected CommandLine cmd;
    private final Terminal jlineTerminal;
    protected final nz.org.riskscape.cli.Terminal terminal;
    protected final Messages messages;
    protected final Consumer<Integer> exithook;
    protected final PluginRepository pluginRepository;
    protected final CliBootstrap bootstrap;

    private static String readTextFile(String filename) {
        try {
            File file = Main.lookupApplicationHome().resolve(filename).toFile();
            if (!file.exists() || !file.canRead()) {
                return "";
            }
            return CharStreams.toString((Readable)new FileReader(file));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void main(String[] args) {
        System.setProperty("hsqldb.reconfig_logging", "false");
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        JAIExt.initJAIEXT();
        Main main = new Main();
        try {
            main.runMain(args);
        }
        catch (Exception ex) {
            main.unhandledException(ex, Main.showStackTrace(args));
        }
        try {
            main.jlineTerminal.close();
        }
        catch (IOException e) {
            System.err.format("RiskScape could not shutdown properly due to an unexpected error%n", new Object[0]);
            e.printStackTrace(System.err);
        }
    }

    public Main() {
        this.bootstrap = CliBootstrap.getInstance();
        this.jlineTerminal = this.buildJlineTerminal();
        this.messages = this.bootstrap.getMessages();
        this.terminal = new JlineTerminal(this.jlineTerminal, this.messages);
        this.exithook = code -> System.exit(code);
        this.pluginRepository = PluginRepository.INSTANCE;
    }

    public static Path lookupApplicationHome() {
        Path path;
        String appHome = System.getProperty("riskscape.app_home");
        if (Strings.isNullOrEmpty((String)appHome)) {
            System.err.println("WARNING: riskscape.app_home property is not set, bad things likely to happen");
            appHome = ".";
        }
        if (!Files.isDirectory(path = Paths.get(appHome, new String[0]), new LinkOption[0])) {
            System.err.println(String.format("WARNING: riskscape.app_home '%s' does not exist, bad things likely to happen", path));
        }
        return path;
    }

    public String[] getVersion() throws Exception {
        ArrayList versionInfo = Lists.newArrayList();
        DefaultEngine engine = this.bootstrap.buildEngine();
        BuildInfo buildInfo = engine.getBuildInfo();
        String engineVersion = "RiskScape Core Engine v" + buildInfo.getVersion();
        versionInfo.add(engineVersion);
        versionInfo.add(String.join((CharSequence)"", Collections.nCopies(engineVersion.length(), "-")));
        versionInfo.add("Build time - " + String.valueOf(buildInfo.getBuildTime()));
        versionInfo.add("Git SHA1   - " + buildInfo.getCommitInfo());
        versionInfo.add("");
        versionInfo.add("Plugins:");
        for (Plugin plugin : engine.getPlugins()) {
            versionInfo.add(String.join((CharSequence)"  ", String.format("%-11s", plugin.getId()), plugin.getDescriptor().getVersion(), plugin.getDescriptor().getPluginClassName()));
        }
        versionInfo.add("");
        versionInfo.add("System:");
        versionInfo.add(String.join((CharSequence)" ", System.getProperty("os.name"), System.getProperty("os.version")));
        versionInfo.add(String.join((CharSequence)" ", "Java", System.getProperty("java.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version")));
        return versionInfo.toArray(new String[versionInfo.size()]);
    }

    public void runMain(String[] args) throws Exception {
        try {
            AutoCloseable closeable;
            if (this.terminal instanceof BaseTerminal) {
                ((BaseTerminal)this.terminal).showStackTrace = Main.showStackTrace(args);
            }
            this.bootstrap.setLogLevel(args);
            this.bootstrap.setApplicationHome(Main.lookupApplicationHome());
            this.bootstrap.setPluginRepository(this.pluginRepository);
            this.bootstrap.setTerminal(this.terminal);
            log.info("RiskScape engine started with {} Mb max memory", (Object)(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
            CliRoot cliRootFirstPass = this.doInitialParse(args);
            if (cliRootFirstPass == null) {
                this.processResult(new ExitCode(1));
                return;
            }
            if (cliRootFirstPass.licenseRequested) {
                this.showLicense();
                return;
            }
            this.bootstrap.setRootOptions(cliRootFirstPass);
            this.bootstrap.initializePlugins();
            OsUtils.checkConsoleCompatibility();
            Object commandOrExitCode = this.doSecondParse(args);
            if (!(commandOrExitCode instanceof AutoCloseable)) {
                closeable = null;
            } else {
                closeable = (AutoCloseable)commandOrExitCode;
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            closeable.close();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            Object result = commandOrExitCode instanceof ExitCode ? commandOrExitCode : this.runCommand(commandOrExitCode);
            this.processResult(result);
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (ExitException ex) {
            this.handleExitException(ex, Main.showStackTrace(args));
        }
    }

    private void showLicense() {
        this.terminal.getOut().println(LICENSE_NOTICE);
    }

    private Object runCommand(Object command) throws Exception {
        if (command instanceof TerminalCommand) {
            ((TerminalCommand)command).setTerminal(this.terminal);
            ((TerminalCommand)command).setMessages(this.messages);
        }
        if (command instanceof EngineCommand) {
            DefaultEngine engine = this.bootstrap.buildEngine();
            EngineCommand engineCommand = (EngineCommand)command;
            engineCommand.setEngine((Engine)engine);
        }
        if (command instanceof ApplicationCommand) {
            Project project = this.bootstrap.buildProject();
            ApplicationCommand projectCommand = (ApplicationCommand)command;
            projectCommand.setProject(project);
        }
        if (command instanceof ChildCommand) {
            return ((ChildCommand)command).run();
        }
        throw new RuntimeException("Bad command object - " + String.valueOf(command) + " must implement ChildCommand to be executed");
    }

    private Object doSecondParse(String[] args) {
        CommandLine cl = this.newCommandLine();
        this.addSubcommands(cl);
        cl = this.applyDefaults(cl);
        CommandLine.ParseResult parsed = (CommandLine.ParseResult)cl.parseWithHandler(r -> r, args);
        if (parsed == null) {
            return new ExitCode(1);
        }
        List asCommandLineList = parsed.asCommandLineList();
        CommandLine lastCommandLine = (CommandLine)asCommandLineList.get(asCommandLineList.size() - 1);
        if (CommandLine.printHelpIfRequested((List)asCommandLineList, (PrintStream)this.terminal.getOut(), (PrintStream)this.terminal.getErr(), (CommandLine.Help.Ansi)CommandLine.Help.Ansi.AUTO)) {
            return new ExitCode(0);
        }
        if (lastCommandLine.getCommand() instanceof StubCommand) {
            this.terminal.getErr().println("Error: No subcommand argument given");
            CommandLine.usage((Object)lastCommandLine, (PrintStream)this.terminal.getErr(), (CommandLine.Help.Ansi)CommandLine.Help.Ansi.AUTO);
            return new ExitCode(1);
        }
        if (asCommandLineList.size() > 2 && ((CommandLine)asCommandLineList.get(1)).getCommand() instanceof BetaCommand && ((CommandLine)asCommandLineList.get(2)).getCommand() instanceof ModelCommand) {
            this.terminal.printProblems(new Problem[]{GeneralProblems.get().deprecated((Object)"`riskscape beta model ...`", (Object)"`riskscape model ...`")});
        }
        return lastCommandLine.getCommand();
    }

    private void addSubcommands(CommandLine cl) {
        this.addSubcommand(cl, (Object)new BookmarksCommand());
        this.addSubcommand(cl, (Object)new FunctionCommand());
        this.addSubcommand(cl, (Object)new ModelCommand());
        this.addSubcommand(cl, (Object)new BetaCommand());
        this.addSubcommand(cl, (Object)new TypesCommand());
        this.addSubcommand(cl, (Object)new TypeRegistryCommand());
        this.addSubcommand(cl, (Object)new ResourceCommand());
        this.addSubcommand(cl, (Object)new PipelineCommand());
        this.addSubcommand(cl, (Object)new ExpressionCommand());
        this.addSubcommand(cl, new I18nCommand());
        this.addSubcommand(cl, (Object)new FormatsCommand());
        this.addSubcommand(cl, (Object)new DocsCommand());
        for (CliCommand cliCommand : this.bootstrap.getExtensionPoints().getFeaturesOfType(CliCommand.class)) {
            this.addSubcommand(cl, cliCommand.newInstance());
        }
    }

    private void addSubcommand(CommandLine cl, Object command) {
        String name = command.getClass().getAnnotation(CommandLine.Command.class).name();
        CommandLine existing = (CommandLine)cl.getSubcommands().get(name);
        if (existing != null) {
            this.terminal.getErr().format("WARNING: Ignoring command '%s' named '%s' - already added by '%s'%n", command, name, existing.getCommand());
        } else {
            cl.addSubcommand(name, command);
        }
    }

    private CommandLine newCommandLine() {
        return new CommandLine((Object)new CliRoot());
    }

    private CommandLine applyDefaults(CommandLine cl) {
        ResourceBundle cliHelpResourceBundle = this.bootstrap.getMessages().getResourceBundle(CLI_HELP_RESOURCE_BUNDLE_NAME, this.terminal.getLocale());
        cl.setResourceBundle(cliHelpResourceBundle);
        cl.setCaseInsensitiveEnumValuesAllowed(true);
        cl.getHelpSectionMap().put("footer", help -> OsUtils.LINE_SEPARATOR + COPYRIGHT_NOTICE);
        return cl;
    }

    private CliRoot doInitialParse(String[] args) {
        CommandLine cl = this.applyDefaults(this.newCommandLine());
        cl.setStopAtUnmatched(true);
        CommandLine.ParseResult parsed = (CommandLine.ParseResult)cl.parseWithHandler(p -> p, args);
        if (parsed == null) {
            return null;
        }
        return (CliRoot)((Object)((CommandLine)parsed.asCommandLineList().get(0)).getCommand());
    }

    private static boolean showStackTrace(String[] args) {
        for (String arg : args) {
            if (!"--show-stacktrace".equals(arg) && !"-e".equals(arg)) continue;
            return true;
        }
        return false;
    }

    protected void handleExitException(ExitException ex, boolean showStackTrace) {
        ex.toExitCode(this.messages).action(this.terminal.getErr(), () -> {
            if (ex.getProblem() == ExitException.NO_PROBLEM) {
                return;
            }
            if (ex instanceof InvalidUsageException) {
                Object command = ((InvalidUsageException)ex).getCommand();
                CommandLine cl = new CommandLine(command);
                cl.usage(this.terminal.getErr());
            } else if (showStackTrace) {
                if (ex.getCause() != null) {
                    StackTraceElement[] stack = ex.getStackTrace();
                    if (stack != null && stack.length > 0) {
                        this.terminal.getErr().println("Exit exception thrown from " + stack[0].toString());
                    }
                    this.terminal.getErr().println("Caused by:");
                    ex.getCause().printStackTrace(this.terminal.getErr());
                } else {
                    ex.printStackTrace(this.terminal.getErr());
                }
            }
        }, this.exithook);
    }

    protected void unhandledException(Exception ex, boolean showStackTrace) {
        String messageStart = "There was an unexpected error while running Riskscape. ";
        String message = showStackTrace ? messageStart + "Detailed error information follows. Please include this information with a bug report, as well as the command you were running and any relevant model data." : messageStart + "Set --show-stacktrace to show detailed error information.";
        this.terminal.getErr().println(message);
        if (showStackTrace) {
            this.terminal.getErr().println(this.messages.renderProblem((Throwable)ex).toString());
            ex.printStackTrace(this.terminal.getErr());
        }
        this.exithook.accept(1);
    }

    public void processResult(Object result) {
        if (result != null) {
            if (result instanceof ExitCode) {
                ExitCode exitCode = (ExitCode)result;
                exitCode.action(this.terminal.getErr(), null, this.exithook);
            } else if (result instanceof String) {
                this.terminal.getOut().println(result);
            } else if (result instanceof Problem) {
                this.terminal.getErr().println(this.messages.renderProblem((Problem)result));
                this.exithook.accept(1);
            } else if (result instanceof Table) {
                ((Table)result).print(this.terminal);
            } else if (result != null) {
                throw new RuntimeException("unhandled return object: " + String.valueOf(result));
            }
        }
    }

    private Terminal buildJlineTerminal() {
        try {
            return TerminalBuilder.builder().system(true).build();
        }
        catch (IOException e) {
            System.err.format("RiskScape could not start due to an unexpected error: %s%n", e.getMessage());
            e.printStackTrace(System.err);
            System.exit(-1);
            return null;
        }
    }

    @Generated
    public Main(Terminal jlineTerminal, nz.org.riskscape.cli.Terminal terminal, Messages messages, Consumer<Integer> exithook, PluginRepository pluginRepository, CliBootstrap bootstrap) {
        this.jlineTerminal = jlineTerminal;
        this.terminal = terminal;
        this.messages = messages;
        this.exithook = exithook;
        this.pluginRepository = pluginRepository;
        this.bootstrap = bootstrap;
    }
}

