/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.cli.AnsiPrintStream;
import nz.org.riskscape.engine.cli.BaseTerminal;
import nz.org.riskscape.engine.cli.ReadlineInterruptedException;
import nz.org.riskscape.engine.i18n.Messages;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.Status;

public class JlineTerminal
extends BaseTerminal {
    private final Terminal jlineTerminal;
    private final LineReader lineReader;
    private final PrintStream err;
    private final AnsiPrintStream ansiErr;
    private final PrintStream out;
    private final AnsiPrintStream ansiOut;
    private final InputStream in;
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public JlineTerminal(Terminal jlineTerminal, Messages messages) {
        super(messages);
        this.jlineTerminal = jlineTerminal;
        this.lineReader = LineReaderBuilder.builder().terminal(jlineTerminal).build();
        this.err = JlineTerminal.wrapAsUncloseable(System.err);
        this.ansiErr = new AnsiPrintStream(this.getAnsi(), System.err);
        this.out = JlineTerminal.wrapAsUncloseable(new PrintStream(jlineTerminal.output()));
        this.ansiOut = new AnsiPrintStream((nz.org.riskscape.cli.Terminal)this);
        this.in = jlineTerminal.input();
        jlineTerminal.handle(Terminal.Signal.INT, sig -> this.getFallbackHandler().handleInterrupt());
    }

    public String readline() throws IOException {
        try {
            return this.lineReader.readLine();
        }
        catch (UserInterruptException e) {
            throw new ReadlineInterruptedException();
        }
    }

    public int getDisplayWidth() {
        if (!this.isTTY()) {
            return 80;
        }
        return this.jlineTerminal.getWidth();
    }

    public int getDisplayHeight() {
        if (!this.isTTY()) {
            return Integer.MAX_VALUE;
        }
        return this.jlineTerminal.getHeight();
    }

    @Override
    public boolean isTTY() {
        return this.jlineTerminal.getWidth() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus(List<String> lines) {
        if (this.stopped.get()) {
            return;
        }
        List attributedStrings = null;
        if (lines != null) {
            attributedStrings = lines.stream().map(line -> AttributedString.fromAnsi((String)line)).collect(Collectors.toList());
        }
        Status status = Status.getStatus((Terminal)this.jlineTerminal);
        JlineTerminal jlineTerminal = this;
        synchronized (jlineTerminal) {
            if (lines == null || lines.isEmpty()) {
                status.reset();
            } else {
                if (status.size() > attributedStrings.size()) {
                    status.clear();
                }
                status.update(attributedStrings);
            }
        }
    }

    @Override
    void doExit() {
        this.stopped.set(true);
        try {
            this.jlineTerminal.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.doExit();
    }

    @Generated
    public PrintStream getErr() {
        return this.err;
    }

    @Generated
    public AnsiPrintStream getAnsiErr() {
        return this.ansiErr;
    }

    @Generated
    public PrintStream getOut() {
        return this.out;
    }

    @Generated
    public AnsiPrintStream getAnsiOut() {
        return this.ansiOut;
    }

    @Generated
    public InputStream getIn() {
        return this.in;
    }
}

