/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class InterruptibleReadline {
    private static final long MILLIS_BETWEEN_STDIN_CHECKS = 10L;

    public static String readline(InputStream stdin) throws IOException, InterruptedException {
        if (!stdin.markSupported()) {
            throw new IllegalArgumentException("stdin must support mark");
        }
        StringBuffer stringBuffer = new StringBuffer(512);
        byte[] bytes = new byte[64];
        int bytesRead = 0;
        while (true) {
            if (stdin.available() > 0) {
                int byteRead = stdin.read();
                if (byteRead == -1) {
                    throw new EOFException();
                }
                if (byteRead == 10) break;
                if (byteRead == 13) {
                    if (stdin.available() == 0) break;
                    stdin.mark(1);
                    if (stdin.read() == 10) break;
                    stdin.reset();
                    break;
                }
                bytes[bytesRead++] = (byte)byteRead;
                if (bytesRead != bytes.length) continue;
                stringBuffer.append(new String(bytes, 0, bytesRead));
                bytesRead = 0;
                continue;
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread.sleep(10L);
        }
        stringBuffer.append(new String(bytes, 0, bytesRead));
        return stringBuffer.toString();
    }
}

