/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import lombok.Generated;
import nz.org.riskscape.cli.Terminal;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.FileProblems;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.cli.ChildCommand;
import nz.org.riskscape.engine.cli.EngineCommand;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.cli.TerminalCommand;
import nz.org.riskscape.engine.i18n.DefaultMessages;
import nz.org.riskscape.engine.i18n.Messages;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.Problems;

@CommandLine.Command(name="i18n")
public class I18nCommand
implements ChildCommand,
EngineCommand,
TerminalCommand {
    public static final List<Character> ESCAPE_IN_VALUE = Arrays.asList(Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\t'), Character.valueOf('!'), Character.valueOf(':'), Character.valueOf('#'), Character.valueOf('='), Character.valueOf('\f'));
    public static final List<Character> ESCAPE_IN_KEY = Arrays.asList(Character.valueOf(' '), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\t'), Character.valueOf('!'), Character.valueOf(':'), Character.valueOf('#'), Character.valueOf('='), Character.valueOf('\f'));
    private Engine engine;
    private Terminal terminal;
    private Messages messages;
    @CommandLine.Option(names={"--newline-char"}, required=false)
    String newline = OsUtils.LINE_SEPARATOR;
    @CommandLine.Option(names={"--indent"}, required=false, defaultValue="  ")
    String indent;
    @CommandLine.Option(names={"--locale"})
    String locale;
    @CommandLine.Option(names={"-o", "--output-dir"}, defaultValue=".")
    File outputDir;

    public Object run() {
        DefaultMessages defaultMessages = (DefaultMessages)this.getMessages();
        Locale l = Locale.getDefault();
        Set bundles = defaultMessages.getKnownBundleNames(this.engine.getExtensionPoints());
        for (String bundleName : bundles) {
            ResourceBundle bundle = defaultMessages.newMessageSource(bundleName).getBundle(l);
            String baseName = bundle.getBaseBundleName();
            File outputFile = new File(this.outputDir, baseName + (String)(this.locale == null ? "" : "_" + this.locale) + ".properties");
            try {
                PrintStream writer = new PrintStream(outputFile, "UTF-8");
                int keyCount = this.writeBundles(writer, bundle);
                writer.close();
                this.printerr("Wrote %d keys for %s", new Object[]{keyCount, baseName});
                this.print(outputFile.getAbsolutePath(), new Object[0]);
            }
            catch (IOException e) {
                throw new ExitException((Problems)FileProblems.get().cantWriteTo(outputFile.toPath()).withChildren(new Problems[]{Problems.caught((Throwable)e)}), (Throwable)e);
            }
        }
        return null;
    }

    private int writeBundles(PrintStream writer, ResourceBundle bundle) throws IOException {
        Enumeration<String> keys = bundle.getKeys();
        int counter = 0;
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object value = bundle.getObject(key);
            if (value instanceof String) {
                writer.append(this.escape(key, ESCAPE_IN_KEY)).append(" = \\").append(this.newline);
                writer.append(this.indent).append(this.escape(value.toString(), ESCAPE_IN_VALUE)).append(this.newline).append(this.newline);
            } else if (value != null) {
                writer.append("# unrecognised resource in bundle " + String.valueOf(bundle) + " - " + String.valueOf(value.getClass())).append(this.newline).append(this.newline);
            }
            ++counter;
        }
        return counter;
    }

    private String escape(String string, List<Character> escapeChars) {
        StringBuffer buf = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (escapeChars.contains(Character.valueOf(ch))) {
                buf.append('\\');
            }
            buf.append(ch);
            if (ch != '\n') continue;
            buf.append(this.indent);
        }
        return buf.toString();
    }

    @Generated
    public Engine getEngine() {
        return this.engine;
    }

    @Generated
    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    @Generated
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Generated
    public void setTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    @Generated
    public Messages getMessages() {
        return this.messages;
    }

    @Generated
    public void setMessages(Messages messages) {
        this.messages = messages;
    }
}

