/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.Reference;
import nz.org.riskscape.engine.cli.ApplicationCommand;
import nz.org.riskscape.engine.cli.StubCommand;
import nz.org.riskscape.engine.cli.Table;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.i18n.Messages;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.ProblemSink;

@CommandLine.Command(name="function", subcommands={FunctionListCommand.class, FunctionInfoCommand.class})
public class FunctionCommand
extends StubCommand {

    @CommandLine.Command(name="info")
    public static class FunctionInfoCommand
    extends ApplicationCommand {
        @CommandLine.Parameters
        public String functionId;

        public Object doCommand(Project project) {
            IdentifiedFunction f = (IdentifiedFunction)ApplicationCommand.getObject((IdentifiedCollection)project.getFunctionSet(), (String)this.functionId, (ProblemSink)this.getTerminal());
            Table table = new Table(Table.rowToText((List)Lists.newArrayList((Object[])new String[]{"name", f.getId()}), (CommandLine.Help.Ansi.IStyle[])new CommandLine.Help.Ansi.IStyle[0]), Table.rowsToText((List)Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"description", this.getDetailedHelp(f, new String[]{"description"}).orElse(f.getDescription())}), Lists.newArrayList((Object[])new String[]{"source", f.getSource().toString()}), Lists.newArrayList((Object[])new String[]{"argument-types", f.getArguments().toString()}), Lists.newArrayList((Object[])new String[]{"return-type", f.getReturnType().toString()})}), (CommandLine.Help.Ansi.IStyle[])new CommandLine.Help.Ansi.IStyle[0]));
            return table;
        }
    }

    @CommandLine.Command(name="list")
    public static class FunctionListCommand
    extends ApplicationCommand {
        @CommandLine.Option(names={"-c", "--category"}, paramLabel="<category>")
        List<IdentifiedFunction.Category> categories = Lists.newArrayList((Object[])new IdentifiedFunction.Category[]{IdentifiedFunction.Category.RISK_MODELLING, IdentifiedFunction.Category.UNASSIGNED});
        @CommandLine.Option(names={"--all"})
        public boolean all;

        public Object doCommand(Project project) {
            Messages messages = this.getMessages();
            List<Reference<IdentifiedFunction>> functions = this.filterFunctions(project.getFunctionSet().getReferences());
            return Table.fromList(functions, IdentifiedFunction.class, (MessageSource)messages.getLabels(), Arrays.asList(Table.Property.of((String)"id", Reference::getId), this.asPropertyWithProblems("description", idf -> this.getDescription((IdentifiedFunction)idf)), Table.Property.of((String)"arguments", ref -> (String)ref.getResult().map(idf -> idf.getArguments().toString()).orElse((Object)"")), Table.Property.of((String)"return-type", ref -> (String)ref.getResult().map(idf -> idf.getReturnType().toString()).orElse((Object)"")), Table.Property.of((String)"category", ref -> (String)ref.getResult().map(idf -> idf.getCategory().toString()).orElse((Object)""))));
        }

        private String getDescription(IdentifiedFunction function) {
            String description = this.getMessages().getHelpMessage((Object)function, new String[]{"description"}).orElse(null);
            if (description == null) {
                description = function.getDescription();
            }
            return description == null ? "" : description;
        }

        List<Reference<IdentifiedFunction>> filterFunctions(List<Reference<IdentifiedFunction>> allFunctions) {
            if (this.all || this.categories == null || this.categories.isEmpty()) {
                return allFunctions;
            }
            return allFunctions.stream().filter(ref -> (Boolean)ref.getResult().map(idf -> this.categories.contains(idf.getCategory())).orElse((Object)true)).collect(Collectors.toList());
        }
    }
}

