/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.NoSuchObjectException;
import nz.org.riskscape.engine.Reference;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.cli.EngineOnlyCommand;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.cli.StubCommand;
import nz.org.riskscape.engine.cli.Table;
import nz.org.riskscape.engine.data.BookmarkResolver;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;

@CommandLine.Command(name="format", subcommands={FormatInfo.class, Save.class, FormatListCommand.class})
public class FormatsCommand
extends StubCommand {

    @CommandLine.Command(name="save", subcommands={OutputOptions.class})
    public static class Save
    extends StubCommand {

        @CommandLine.Command(name="options")
        public static class OutputOptions
        extends BaseFormatCommand {
            @CommandLine.Parameters(index="0")
            private String name;

            public Table doCommand(Engine engine) {
                Format format;
                try {
                    format = (Format)engine.getFormats().get(this.name, ProblemSink.DEVNULL);
                }
                catch (NoSuchObjectException e) {
                    throw new ExitException((Problems)Problems.caught((Throwable)e));
                }
                BindingContext bindingContext = engine.newBindingContext();
                JavaParameterSet parameterSet = JavaParameterSet.fromBindingClass((Class)format.getWriterOptionsClass());
                return Table.fromList(parameterSet.getDeclared().stream().toList(), Parameter.class, (MessageSource)this.getMessages().getLabels(), Arrays.asList(Table.Property.of((String)"parameter", Parameter::getName), Table.Property.of((String)"description", p -> this.getDescription((Parameter)p, format, bindingContext))));
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }
        }
    }

    @CommandLine.Command(name="info")
    public static class FormatInfo
    extends BaseFormatCommand {
        @CommandLine.Parameters(index="0")
        private String name;

        public Object doCommand(Engine engine) {
            BookmarkResolver formatResolver = this.getResolver(engine, this.name);
            if (formatResolver == null) {
                throw new ExitException((Problems)GeneralProblems.get().noSuchObjectExistsDidYouMean(this.name, Format.class, engine.getBookmarkResolvers().getSupportedFormats()));
            }
            BindingContext bindingContext = engine.newBindingContext();
            return Table.fromList(formatResolver.getParameterSet().getDeclared().stream().toList(), Parameter.class, (MessageSource)this.getMessages().getLabels(), Arrays.asList(Table.Property.of((String)"parameter", Parameter::getName), Table.Property.of((String)"description", p -> this.getDescription((Parameter)p, formatResolver, bindingContext))));
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }
    }

    @CommandLine.Command(name="list")
    public static class FormatListCommand
    extends BaseFormatCommand {
        public Object doCommand(Engine engine) {
            HashMap formatsMap = new HashMap();
            List outputFormats = engine.getFormats().getReferences().stream().map(Reference::getId).collect(Collectors.toList());
            for (BookmarkResolver resolver : engine.getBookmarkResolvers().getAll()) {
                for (String format2 : resolver.getFormats()) {
                    HashSet valueSet = new HashSet(resolver.getExtensions(format2));
                    formatsMap.put(format2, valueSet);
                }
            }
            return Table.fromList(new ArrayList(formatsMap.keySet()), FormatsCommand.class, (MessageSource)this.getMessages().getLabels(), Arrays.asList(Table.Property.of((String)"format", format -> format), Table.Property.of((String)"file extension", format -> String.join((CharSequence)", ", (Iterable)formatsMap.get(format))), Table.Property.of((String)"supports", format -> outputFormats.contains(format) ? "input and output data" : "input data")));
        }
    }

    public static abstract class BaseFormatCommand
    extends EngineOnlyCommand {
        public BookmarkResolver getResolver(Engine engine, String format) {
            for (BookmarkResolver resolver : engine.getBookmarkResolvers().getAll()) {
                if (!resolver.getFormats().contains(format)) continue;
                return resolver;
            }
            return null;
        }

        protected String getDescription(Parameter param, Object owner, BindingContext bindingContext) {
            String description = this.getMessages().getHelpMessage(owner, new String[]{"params", param.getName()}).orElse("");
            if (param.hasDefaultValue()) {
                description = String.format("%s(default: %s)", Strings.isNullOrEmpty((String)description) ? "" : description + " ", param.getDefaultValues(bindingContext).stream().map(o -> this.getMessages().renderObject(o, this.getTerminal().getLocale())).collect(Collectors.joining(", ")));
            }
            return description;
        }
    }
}

