/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.util.List;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.cli.ApplicationCommand;
import nz.org.riskscape.engine.cli.StubCommand;
import nz.org.riskscape.engine.rl.EvalException;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.BinaryOperation;
import nz.org.riskscape.rl.ast.BracketedExpression;
import nz.org.riskscape.rl.ast.Constant;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.ListDeclaration;
import nz.org.riskscape.rl.ast.PropertyAccess;
import nz.org.riskscape.rl.ast.StructDeclaration;

@CommandLine.Command(name="expression", aliases={"expr"}, subcommands={Eval.class, Inspect.class})
public class ExpressionCommand
extends StubCommand {

    @CommandLine.Command(name="inspect")
    public static class Inspect
    extends ApplicationCommand {
        @CommandLine.Parameters(arity="1", paramLabel="<expression>")
        String expression;

        public Object doCommand(Project useProject) {
            ExpressionRealizer realizer = useProject.newRealizationContext().getExpressionRealizer();
            ResultOrProblems re = realizer.realize((Type)Struct.EMPTY_STRUCT, this.expression);
            if (re.isPresent()) {
                RealizedExpression expr = (RealizedExpression)re.get();
                return this.prettyPrint(expr);
            }
            return Problem.composite((List)re.getProblems(), (String)"Failed to evaluate expression", (Object[])new Object[0]);
        }

        private String prettyPrint(RealizedExpression expr) {
            StringBuilder str = new StringBuilder();
            this.prettyPrint("root", expr, "", str);
            return str.toString();
        }

        private void prettyPrint(String name, RealizedExpression rExpr, String indent, StringBuilder str) {
            Expression expr = rExpr.getExpression();
            String nl = OsUtils.LINE_SEPARATOR;
            str.append(indent).append(name).append(": ").append(expr.getClass().getSimpleName());
            str.append("(").append(rExpr.getResultType()).append(")");
            expr.isA(Constant.class).ifPresent(c -> str.append(" => ").append(c.getToken().rawValue()));
            expr.isA(FunctionCall.class).ifPresent(fc -> {
                str.append(" => ").append(fc.getIdentifier().value).append("(");
                int idx = 0;
                for (FunctionCall.Argument fa : fc.getArguments()) {
                    if (idx != 0) {
                        str.append(", ");
                    }
                    str.append((String)((Object)fa.getName().orElse("arg" + Integer.toString(idx))));
                    ++idx;
                }
                str.append(")");
                str.append(nl);
                idx = 0;
                for (FunctionCall.Argument fa : fc.getArguments()) {
                    String newName = (String)((Object)fa.getName().orElse("arg" + Integer.toString(idx)));
                    this.prettyPrint(newName, (RealizedExpression)rExpr.getDependencies().get(idx), indent + "  ", str);
                    ++idx;
                }
            });
            expr.isA(BinaryOperation.class).ifPresent(bop -> {
                str.append(nl);
                String newIndent = indent + "  ";
                this.prettyPrint("lhs", (RealizedExpression)rExpr.getDependencies().get(0), newIndent, str);
                str.append(newIndent).append(bop.getOperator().value).append(nl);
                this.prettyPrint("rhs", (RealizedExpression)rExpr.getDependencies().get(1), newIndent, str);
            });
            expr.isA(ListDeclaration.class).ifPresent(ld -> {
                int idx = 0;
                str.append(nl);
                for (RealizedExpression element : rExpr.getDependencies()) {
                    this.prettyPrint(Integer.toString(idx), element, indent + "  ", str);
                    ++idx;
                }
            });
            expr.isA(StructDeclaration.class).ifPresent(sd -> {
                Struct struct = (Struct)rExpr.getResultType().find(Struct.class).get();
                int idx = 0;
                str.append(nl);
                for (Struct.StructMember sm : struct.getMembers()) {
                    this.prettyPrint(sm.getKey(), (RealizedExpression)rExpr.getDependencies().get(idx), indent + "  ", str);
                    ++idx;
                }
            });
            expr.isA(PropertyAccess.class).ifPresent(pa -> {
                String ident = pa.getAccessString();
                str.append(" => ").append(ident).append(nl);
                if (pa.getReceiver().isPresent()) {
                    this.prettyPrint("receiver", (RealizedExpression)rExpr.getDependencies().get(0), indent + "  ", str);
                }
            });
            expr.isA(BracketedExpression.class).ifPresent(be -> this.prettyPrint("bracketed", (RealizedExpression)rExpr.getDependencies().get(0), indent + "  ", str));
            if (!str.subSequence(str.length() - nl.length(), str.length()).equals(nl)) {
                str.append(nl);
            }
        }
    }

    @CommandLine.Command(name="eval", aliases={"evaluate"})
    public static class Eval
    extends ApplicationCommand {
        @CommandLine.Parameters(arity="1", paramLabel="<expression>", index="0")
        public String expression;

        public Object doCommand(Project useProject) {
            ExpressionRealizer realizer = useProject.newRealizationContext().getExpressionRealizer();
            ResultOrProblems reOr = realizer.realize((Type)Struct.EMPTY_STRUCT, this.expression);
            if (reOr.isPresent()) {
                String string;
                block9: {
                    RealizedExpression re = (RealizedExpression)reOr.get();
                    try {
                        Object result = re.evaluate((Object)Tuple.of((Struct)Struct.EMPTY_STRUCT));
                        String string2 = string = result == null ? "<nothing>" : result.toString();
                        if (re == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (re != null) {
                                try {
                                    re.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (EvalException e) {
                            return Problems.caught((Throwable)e);
                        }
                    }
                    re.close();
                }
                return string;
            }
            return Problem.composite((List)reOr.getProblems(), (String)"Failed to evaluate expression", (Object[])new Object[0]);
        }
    }
}

