/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.Reference;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.auth.SecretBuilder;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.cli.ApplicationCommand;
import nz.org.riskscape.engine.cli.MarkdownHelper;
import nz.org.riskscape.engine.cli.Table;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.i18n.EnumTranslator;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.i18n.TranslationContext;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.pipeline.Step;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.ResultOrProblems;

@CommandLine.Command(name="docs", hidden=true)
public class DocsCommand
extends ApplicationCommand {
    @CommandLine.Parameters(arity="0..1", index="0")
    public String location;
    private static final Path DEFAULT_ROOT = Path.of("docs", "source", "reference");
    private static final Path FUNCTIONS = Path.of("functions", "generated");
    private static final Path PIPELINES = Path.of("pipelines", new String[0]);
    private static final Path CONFIG = Path.of("config", "generated");

    public Object doCommand(Project project) {
        Path rootPath = this.location == null ? DEFAULT_ROOT : Path.of(this.location, new String[0]);
        Path functionPath = rootPath.resolve(FUNCTIONS);
        Path pipelinePath = rootPath.resolve(PIPELINES);
        TranslationContext translationContext = new TranslationContext(this.getTerminal().getLocale(), this.getMessages().getLabels());
        try {
            this.generateFunctionDocs(project, translationContext, functionPath);
            this.generatePipelineStepDocs(this.getEngine(), pipelinePath);
            this.generateSecretBuilderDocs(this.getEngine(), rootPath.resolve(CONFIG));
            this.generateOutputFormatDocs(this.getEngine(), rootPath.resolve("output-formats"));
        }
        catch (IOException e) {
            return ResultOrProblems.error((RiskscapeException)new RiskscapeIOException("Could not write docs to file resource. Cause: " + e.getMessage(), (Exception)e));
        }
        return "Generated documentation in " + rootPath.toString();
    }

    private void generatePipelineStepDocs(Engine engine, Path pipelinePath) throws IOException {
        MarkdownHelper markdown = new MarkdownHelper();
        markdown.addHeading("Pipeline steps");
        List steps = engine.getPipelineSteps().getAll();
        for (Step step : steps) {
            markdown.addHeading("`" + step.getId() + "`", 2);
            ImmutableList parameters = ImmutableList.copyOf((Collection)step.getParameterSet().getDeclared());
            Table table = Table.fromList((List)parameters, Parameter.class, (MessageSource)this.getMessages().getLabels(), Arrays.asList(Table.Property.of((String)"name", Parameter::getName), Table.Property.of((String)"typeName", p -> "`" + p.getTypeName() + "`"), Table.Property.of((String)"arity", Parameter::getArity), Table.Property.of((String)"description", p -> this.getMessages().getHelpMessage((Object)step, new String[]{"params", p.getName()}).orElse(null))));
            markdown.addTable(table);
            Optional description = this.getDetailedHelp(step, new String[]{"description"});
            if (!description.isPresent()) continue;
            markdown.addLine((String)description.get());
        }
        markdown.writeToFile(pipelinePath, "generated.md");
    }

    private void generateOutputFormatDocs(Engine engine, Path outputDocsPath) throws IOException {
        MarkdownHelper markdown = new MarkdownHelper();
        markdown.addHeading("Save formats");
        BindingContext context = engine.newBindingContext();
        List formats = engine.getFormats().getAll().stream().sorted((b1, b2) -> b1.getId().compareTo(b2.getId())).toList();
        for (Format format : formats) {
            markdown.addHeading(this.inBackticks(format.getId()), 2);
            Optional description = this.getDetailedHelp(format, new String[]{"description"});
            markdown.addLine(description.orElse(""));
            List parameters = JavaParameterSet.fromBindingClass((Class)format.getWriterOptionsClass()).getDeclared().stream().toList();
            Table table = Table.fromList(parameters, Parameter.class, (MessageSource)this.getMessages().getLabels(), Arrays.asList(Table.Property.of((String)"name", p -> this.inBackticks(p.getName())), Table.Property.of((String)"default", p -> this.processDefaultValues(p.getDefaultValues(context))), Table.Property.of((String)"description", p -> this.getMessages().getHelpMessage((Object)format, new String[]{"params", p.getName()}).orElse(""))));
            markdown.addTable(table, Optional.of("Does not support any `save()` step options"));
        }
        markdown.writeToFile(outputDocsPath, "generated.md");
    }

    private void generateFunctionDocs(Project project, TranslationContext context, Path functionPath) throws IOException {
        List functions = project.getFunctionSet().getReferences();
        for (IdentifiedFunction.Category category : IdentifiedFunction.Category.values()) {
            MarkdownHelper markdown = new MarkdownHelper();
            EnumTranslator translator = new EnumTranslator(context);
            String categoryName = translator.getEntry((Enum)category).getLabel(new Object[0]);
            String filename = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, category.name());
            markdown.addHeading(categoryName);
            List<Reference<IdentifiedFunction>> filtered = this.filterFunctions(functions, category);
            for (Reference<IdentifiedFunction> function : filtered) {
                this.addFunction(markdown, function);
            }
            if (filtered.isEmpty()) continue;
            markdown.writeToFile(functionPath, filename + ".md").toString();
        }
    }

    private void addFunction(MarkdownHelper markdown, Reference<IdentifiedFunction> reference) {
        IdentifiedFunction function = (IdentifiedFunction)reference.get();
        markdown.addHeading("`" + function.getId() + "`", 2);
        markdown.addLine("Arguments: `" + function.getArguments().toString() + "`");
        markdown.addLine("Returns: `" + function.getReturnType().toString() + "`");
        markdown.addLine(this.getFunctionDescription(function));
        markdown.addLine();
    }

    private String getFunctionDescription(IdentifiedFunction function) {
        Optional help = this.getDetailedHelp(function, new String[]{"description"});
        if (help.isPresent()) {
            return (String)help.get();
        }
        String description = this.getMessages().getHelpMessage((Object)function, new String[]{"description"}).orElse(null);
        if (description == null) {
            description = function.getDescription();
        }
        return description == null ? "" : description;
    }

    List<Reference<IdentifiedFunction>> filterFunctions(List<Reference<IdentifiedFunction>> allFunctions, IdentifiedFunction.Category category) {
        return allFunctions.stream().filter(ref -> (Boolean)ref.getResult().map(idf -> idf.getCategory().equals((Object)category)).orElse((Object)false)).collect(Collectors.toList());
    }

    private void generateSecretBuilderDocs(Engine engine, Path secretBuilderPath) throws IOException {
        MarkdownHelper markdown = new MarkdownHelper();
        markdown.addHeading("Secret frameworks");
        BindingContext context = engine.newBindingContext();
        List builders = engine.getCollectionByClass(SecretBuilder.class).getAll().stream().sorted((b1, b2) -> b1.getId().compareTo(b2.getId())).toList();
        for (SecretBuilder builder : builders) {
            markdown.addHeading(this.inBackticks(builder.getId()), 2);
            ImmutableList parameters = ImmutableList.copyOf((Collection)builder.getParameters().getDeclared());
            Table table = Table.fromList((List)parameters, Parameter.class, (MessageSource)this.getMessages().getLabels(), Arrays.asList(Table.Property.of((String)"name", p -> this.inBackticks(p.getName())), Table.Property.of((String)"default", p -> this.processDefaultValues(p.getDefaultValues(context))), Table.Property.of((String)"description", p -> this.getMessages().getHelpMessage((Object)builder.getBuildsClass(), new String[]{"params", p.getName()}).orElse(""))));
            markdown.addTable(table);
            Optional description = this.getDetailedHelp(builder.getBuildsClass(), new String[]{"description"});
            markdown.addLine(description.orElse(""));
        }
        markdown.writeToFile(secretBuilderPath, "secret-frameworks.md");
    }

    private String processDefaultValues(List<?> defaults) {
        if (defaults.isEmpty()) {
            return "";
        }
        if (defaults.size() == 1) {
            return this.inBackticks(Objects.toString(defaults.get(0)));
        }
        return this.inBackticks(Objects.toString(defaults));
    }

    private String inBackticks(String toQuote) {
        return "`" + toQuote + "`";
    }
}

