/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import ch.qos.logback.classic.Level;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.cli.Main;
import nz.org.riskscape.engine.cli.StubCommand;
import nz.org.riskscape.picocli.CommandLine;

@CommandLine.Command(name="riskscape", versionProvider=Main.class)
public class CliRoot
extends StubCommand {
    public static final String RISKSCAPE_PROJECT_ENV = "RISKSCAPE_PROJECT";
    public static final String RISKSCAPE_HOME_ENV = "RISKSCAPE_HOME";
    private final Map<String, String> env;
    @CommandLine.Option(names={"-V", "--version"}, versionHelp=true)
    boolean versionRequested;
    @CommandLine.Option(names={"--license"})
    boolean licenseRequested;
    @CommandLine.Option(names={"-e", "--show-stacktrace"})
    private boolean showStackTrace;
    @Deprecated
    @CommandLine.Option(names={"--no-core-plugins"}, hidden=true)
    private boolean disableLoadingCorePlugins;
    @Deprecated
    @CommandLine.Option(names={"-l", "--load-plugin"}, hidden=true)
    private List<Path> pluginPaths = Lists.newArrayList();
    @Deprecated
    @CommandLine.Option(names={"-b", "--home", "-H"}, hidden=true)
    private String homeDir = null;
    @CommandLine.Option(names={"--project", "-P"})
    String projectIni;
    @CommandLine.Option(names={"--log-level"})
    private String logLevel;
    @CommandLine.Option(names={"--random-seed"})
    private Long randomSeed;
    @CommandLine.Option(names={"--pipeline-threads"})
    private Integer pipelineThreads = Runtime.getRuntime().availableProcessors();
    @CommandLine.Option(names={"--experimental-execution"}, hidden=true)
    private boolean experimentalExecution;
    @CommandLine.Option(names={"--show-project-errors"})
    private boolean showProjectErrors;
    @CommandLine.Option(names={"--beta"}, negatable=true)
    private Boolean betaFeaturesEnabled;

    public Level getLogLevel() {
        return this.logLevel == null ? null : Level.toLevel((String)this.logLevel.toUpperCase());
    }

    public CliRoot() {
        this.env = System.getenv();
    }

    CliRoot(Map<String, String> env) {
        this.env = env;
    }

    public boolean isHomeDirSpecified() {
        return this.homeDir != null || this.env != null;
    }

    public Optional<String> getHomeDir() {
        String homeDirValue = this.homeDir;
        if (Strings.isNullOrEmpty((String)homeDirValue)) {
            homeDirValue = this.env.get(RISKSCAPE_HOME_ENV);
        }
        return Optional.ofNullable(homeDirValue);
    }

    public Optional<String> getProjectIni() {
        if (Strings.isNullOrEmpty((String)this.projectIni)) {
            return Optional.ofNullable(this.env.get(RISKSCAPE_PROJECT_ENV));
        }
        return Optional.of(this.projectIni);
    }

    @Generated
    public boolean isShowStackTrace() {
        return this.showStackTrace;
    }

    @Generated
    public void setShowStackTrace(boolean showStackTrace) {
        this.showStackTrace = showStackTrace;
    }

    @Deprecated
    @Generated
    public boolean isDisableLoadingCorePlugins() {
        return this.disableLoadingCorePlugins;
    }

    @Deprecated
    @Generated
    public void setDisableLoadingCorePlugins(boolean disableLoadingCorePlugins) {
        this.disableLoadingCorePlugins = disableLoadingCorePlugins;
    }

    @Deprecated
    @Generated
    public List<Path> getPluginPaths() {
        return this.pluginPaths;
    }

    @Deprecated
    @Generated
    public void setPluginPaths(List<Path> pluginPaths) {
        this.pluginPaths = pluginPaths;
    }

    @Deprecated
    @Generated
    public void setHomeDir(String homeDir) {
        this.homeDir = homeDir;
    }

    @Generated
    public void setProjectIni(String projectIni) {
        this.projectIni = projectIni;
    }

    @Generated
    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    @Generated
    public Long getRandomSeed() {
        return this.randomSeed;
    }

    @Generated
    public void setRandomSeed(Long randomSeed) {
        this.randomSeed = randomSeed;
    }

    @Generated
    public Integer getPipelineThreads() {
        return this.pipelineThreads;
    }

    @Generated
    public void setPipelineThreads(Integer pipelineThreads) {
        this.pipelineThreads = pipelineThreads;
    }

    @Generated
    public boolean isExperimentalExecution() {
        return this.experimentalExecution;
    }

    @Generated
    public void setExperimentalExecution(boolean experimentalExecution) {
        this.experimentalExecution = experimentalExecution;
    }

    @Generated
    public boolean isShowProjectErrors() {
        return this.showProjectErrors;
    }

    @Generated
    public void setShowProjectErrors(boolean showProjectErrors) {
        this.showProjectErrors = showProjectErrors;
    }

    @Generated
    public Boolean getBetaFeaturesEnabled() {
        return this.betaFeaturesEnabled;
    }

    @Generated
    public void setBetaFeaturesEnabled(Boolean betaFeaturesEnabled) {
        this.betaFeaturesEnabled = betaFeaturesEnabled;
    }
}

