/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import ch.qos.logback.classic.Level;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.cli.Terminal;
import nz.org.riskscape.engine.BuildInfo;
import nz.org.riskscape.engine.DefaultEngine;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.ProjectBuilder;
import nz.org.riskscape.engine.RandomSingleton;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.cli.AppLayout;
import nz.org.riskscape.engine.cli.CliPlugin;
import nz.org.riskscape.engine.cli.CliRoot;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.cli.Main;
import nz.org.riskscape.engine.core.EnginePlugin;
import nz.org.riskscape.engine.i18n.DefaultMessages;
import nz.org.riskscape.engine.i18n.Messages;
import nz.org.riskscape.engine.i18n.ResourceClassLoader;
import nz.org.riskscape.engine.ini.IniParser;
import nz.org.riskscape.engine.plugin.ExtensionPoints;
import nz.org.riskscape.engine.plugin.Plugin;
import nz.org.riskscape.engine.plugin.PluginDescriptor;
import nz.org.riskscape.engine.plugin.PluginRepository;
import nz.org.riskscape.engine.plugin.PluginRuntimeException;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.problem.SeverityLevel;
import nz.org.riskscape.engine.resource.UriHelper;
import nz.org.riskscape.engine.spi.EngineBootstrapper;
import nz.org.riskscape.engine.spi.EngineCollection;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliBootstrap {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CliBootstrap.class);
    private static CliBootstrap instance;
    public static final LocalProblems PROBLEMS;
    private ProjectBuilder builder;
    private State state = State.NOTHING;
    private Terminal terminal;
    private CliRoot cliRoot;
    private DefaultEngine engine;
    private Project project;
    private Map<String, List<String>> settings;
    private PluginRepository pluginRepository;
    private ExtensionPoints extensionPoints = new ExtensionPoints();
    private DefaultMessages messages = new DefaultMessages(this.extensionPoints);
    private AppLayout layout;

    public static CliBootstrap getInstance() {
        if (instance == null) {
            instance = new CliBootstrap();
        }
        return instance;
    }

    protected void changeState(State nextState, Runnable callback) {
        if (!nextState.isAllowedFrom(this.state)) {
            throw new RiskscapeException(String.format("Application did not start properly... can not move from '%s' to '%s'", new Object[]{this.state, nextState}));
        }
        callback.run();
        this.state = nextState;
    }

    public void setApplicationHome(Path appHome) {
        this.changeState(State.APPLICATION_HOME_SET, () -> {
            this.layout = new AppLayout(appHome);
        });
    }

    Path getUserRiskScapeHome() {
        return this.cliRoot.getHomeDir().map(v -> Paths.get(v, new String[0])).orElseGet(() -> this.getDefaultUserRiskScapeHome());
    }

    Path getDefaultUserRiskScapeHome() {
        return Paths.get(System.getProperty("user.home"), new String[0]).resolve(OsUtils.isLinux() ? ".config/riskscape" : "RiskScape");
    }

    public void initializePlugins() {
        this.changeState(State.PLUGINS_ACTIVATED, () -> {
            this.pluginRepository.register(EnginePlugin.DESCRIPTOR);
            this.pluginRepository.register(CliPlugin.DESCRIPTOR);
            for (Path plugin : this.cliRoot.getPluginPaths()) {
                if (Files.exists(plugin, new LinkOption[0])) {
                    this.pluginRepository.addPath(plugin.toFile());
                    continue;
                }
                throw new ExitException(1, "Plugin '%s' does not exist", new Object[]{plugin});
            }
            List pluginPaths = this.settings.getOrDefault("global.load-plugin", List.of()).stream().map(path -> this.toPluginPath((String)path)).collect(Collectors.toList());
            if (this.cliRoot.getBetaFeaturesEnabled() == Boolean.TRUE) {
                Path betaPluginPath = this.toPluginPath("beta");
                if (!pluginPaths.contains(betaPluginPath)) {
                    pluginPaths.add(betaPluginPath);
                }
            } else if (this.cliRoot.getBetaFeaturesEnabled() == Boolean.FALSE) {
                pluginPaths.removeIf(path -> path.getFileName().toString().equals("beta"));
            }
            for (Path plugin : pluginPaths) {
                if (Files.exists(plugin, new LinkOption[0])) {
                    this.pluginRepository.addPath(plugin.toFile());
                    continue;
                }
                throw new ExitException(1, "Plugin '%s' does not exist", new Object[]{plugin});
            }
            boolean skipCorePlugins = false;
            if (this.settings.containsKey("global.no-core-plugins")) {
                skipCorePlugins = Boolean.valueOf(this.settings.get("global.no-core-plugins").get(0));
            }
            if (!(skipCorePlugins |= this.cliRoot.isDisableLoadingCorePlugins())) {
                Path corePlugins = this.layout.getPluginsDir();
                if (Files.isDirectory(corePlugins, new LinkOption[0])) {
                    this.pluginRepository.scanDirectory(corePlugins);
                } else {
                    this.terminal.getErr().format("WARN: Application home '%s' does not include a plugins directory%n", this.getLayout().getRoot());
                }
            }
            this.startPlugins();
            this.pluginRepository.collectFeatures(this.extensionPoints);
        });
    }

    private Path toPluginPath(String plugin) {
        Path pluginPath = this.layout.getPluginsDir().resolve(plugin);
        Path resolved = Files.exists(pluginPath, new LinkOption[0]) ? pluginPath : (Files.exists(pluginPath = this.layout.getPluginsOptionalDir().resolve(plugin), new LinkOption[0]) ? pluginPath : this.getUserRiskScapeHome().resolve(plugin));
        return resolved.normalize();
    }

    void startPlugins() {
        log.info("Starting plugins ...");
        try {
            this.pluginRepository.activateAll(plugin -> {
                log.info("  {}...", (Object)plugin.getId());
                this.messages.addPluginResources(plugin);
                plugin.startUp(this.settings, (ProblemSink)this.terminal);
            });
        }
        catch (PluginRuntimeException e) {
            PluginDescriptor pd = e.getPlugin();
            if (pd == null) {
                throw new ExitException(1, (Throwable)e, "Plugins did not start correctly - %s - try disabling the failing plugin and start RiskScape again.", new Object[]{e.getMessage()});
            }
            throw new ExitException(1, (Throwable)e, "Plugin '%s' did not start - %s - try disabling the failing plugin and start RiskScape again.  ", new Object[]{e.getPlugin().getPluginId(), e.getMessage()});
        }
    }

    public void setRootOptions(CliRoot root) {
        this.changeState(State.ROOT_OPTIONS_SET, () -> {
            this.cliRoot = root;
            if (this.cliRoot.getRandomSeed() != null) {
                RandomSingleton.setSeed((long)this.cliRoot.getRandomSeed());
            }
            this.settings = this.collectSettings();
        });
    }

    Map<String, List<String>> collectSettings() {
        Ini ini;
        Path settingsFile = this.getUserRiskScapeHome().resolve("settings.ini");
        log.info("Looking for settings file - {}", (Object)settingsFile);
        if (!settingsFile.toFile().exists()) {
            File oldLocation = Paths.get(System.getProperty("user.home"), "riskscape", "settings.ini").toFile();
            if (oldLocation.exists() && !this.cliRoot.getHomeDir().isPresent()) {
                this.terminal.log(Problem.warning((String)"Engine settings loaded from default legacy location %s.  Move this file to %s to hide this warning", (Object[])new Object[]{oldLocation, this.getDefaultUserRiskScapeHome()}));
                settingsFile = oldLocation.toPath();
            } else {
                log.info("No settings file found");
                return Collections.emptyMap();
            }
        }
        try {
            ini = IniParser.parse((InputStream)new FileInputStream(settingsFile.toFile()));
        }
        catch (IOException e) {
            throw new ExitException((Problems)Problems.foundWith((Object)settingsFile, (Problems)Problems.caught((Throwable)e)), (Throwable)e);
        }
        HashMap rawSettings = Maps.newHashMap();
        for (String sectionName : ini.keySet()) {
            List sections = ini.getAll((Object)sectionName);
            for (Profile.Section section : sections) {
                for (String entryName : section.keySet()) {
                    List values = section.getAll((Object)entryName);
                    String combinedKey = sectionName + "." + entryName;
                    rawSettings.compute(combinedKey, (k, existing) -> {
                        if (existing == null) {
                            return values;
                        }
                        return Lists.newArrayList((Iterable)Iterables.concat((Iterable)existing, (Iterable)values));
                    });
                }
            }
        }
        return rawSettings;
    }

    public void setTerminal(Terminal term) {
        this.changeState(State.TERMINAL_SET, () -> {
            this.terminal = term;
            this.initializeI18n();
        });
    }

    public DefaultEngine buildEngine() {
        Map<String, List> engineSettings = this.settings.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("engine")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.engine = new DefaultEngine(BuildInfo.getBuildInfo(), this.pluginRepository.getActivated(), this.extensionPoints, engineSettings, this.getUserRiskScapeHome());
        this.engine.setMessages((Messages)this.getMessages());
        this.changeState(State.ENGINE_BUILT, () -> {
            for (EngineCollection feature : this.extensionPoints.getFeaturesOfType(EngineCollection.class)) {
                this.engine.registerCollection((IdentifiedCollection)feature.newInstance((Object)this.engine));
            }
            this.engine.setProblemSink((ProblemSink)this.terminal);
            EngineBootstrapper.bootstrap((ExtensionPoints)this.extensionPoints, (Engine.Writeable)this.engine);
            if (this.cliRoot.isExperimentalExecution()) {
                log.warn("Ignoring --experimental-execution - this option is now deprecated and will disappear in a future version");
            }
            if (this.cliRoot.getPipelineThreads() != null) {
                this.engine.getPipelineExecutor().setNumThreads(this.cliRoot.getPipelineThreads().intValue());
            }
            for (Plugin plugin : this.engine.getPlugins()) {
                try {
                    plugin.initializeEngine((Engine)this.engine, (ProblemSink)this.terminal);
                }
                catch (Throwable ex) {
                    this.terminal.getErr().format("There were problems during engine initialization:%n%n", new Object[0]);
                    this.terminal.getErr().format("Failed to initialize engine with plugin %s, Cause: %s%n", plugin.getDescriptor(), this.messages.renderProblem(ex));
                }
            }
        });
        return this.engine;
    }

    public Project buildProject() {
        this.changeState(State.PROJECT_BUILT, () -> {
            AtomicInteger errorCount = new AtomicInteger();
            HashSet seen = new HashSet();
            Consumer<Problem> problemConsumer = p -> {
                boolean notYetSeen = seen.add(p);
                if (!notYetSeen) {
                    return;
                }
                int count = errorCount.incrementAndGet();
                if (this.cliRoot.isShowProjectErrors()) {
                    if (count == 1) {
                        this.terminal.getErr().format("There were problems during engine initialization:%n", new Object[0]);
                    }
                    this.terminal.printProblems(new Problem[]{p});
                }
            };
            URI projectLocation = this.getProjectConfigLocation();
            ResultOrProblems built = this.engine.buildProject(projectLocation, problemConsumer);
            this.project = (Project)built.drainWarnings(problemConsumer).orElseThrow(ps -> new ExitException((Problems)Problems.foundWith((Object)"--project", (List)ps)));
            if (this.cliRoot.isShowProjectErrors()) {
                this.project.validate(problemConsumer);
            }
            if (errorCount.get() > 0) {
                if (!this.cliRoot.isShowProjectErrors()) {
                    this.terminal.getErr().format("There were problems during engine initialization, run riskscape with --show-project-errors for more details%n", errorCount.get());
                } else {
                    this.terminal.getErr().format("%n", new Object[0]);
                }
            }
        });
        return this.project;
    }

    URI getProjectConfigLocation() {
        String projectIni = this.cliRoot.getProjectIni().orElseGet(() -> {
            File pwdProjectIni = new File("project.ini");
            if (pwdProjectIni.exists()) {
                return pwdProjectIni.getAbsolutePath();
            }
            this.terminal.log(PROBLEMS.noProjectFile());
            return null;
        });
        if (projectIni == null) {
            return Engine.EMPTY_PROJECT_LOCATION;
        }
        return (URI)UriHelper.uriFromLocation((String)projectIni, (URI)Paths.get(".", new String[0]).toUri()).orElseThrow(ps -> new ExitException(1, (Problems)Problems.foundWith((Object)"--project", (List)ps)));
    }

    private void initializeI18n() {
        Path externalBundlePath = this.layout.getI18nDir();
        if (Files.isDirectory(externalBundlePath, new LinkOption[0])) {
            ResourceClassLoader forI18nDir;
            try {
                forI18nDir = new ResourceClassLoader("", new URL[]{externalBundlePath.toFile().toURI().toURL()});
            }
            catch (MalformedURLException e) {
                this.terminal.getErr().println("Could not open ");
                return;
            }
            this.messages.getClassLoader().append(Main.class, (ClassLoader)forI18nDir);
        } else {
            log.error("No core i18n resources found!");
        }
        this.addApiI18nToMessages();
    }

    public void addApiI18nToMessages() {
        ResourceClassLoader apiLoader;
        Path apiJar = this.layout.getLibDir().resolve("api.jar");
        try {
            if (!Files.isReadable(apiJar)) {
                this.terminal.getErr().println("Cannot find API i18n resources at " + String.valueOf(apiJar));
                return;
            }
            apiLoader = new ResourceClassLoader(new URL[]{apiJar.toUri().toURL()});
        }
        catch (MalformedURLException e) {
            this.terminal.getErr().println("Failed to open API i18n resources!");
            return;
        }
        this.messages.getClassLoader().append(Engine.class, (ClassLoader)apiLoader);
    }

    public void setLogLevel(String[] args) {
        CliBootstrap.parseLogLevelFromArgs(args, this.terminal).forEach(pair -> ((ch.qos.logback.classic.Logger)pair.getLeft()).setLevel((Level)pair.getRight()));
    }

    public static List<Pair<ch.qos.logback.classic.Logger, Level>> parseLogLevelFromArgs(String[] args, Terminal terminal) {
        String logLevel = null;
        int idx = 0;
        for (String arg : args) {
            if (arg.startsWith("--log-level")) {
                String[] parts = arg.split("=", 2);
                if (parts.length > 1) {
                    logLevel = parts[1];
                } else if (args.length > idx + 1) {
                    logLevel = args[idx + 1];
                }
            }
            ++idx;
        }
        if (logLevel != null) {
            String[] levels;
            LinkedList<Pair<ch.qos.logback.classic.Logger, Level>> parsed = new LinkedList<Pair<ch.qos.logback.classic.Logger, Level>>();
            for (String string : levels = logLevel.split(",")) {
                if (string.contains("=")) {
                    String[] nameAndLevel = string.split("=", 2);
                    Object name = nameAndLevel[0];
                    Level level = Level.toLevel((String)nameAndLevel[1]);
                    if (((String)name).startsWith(".")) {
                        name = "nz.org.riskscape" + (String)name;
                    }
                    try {
                        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)name);
                        parsed.add((Pair<ch.qos.logback.classic.Logger, Level>)Pair.of((Object)logger, (Object)level));
                        continue;
                    }
                    catch (ClassCastException ex) {
                        terminal.getErr().format("Logging configuration error, can not set log level", new Object[0]);
                        return Collections.emptyList();
                    }
                }
                try {
                    String[] loggers = new String[]{"ROOT", "nz.org.riskscape"};
                    for (int i = 0; i < loggers.length; ++i) {
                        String loggerName = loggers[i];
                        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)loggerName);
                        parsed.add((Pair<ch.qos.logback.classic.Logger, Level>)Pair.of((Object)logger, (Object)Level.toLevel((String)string)));
                    }
                }
                catch (ClassCastException ex) {
                    terminal.getErr().format("Logging configuration error, can not set log level", new Object[0]);
                    return Collections.emptyList();
                }
            }
            return parsed;
        }
        return Collections.emptyList();
    }

    @Generated
    public ProjectBuilder getBuilder() {
        return this.builder;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Generated
    public CliRoot getCliRoot() {
        return this.cliRoot;
    }

    @Generated
    public DefaultEngine getEngine() {
        return this.engine;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public Map<String, List<String>> getSettings() {
        return this.settings;
    }

    @Generated
    public PluginRepository getPluginRepository() {
        return this.pluginRepository;
    }

    @Generated
    public void setPluginRepository(PluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    @Generated
    public ExtensionPoints getExtensionPoints() {
        return this.extensionPoints;
    }

    @Generated
    public DefaultMessages getMessages() {
        return this.messages;
    }

    @Generated
    public AppLayout getLayout() {
        return this.layout;
    }

    static {
        PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    }

    public static enum State {
        NOTHING,
        APPLICATION_HOME_SET(NOTHING),
        TERMINAL_SET(APPLICATION_HOME_SET),
        ROOT_OPTIONS_SET(TERMINAL_SET),
        PLUGINS_ACTIVATED(ROOT_OPTIONS_SET),
        ENGINE_BUILT(PLUGINS_ACTIVATED),
        PROJECT_BUILT(ENGINE_BUILT);

        private final State[] allowedFrom;

        private State() {
            this.allowedFrom = new State[0];
        }

        private State(State ... rest) {
            this.allowedFrom = rest;
        }

        public boolean isAllowedFrom(State nextState) {
            for (int i = 0; i < this.allowedFrom.length; ++i) {
                if (this.allowedFrom[i] != nextState) continue;
                return true;
            }
            return false;
        }

        @Generated
        public State[] getAllowedFrom() {
            return this.allowedFrom;
        }
    }

    public static interface LocalProblems
    extends ProblemFactory {
        @SeverityLevel(value=Problem.Severity.WARNING)
        public Problem noProjectFile();
    }
}

