/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.Reference;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.cli.ApplicationCommand;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.cli.PipelineCommand;
import nz.org.riskscape.engine.cli.StubCommand;
import nz.org.riskscape.engine.cli.Table;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.ResolvedBookmark;
import nz.org.riskscape.engine.geo.GeometryRenderer;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.relation.InvalidTupleException;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

@CommandLine.Command(name="bookmark", subcommands={BookmarkListCommand.class, Info.class, Eval.class})
public class BookmarksCommand
extends StubCommand {

    @CommandLine.Command(name="eval", aliases={"evaluate"})
    public static class Eval
    extends ApplicationCommand {
        @CommandLine.Parameters(index="0")
        public String bookmarkId;
        @CommandLine.Option(names={"-f", "--format"})
        public String format;

        public Object doCommand(Project useProject) {
            BindingContext context = useProject.newBindingContext();
            ResolvedBookmark resolvedBookmark = (ResolvedBookmark)context.bind((Object)this.bookmarkId, ResolvedBookmark.class).orElseThrow(probs -> new ExitException((Problems)Problems.toSingleProblem((List)probs)));
            List bookmarkProblems = resolvedBookmark.validate();
            if (!bookmarkProblems.isEmpty()) {
                throw new ExitException((Problems)Problems.foundWith(Bookmark.class, (String)this.bookmarkId, (List)bookmarkProblems));
            }
            String saveFormat = "";
            if (this.format != null) {
                Format f = (Format)context.bind((Object)this.format, Format.class).orElseThrow(problems -> {
                    throw new ExitException((Problems)Problems.foundWith((Object)"--format", (List)problems));
                });
                saveFormat = String.format(", format: '%s'", f.getId());
            }
            String outputFilename = this.bookmarkId.replaceAll("\\.[^.]*$", "");
            String pipelineDsl = String.format("input('%s') -> save('%s'%s)", this.bookmarkId, outputFilename, saveFormat);
            PipelineCommand.Eval command = new PipelineCommand.Eval();
            command.setEngine(this.getEngine());
            command.setProject(useProject);
            command.setTerminal(this.getTerminal());
            command.setMessages(this.getMessages());
            command.pipelineFile = pipelineDsl;
            command.runnerOptions.replace = true;
            command.runnerOptions.output = Paths.get(useProject.getOutputBaseLocation().resolve("bookmark-eval")).toAbsolutePath().toString();
            return command.doCommand(useProject);
        }
    }

    @CommandLine.Command(name="info")
    public static class Info
    extends Base {
        @CommandLine.Parameters
        public String bookmarkId;

        public Object doCommand(Project project) {
            ResolvedBookmark resolvedBookmark = (ResolvedBookmark)project.newBindingContext().bind((Object)this.bookmarkId, ResolvedBookmark.class).orElseThrow(probs -> new ExitException((Problems)Problems.toSingleProblem((List)probs)));
            this.doDetailedDump(resolvedBookmark);
            return null;
        }
    }

    @CommandLine.Command(name="list")
    public static class BookmarkListCommand
    extends ApplicationCommand {
        public Object doCommand(Project project) {
            List bookmarks = project.getBookmarks().getReferences().stream().map(ref -> (Bookmark)ref.getResult().orElse((Object)Bookmark.builder().id(ref.getId()).description(this.formatFailedObjectErrorsForTable((Reference)ref)).build())).collect(Collectors.toList());
            return Table.fromList(bookmarks, Bookmark.class, (MessageSource)this.getMessages().getLabels(), Arrays.asList(Table.Property.of((String)"id", Bookmark::getId), Table.Property.of((String)"description", Bookmark::getDescription), Table.Property.of((String)"location", b -> b.getLocation() == null ? "" : b.getLocation().toString())));
        }
    }

    public static abstract class Base
    extends ApplicationCommand {
        @CommandLine.Option(names={"--brief"})
        public boolean brief;

        protected void doDetailedDump(ResolvedBookmark bookmark) {
            try {
                this.doDetailedDumpUncaught(bookmark);
            }
            catch (InvalidTupleException ex) {
                throw new ExitException((Problems)Problem.error((String)"Measuring failed because of invalid data in the bookmark", (Object[])new Object[0]).withChildren(new Problems[]{Problems.caught((Throwable)ex)}), (Throwable)ex);
            }
            catch (RuntimeException ex) {
                throw new ExitException(1, (Throwable)ex, "Inspecting the bookmark failed because of an unexpected error - %s", new Object[]{this.getMessages().renderProblem((Throwable)ex)});
            }
        }

        protected void doDetailedDumpUncaught(ResolvedBookmark resolved) {
            Bookmark bookmark = resolved.getBookmark();
            if (bookmark.isFromURI()) {
                this.print("%nLocation : %s", new Object[]{bookmark.getLocation()});
            } else {
                this.print("%n\"%s\"", new Object[]{bookmark.getId()});
                this.print("  Description : %s", new Object[]{bookmark.getDescription()});
                this.print("  Location    : %s", new Object[]{bookmark.getLocation()});
            }
            this.printProblems(resolved.validate());
            if (resolved.hasValidationErrors()) {
                return;
            }
            ResultOrProblems dataOr = resolved.getData(Object.class);
            this.printProblems(dataOr.getProblems());
            if (dataOr.hasErrors()) {
                return;
            }
            Object data = dataOr.getWithProblemsIgnored();
            CoordinateReferenceSystem displayCrs = this.getEngine().getDiagnostics().getDisplayCrs();
            if (data instanceof TypedCoverage) {
                TypedCoverage coverage = (TypedCoverage)data;
                if (coverage == null) {
                    return;
                }
                CoordinateReferenceSystem crs = coverage.getCoordinateReferenceSystem();
                this.print("  Axis-order  : %s", new Object[]{GeometryRenderer.getAxisOrder((CoordinateReferenceSystem)crs)});
                this.print("  Coverage    : %s", new Object[]{coverage.toString()});
                this.print("  CRS code    : %s", new Object[]{GeometryRenderer.getCode((CoordinateReferenceSystem)crs)});
                this.print("  CRS (full)  : %s", new Object[]{crs});
                if (coverage.getEnvelope().isPresent()) {
                    ReferencedEnvelope bounds = (ReferencedEnvelope)coverage.getEnvelope().get();
                    this.print("  Bounds      : %s (original)", new Object[]{GeometryRenderer.getBounds((ReferencedEnvelope)bounds)});
                    if (!GeometryRenderer.isCrsEquivalent((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)displayCrs)) {
                        this.print("  Bounds      : %s", new Object[]{GeometryRenderer.getBoundsInCrs((ReferencedEnvelope)bounds, (CoordinateReferenceSystem)displayCrs)});
                    }
                }
            }
            if (data instanceof Relation) {
                Relation relation = (Relation)data;
                if (relation == null) {
                    return;
                }
                this.print("  Attributes  :", new Object[0]);
                List members = relation.getType().getMembers();
                for (Struct.StructMember member : members) {
                    this.print("    %s[%s]", new Object[]{member.getKey(), member.getType()});
                }
                Struct.StructMember sm = relation.getSpatialMetadata().map(SpatialMetadata::getGeometryStructMember).orElse(null);
                CoordinateReferenceSystem crs = relation.getSpatialMetadata().map(SpatialMetadata::getCrs).orElse(null);
                if (crs != null) {
                    this.print("  Axis-order  : %s", new Object[]{GeometryRenderer.getAxisOrder((CoordinateReferenceSystem)crs)});
                    this.print("  CRS code    : %s", new Object[]{GeometryRenderer.getCode((CoordinateReferenceSystem)crs)});
                    this.print("  CRS (full)  : %s", new Object[]{crs});
                }
                if (!this.brief) {
                    this.print("  Summarizing...", new Object[]{relation.toString()});
                    Envelope env = null;
                    try (TupleIterator iterator = relation.iterator();){
                        long count = 0L;
                        while (iterator.hasNext()) {
                            Envelope specific;
                            Geometry gm;
                            Tuple tuple = (Tuple)iterator.next();
                            ++count;
                            if (sm == null || (gm = (Geometry)tuple.fetch(sm)) == null || (specific = gm.getEnvelopeInternal()) == null) continue;
                            if (env == null) {
                                env = specific;
                            }
                            env.expandToInclude(specific);
                        }
                        this.print("  Row count   : %d", new Object[]{count});
                        if (env != null) {
                            ReferencedEnvelope bounds = new ReferencedEnvelope(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), crs);
                            this.print("  Bounds      : %s (original)", new Object[]{GeometryRenderer.getBounds((ReferencedEnvelope)bounds)});
                            if (!GeometryRenderer.isCrsEquivalent((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)displayCrs)) {
                                this.print("  Bounds      : %s", new Object[]{GeometryRenderer.getBoundsInCrs((ReferencedEnvelope)bounds, (CoordinateReferenceSystem)displayCrs)});
                            }
                        }
                    }
                }
            }
        }

        private void printProblems(List<Problem> problems) {
            if (!problems.isEmpty()) {
                this.print("  Problems:", new Object[0]);
                for (Problem problem : problems) {
                    this.stdout().println(this.getMessages().renderProblem(problem).toString(options -> {
                        options.prefixAll = "    ";
                    }));
                    this.stdout().println();
                }
            }
        }
    }
}

