/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Locale;
import lombok.Generated;
import nz.org.riskscape.cli.InterruptHandler;
import nz.org.riskscape.cli.Terminal;
import nz.org.riskscape.engine.i18n.Messages;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;

public abstract class BaseTerminal
implements ProblemSink,
Terminal {
    public static final int DEFAULT_TTY_WIDTH = 80;
    public static final int TERMINAL_HEIGHT_UNLIMITED = Integer.MAX_VALUE;
    public static CommandLine.Help.Ansi defaultAnsi = CommandLine.Help.Ansi.AUTO;
    private final Messages messages;
    private final Locale locale;
    private InterruptHandler fallbackHandler = () -> this.doExit();
    public boolean showStackTrace = true;

    public static PrintStream wrapAsUncloseable(PrintStream toWrap) {
        return new PrintStream(toWrap){

            @Override
            public void close() {
                this.flush();
            }
        };
    }

    public BaseTerminal(Messages messages) {
        this(messages, messages.getDefaultLocale());
    }

    public void log(Problem problem) {
        this.formatToErrorStream("[%s] %s%n", this.formatLevel(problem), this.messages.renderProblem(problem, this.getLocale()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatToErrorStream(String format, Object ... args) {
        BaseTerminal baseTerminal = this;
        synchronized (baseTerminal) {
            this.getErr().format(format, args);
        }
    }

    public InterruptHandler setFallbackHandler(InterruptHandler newFallbackHandler) {
        InterruptHandler prev = this.fallbackHandler;
        this.fallbackHandler = newFallbackHandler;
        return prev;
    }

    void doExit() {
        System.exit(1);
    }

    public boolean isTTY() {
        return false;
    }

    private String formatLevel(Problem p) {
        CommandLine.Help.Ansi.Style problemStyle = p.getSeverity() == Problem.Severity.INFO ? CommandLine.Help.Ansi.Style.fg_green : (p.getSeverity() == Problem.Severity.ERROR ? CommandLine.Help.Ansi.Style.fg_red : (p.getSeverity() == Problem.Severity.WARNING ? CommandLine.Help.Ansi.Style.fg_yellow : CommandLine.Help.Ansi.Style.fg_blue));
        return this.getAnsi().apply(p.getSeverity().name(), Collections.singletonList(problemStyle)).toString();
    }

    public CommandLine.Help.Ansi getAnsi() {
        return defaultAnsi;
    }

    @Generated
    public BaseTerminal(Messages messages, Locale locale) {
        this.messages = messages;
        this.locale = locale;
    }

    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    @Generated
    public InterruptHandler getFallbackHandler() {
        return this.fallbackHandler;
    }
}

