/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.survey2;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;

public class QuestionTree {
    private final Node root;

    public static QuestionTree singleton(Question question) {
        return QuestionTree.fromList(Collections.singletonList(question));
    }

    public static QuestionTree empty() {
        return QuestionTree.fromList(Collections.emptyList());
    }

    public static QuestionTree fromList(List<Question> questions) {
        QuestionTree tree = new QuestionTree(new Node(IncrementalBuildState.EMPTY_QUESTION));
        LinkedList<Question> visitList = new LinkedList<Question>(questions);
        int skips = 0;
        while (!visitList.isEmpty()) {
            Node attachTo;
            Question q = visitList.removeFirst();
            if (q.getDependsOn().isPresent()) {
                attachTo = tree.findOne(n -> n.question.equals(q.getDependsOn().get())).orElse(null);
                if (attachTo == null) {
                    visitList.addLast(q);
                    if (++skips != visitList.size()) continue;
                    throw new IllegalStateException("Can not resolve dependencies within " + String.valueOf(visitList));
                }
                skips = 0;
            } else {
                attachTo = tree.root;
            }
            attachTo.nodes.add(new Node(q));
        }
        tree.link();
        return tree;
    }

    void link() {
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(this.root);
        while (!queue.isEmpty()) {
            Node next = (Node)queue.removeFirst();
            next.nodes.forEach(child -> {
                child.parent = next;
                queue.add((Node)child);
            });
        }
    }

    public <T> T visitBfs(BiFunction<Node, T, T> consumer, T data) {
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(this.root);
        while (!queue.isEmpty()) {
            Node next = (Node)queue.removeFirst();
            data = consumer.apply(next, (Node)data);
            next.nodes.forEach(child -> queue.add((Node)child));
        }
        return data;
    }

    public <T> T visitBfs(BiConsumer<Node, T> consumer, T data) {
        return (T)this.visitBfs((Node node, T d) -> {
            consumer.accept((Node)node, (Object)d);
            return d;
        }, data);
    }

    public List<Node> find(Predicate<Node> predicate) {
        return this.visitBfs((Node node, T list) -> {
            if (predicate.test((Node)node)) {
                list.add(node);
            }
        }, new LinkedList());
    }

    public Optional<Node> findOne(Predicate<Node> predicate) {
        List<Node> all = this.find(predicate);
        if (all.size() == 0) {
            return Optional.empty();
        }
        if (all.size() == 1) {
            return Optional.of(all.get(0));
        }
        throw new IllegalStateException("found many - " + String.valueOf(all));
    }

    public Optional<Node> findQuestion(Question question) {
        List found = this.visitBfs((Node node, T list) -> {
            if (node.question.equals(question)) {
                list.add(node);
            }
        }, new LinkedList());
        return found.isEmpty() ? Optional.empty() : Optional.of((Node)found.get(0));
    }

    public boolean isEmpty() {
        return this.root.nodes.isEmpty();
    }

    List<Question> filterReady(Stream<Question> questions, IncrementalBuildState buildState) {
        return questions.filter(q -> !buildState.getAnswer((Question)q).isPresent() && q.readyToBeAsked(buildState)).collect(Collectors.toList());
    }

    public List<Question> getNextQuestions(IncrementalBuildState buildState) {
        Node answeredNode;
        Node visitPtr = answeredNode = this.findQuestion(buildState.getQuestion()).orElse(this.root);
        List<Question> children;
        while ((children = this.filterReady(visitPtr.nodes.stream().map(n -> n.question), buildState)).isEmpty()) {
            if (visitPtr.isTopLevel()) {
                return Collections.emptyList();
            }
            visitPtr = visitPtr.getParent();
        }
        return children;
    }

    public boolean isComplete(IncrementalBuildState buildState) {
        return this.getNextQuestions(buildState).isEmpty();
    }

    public List<Question> getSkipped(IncrementalBuildState buildState, Question chosen) {
        List<Question> next = this.getNextQuestions(buildState);
        int index = next.indexOf(chosen);
        if (index == -1) {
            throw new IllegalArgumentException("question " + String.valueOf(chosen) + " is not one of the next questions: " + String.valueOf(next));
        }
        return next.subList(0, index);
    }

    @Generated
    private QuestionTree(Node root) {
        this.root = root;
    }

    @Generated
    public Node getRoot() {
        return this.root;
    }

    public static class Node {
        private final Question question;
        private final List<Node> nodes = new LinkedList<Node>();
        private Node parent;

        public boolean isTopLevel() {
            return this.parent == null;
        }

        public Node getParent() {
            return this.parent == null ? this : this.parent;
        }

        @Generated
        public Node(Question question) {
            this.question = question;
        }

        @Generated
        public Question getQuestion() {
            return this.question;
        }
    }
}

