/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.survey2;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.BaseQuestionSet;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.bld.PipelineChange;
import nz.org.riskscape.wizard.bld.change.NoChange;
import nz.org.riskscape.wizard.bld.dsl.BuildPoint;
import nz.org.riskscape.wizard.bld.loc.ChangeLocation;
import nz.org.riskscape.wizard.survey2.AddQuestion;
import nz.org.riskscape.wizard.survey2.Phase;

public class DefaultQuestionSet2
extends BaseQuestionSet {
    private final Phase phase;
    private final List<Question> list = new ArrayList<Question>();
    private final List<BuildPoint> buildPoints = new ArrayList<BuildPoint>();
    private ChangeLocation defaultLocation = new Question("", Void.class).getChangeLocation();

    public DefaultQuestionSet2(String id, Phase phase) {
        super(id, phase.getSurvey());
        this.phase = phase;
    }

    public DefaultQuestionSet2(String name, String discriminator, Phase phase) {
        super(name, discriminator, phase.getSurvey());
        this.phase = phase;
    }

    public void addBuildPoint(BuildPoint point) {
        this.buildPoints.add(point);
    }

    public <T> AddQuestion<T> addQuestion(String name, Class<T> parameterType) {
        return new AddQuestion<T>(this, name, parameterType);
    }

    public AddQuestion<Question.Hidden> addHiddenQuestion(String name) {
        return new AddQuestion<Question.Hidden>(this, new Question(name, Question.Hidden.class).hidden(), Question.Hidden.class);
    }

    Question add(Question question) {
        question = question.inSet(this);
        this.list.add(question);
        return question;
    }

    public Question get(String questionName) {
        for (Question question : this.list) {
            if (!question.getName().equals(questionName)) continue;
            return question;
        }
        throw new IllegalArgumentException("no such question: " + questionName);
    }

    public boolean remove(Question question) {
        return this.list.remove(question);
    }

    public boolean contains(Question question) {
        return this.list.contains(question);
    }

    public List<Parameter> getParameters() {
        return this.list.stream().map(question -> question.toParameter()).collect(Collectors.toList());
    }

    @Override
    public List<Question> getQuestions() {
        return ImmutableList.copyOf(this.list);
    }

    @Override
    public PipelineChange getPipelineChange(IncrementalBuildState buildState, Answer answer) {
        for (BuildPoint buildPoint : this.buildPoints) {
            Optional<PipelineChange> change = buildPoint.getChange(buildState, answer);
            if (!change.isPresent()) continue;
            return change.get();
        }
        return new NoChange(answer);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("QuestionSet[");
        builder.append("id=").append(this.id);
        builder.append(" questions=");
        boolean first = true;
        for (Question question : this.list) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(question.getName());
            first = false;
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    @Generated
    public Phase getPhase() {
        return this.phase;
    }

    @Generated
    public List<BuildPoint> getBuildPoints() {
        return this.buildPoints;
    }

    @Generated
    public ChangeLocation getDefaultLocation() {
        return this.defaultLocation;
    }

    @Generated
    public void setDefaultLocation(ChangeLocation defaultLocation) {
        this.defaultLocation = defaultLocation;
    }
}

