/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.survey2;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.data.ResolvedBookmark;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.i18n.DefaultMessages;
import nz.org.riskscape.engine.i18n.EnumTranslator;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.i18n.TranslationContext;
import nz.org.riskscape.engine.rl.FunctionCallPrototype;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.rl.ast.PropertyAccess;
import nz.org.riskscape.rl.ast.StructDeclaration;
import nz.org.riskscape.wizard.Choice;
import nz.org.riskscape.wizard.ExpressionHelper;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.QuestionSet;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.survey2.PickQuestionSet;

public class Choices {
    private static Choice toChoice(final Enum<?> enumVal) {
        return new Choice(enumVal.name(), enumVal.name(), Optional.empty(), enumVal){

            @Override
            public String getDescription(TranslationContext context) {
                EnumTranslator enumTranslator = new EnumTranslator(context);
                return enumTranslator.getEntry(enumVal).getDescription(new Object[0]);
            }

            @Override
            public String getLabel(TranslationContext context) {
                EnumTranslator enumTranslator = new EnumTranslator(context);
                return enumTranslator.getEntry(enumVal).getLabel(new Object[0]);
            }
        };
    }

    public static List<Choice> forEnums(List<? extends Enum<?>> enums) {
        return enums.stream().map(e -> Choices.toChoice(e)).collect(Collectors.toList());
    }

    public static List<Choice> forEnum(Class<? extends Enum<?>> enumClass) {
        return Choices.forEnums(Arrays.asList(enumClass.getEnumConstants()));
    }

    public static List<Choice> from(Question question, IncrementalBuildState buildState) {
        Class<?> parameterType = question.getParameterType();
        if (parameterType.isEnum()) {
            return Choices.forEnum(parameterType);
        }
        if (parameterType.equals(ResolvedBookmark.class)) {
            return Choices.forBookmarks(buildState);
        }
        if (StructDeclaration.class.isAssignableFrom(parameterType) || PropertyAccess.class.isAssignableFrom(parameterType)) {
            return Choices.forScope(buildState, question);
        }
        if (parameterType.equals(PickQuestionSet.class)) {
            return Lists.transform(buildState.getSurvey().getApplicableQuestionSets(buildState), qs -> new PickQuestionSet((QuestionSet)qs).asChoice());
        }
        if (question.getParameterType().equals(FunctionCallPrototype.class) && question.hasAnnotation("aggregation")) {
            return Choices.forAggregationNonInteractive(buildState);
        }
        if (Identified.class.isAssignableFrom(parameterType)) {
            return Choices.forIdentified(question, buildState);
        }
        return Collections.emptyList();
    }

    public static List<Choice> forBookmarks(IncrementalBuildState buildState) {
        return buildState.getProject().getBookmarks().getAll().stream().sorted((b1, b2) -> b1.getId().compareTo(b2.getId())).map(bm -> new Choice(bm.getId(), bm.getId(), Optional.of(bm.getDescription()), bm)).collect(Collectors.toList());
    }

    private static Choice toChoice(final IdentifiedFunction function, final MessageSource helpMessages) {
        Optional<String> description = Optional.of(function.getDescription()).filter(d -> !d.equals(""));
        return new Choice(function.getId(), function.getId(), description, function){

            @Override
            public String getDescription(TranslationContext context) {
                if (this.description.isPresent()) {
                    return (String)this.description.get();
                }
                String code = DefaultMessages.getShortCode((Identified)function, (String[])new String[]{"description"});
                return helpMessages.getMessage(code, new Object[0]);
            }
        };
    }

    public static List<Choice> forFunctions(IncrementalBuildState buildState, Collection<IdentifiedFunction.Category> matchCategories) {
        MessageSource helpMessages = buildState.getProject().getEngine().getMessages().getHelp();
        return buildState.getProject().getFunctionSet().getAll().stream().filter(f -> matchCategories.contains(f.getCategory())).sorted((f1, f2) -> f1.getId().compareTo(f2.getId())).map(f -> Choices.toChoice(f, helpMessages)).collect(Collectors.toList());
    }

    public static List<Choice> forScope(IncrementalBuildState buildState, Question q) {
        return ExpressionHelper.create(buildState, q).get().getAttributeChoices();
    }

    public static List<Choice> forScope(Struct input, Question q) {
        return new ExpressionHelper(q, input).getAttributeChoices();
    }

    public static List<Choice> percentiles(Project project) {
        IdentifiedFunction percentile = (IdentifiedFunction)project.getFunctionSet().get("percentile", project.getProblemSink());
        return Stream.of(75L, 90L, 95L, 99L).map(p -> new Choice(String.format("percentile(x, %d)", p), String.format("%dth percentile", p), Optional.empty(), percentile)).toList();
    }

    public static List<Choice> forAggregation(IncrementalBuildState buildState) {
        List<String> excludeFunctions = List.of("fit_curve", "stack_continuous", "aal_trapz");
        Predicate<IdentifiedFunction> predicate = function -> function.getCategory() == IdentifiedFunction.Category.MATHS && function.getAggregationFunction().isPresent() && !excludeFunctions.contains(function.getId());
        List<Choice> choices = buildState.getProject().getFunctionSet().getAll().stream().filter(predicate).sorted((f1, f2) -> f1.getId().compareTo(f2.getId())).map(f -> new Choice(f.getId(), f.getId(), Optional.of(f.getDescription()), f)).toList();
        return choices;
    }

    public static List<Choice> forAggregationNonInteractive(IncrementalBuildState buildState) {
        return Stream.concat(Choices.forAggregation(buildState).stream().filter(choice -> {
            IdentifiedFunction function = choice.getDerivedFrom(IdentifiedFunction.class);
            Optional aggregationFunction = function.getAggregationFunction();
            return aggregationFunction.filter(value -> value.getArguments().size() <= 1).isPresent();
        }), Choices.percentiles(buildState.getProject()).stream()).toList();
    }

    public static List<Choice> forIdentified(Question question, IncrementalBuildState buildState) {
        Class<Identified> parameterType = question.getParameterType().asSubclass(Identified.class);
        IdentifiedCollection collection = buildState.getProject().getCollectionByClass(parameterType);
        return collection.getReferences().stream().map(identified -> new Choice(identified.getId(), identified.getId(), Optional.empty(), identified.get())).toList();
    }
}

