/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.survey2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.EmptyQuestionSet;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.QuestionSet;
import nz.org.riskscape.wizard.Survey;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.bld.PipelineChange;
import nz.org.riskscape.wizard.survey2.BasePhase;
import nz.org.riskscape.wizard.survey2.DefaultQuestionSet2;
import nz.org.riskscape.wizard.survey2.Phase;
import nz.org.riskscape.wizard.survey2.PickQuestionSet;
import nz.org.riskscape.wizard.survey2.QuestionTree;

public class BaseSurvey
implements Survey {
    protected final String id;
    protected final MessageSource messageSource;
    protected final List<BasePhase> phases;
    private Pair<IncrementalBuildState, List<QuestionSet>> lastQueriedApplicable;
    private final QuestionSet surveyQuestions = new EmptyQuestionSet("wizard", (Survey)this){

        @Override
        public PipelineChange getPipelineChange(IncrementalBuildState buildState, Answer answer) {
            ResultOrProblems<QuestionSet> chosenOr = BaseSurvey.this.getQuestionSetChoice(buildState, answer);
            if (chosenOr.hasErrors()) {
                return (PipelineChange)PipelineChange.failed(chosenOr.getProblems()).apply(answer);
            }
            QuestionSet chosen = (QuestionSet)chosenOr.get();
            if (chosen instanceof DefaultQuestionSet2) {
                DefaultQuestionSet2 qs2 = (DefaultQuestionSet2)chosen;
                return qs2.getPipelineChange(buildState, answer);
            }
            return super.getPipelineChange(buildState, answer);
        }
    };

    public BaseSurvey(String id, MessageSource messageSource, Function<Survey, List<BasePhase>> phasesConstructor) {
        this.id = id;
        this.messageSource = messageSource;
        this.phases = phasesConstructor.apply(this);
    }

    private BasePhase getCurrentPhase(IncrementalBuildState buildState) {
        while (buildState.getQuestionSet().equals(this.surveyQuestions)) {
            buildState = buildState.getLast();
        }
        if (buildState.isEmpty()) {
            return this.phases.get(0);
        }
        for (BasePhase phase : this.phases) {
            if (!phase.contains(buildState.getQuestionSet())) continue;
            return phase;
        }
        return null;
    }

    @Override
    public List<QuestionSet> getApplicableQuestionSets(IncrementalBuildState buildState) {
        if (this.lastQueriedApplicable != null && ((IncrementalBuildState)this.lastQueriedApplicable.getLeft()).equals(buildState)) {
            return (List)this.lastQueriedApplicable.getRight();
        }
        int numPhaseSkips = this.countPhaseSkipsInARow(buildState);
        BasePhase phase = this.getCurrentPhase(buildState);
        if (phase == null) {
            throw new RuntimeException("unowned phase after " + String.valueOf(buildState.getQuestion()));
        }
        if (phase.isComplete(buildState)) {
            phase = this.getNextPhase(phase);
        }
        for (int i = 0; i < numPhaseSkips; ++i) {
            phase = this.getNextPhase(phase);
        }
        if (phase == null) {
            return Collections.emptyList();
        }
        ArrayList<QuestionSet> all = new ArrayList<QuestionSet>();
        all.addAll(phase.getAvailableQuestionSets(buildState));
        if (phase.canSkip(buildState)) {
            all.add(QuestionSet.SKIP);
        }
        this.lastQueriedApplicable = Pair.of((Object)buildState, all);
        return all;
    }

    private boolean isQuestionSetSkip(Answer answer) {
        return answer.getQuestion().getParameterType().equals(PickQuestionSet.class) && answer.getValueAs(PickQuestionSet.class).isSkip();
    }

    private int countPhaseSkipsInARow(IncrementalBuildState buildState) {
        int counted = 0;
        while (this.isQuestionSetSkip(buildState.getAnswer())) {
            buildState = buildState.getLast();
            ++counted;
        }
        return counted;
    }

    private BasePhase getNextPhase(Phase after) {
        Iterator<BasePhase> phasesIter = this.phases.iterator();
        while (phasesIter.hasNext()) {
            Phase phase = phasesIter.next();
            if (!phase.equals(after)) continue;
            return phasesIter.hasNext() ? phasesIter.next() : null;
        }
        return null;
    }

    @Override
    public PipelineChange getPipelineChange(IncrementalBuildState buildState, Answer answer) {
        QuestionSet questionSet = answer.getQuestionSet();
        return questionSet.getPipelineChange(buildState, answer);
    }

    private QuestionTree getCurrentQuestionTree(IncrementalBuildState buildState) {
        QuestionSet lastQuestionSet = buildState.getQuestionSet();
        if (lastQuestionSet.equals(this.surveyQuestions)) {
            lastQuestionSet = buildState.getAnswer().getValueAs(PickQuestionSet.class).questionSet;
        }
        return QuestionTree.fromList(lastQuestionSet.getQuestions());
    }

    @Override
    public QuestionTree getQuestionTree(IncrementalBuildState buildState) {
        QuestionTree tree = this.getCurrentQuestionTree(buildState);
        List<Question> nextQuestions = tree.getNextQuestions(buildState);
        if (!nextQuestions.isEmpty()) {
            return tree;
        }
        if (this.getApplicableQuestionSets(buildState).isEmpty()) {
            return QuestionTree.empty();
        }
        return this.nextQuestionSetChoice(buildState);
    }

    private ResultOrProblems<QuestionSet> getQuestionSetChoice(IncrementalBuildState buildState, Answer answer) {
        PickQuestionSet pickQuestionSet = answer.getValueAs(PickQuestionSet.class);
        if (pickQuestionSet.questionSet != null) {
            return ResultOrProblems.of((Object)pickQuestionSet.questionSet);
        }
        List<QuestionSet> list = this.getApplicableQuestionSets(buildState);
        return list.stream().filter(qs -> qs.getId().equals(pickQuestionSet.questionSetId)).findFirst().map(qs -> {
            pickQuestionSet.questionSet = qs;
            return pickQuestionSet.questionSet;
        }).map(qs -> ResultOrProblems.of((Object)qs)).orElse(ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.get().notAnOption(pickQuestionSet.questionSetId, (Object)answer.getQuestion().toParameter(), list.stream().map(QuestionSet::getId).collect(Collectors.toList()))}));
    }

    public <T extends Phase> Optional<T> getPhaseOfType(Class<T> clazz) {
        for (Phase phase : this.phases) {
            if (!phase.getClass().equals(clazz)) continue;
            return Optional.of((Phase)clazz.cast(phase));
        }
        return Optional.empty();
    }

    private QuestionTree nextQuestionSetChoice(IncrementalBuildState buildState) {
        long nextCounter = buildState.buildStateStream().filter(p -> p.getQuestion().getParameterType().equals(PickQuestionSet.class)).count() + 1L;
        Question pick = new Question("question-choice-" + nextCounter, PickQuestionSet.class).withI18nLookup((question, suffix, locale) -> Question.DEFAULT_I18N_LOOKUP.apply(question.withName("question-choice"), suffix, locale));
        return QuestionTree.singleton(pick.inSet(this.surveyQuestions));
    }

    private boolean wasPhaseAnswered(IncrementalBuildState buildState, BasePhase phase) {
        return buildState.buildStateStream().anyMatch(bs -> phase.contains(bs.getQuestionSet()));
    }

    private List<BasePhase> getUnansweredPhases(IncrementalBuildState buildState) {
        ArrayList<BasePhase> unanswered = new ArrayList<BasePhase>();
        for (BasePhase phase : this.phases) {
            if (this.wasPhaseAnswered(buildState, phase)) continue;
            unanswered.add(phase);
        }
        return unanswered;
    }

    @Override
    public boolean isFinished(IncrementalBuildState buildState) {
        if (buildState.isEmpty()) {
            return false;
        }
        boolean phaseNeedsAnswering = this.getUnansweredPhases(buildState).stream().anyMatch(phase -> !phase.canSkip(buildState));
        if (phaseNeedsAnswering) {
            return false;
        }
        boolean questionNeedsAnswering = this.getCurrentQuestionTree(buildState).getNextQuestions(buildState).stream().anyMatch(q -> q.isRequired());
        return !questionNeedsAnswering;
    }

    @Override
    public List<Phase> getDefinedPhases() {
        return new ArrayList<Phase>(this.phases);
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @Generated
    public List<BasePhase> getPhases() {
        return this.phases;
    }
}

