/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.survey2;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.wizard.QuestionSet;
import nz.org.riskscape.wizard.Survey;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.survey2.DefaultQuestionSet2;
import nz.org.riskscape.wizard.survey2.Phase;

public class BasePhase
implements Phase {
    protected final Survey survey;
    protected final Set<String> skippableQuestionSets = new HashSet<String>();
    protected List<? extends QuestionSet> builtQuestionSets;
    private Object questionSetsBuiltWith;

    public static BasePhase simple(Survey survey, String qsId, boolean skippable, Consumer<DefaultQuestionSet2> consumer) {
        return new BasePhase(survey, phase -> {
            DefaultQuestionSet2 qs = new DefaultQuestionSet2(qsId, (Phase)phase);
            consumer.accept(qs);
            if (skippable) {
                phase.skippableQuestionSets.add(qsId);
            }
            return Arrays.asList(qs);
        });
    }

    public BasePhase(Survey survey) {
        this(survey, null);
    }

    public BasePhase(Survey survey2, Function<BasePhase, List<DefaultQuestionSet2>> constructor) {
        this.survey = survey2;
        if (constructor != null) {
            this.questionSetsBuiltWith = Boolean.FALSE;
            this.builtQuestionSets = constructor.apply(this);
        }
    }

    public boolean isComplete(IncrementalBuildState buildState) {
        return this.getAvailableQuestionSets(buildState).isEmpty();
    }

    public List<QuestionSet> getAvailableQuestionSets(IncrementalBuildState buildState) {
        if (this.builtQuestionSets == null || this.builtQuestionsInvalid(buildState)) {
            this.builtQuestionSets = this.buildQuestionSets(buildState);
            this.questionSetsBuiltWith = buildState;
        }
        return this.builtQuestionSets.stream().filter(qs -> !buildState.isQuestionSetAnswered(qs.getId())).collect(Collectors.toList());
    }

    protected boolean builtQuestionsInvalid(IncrementalBuildState buildState) {
        return this.questionSetsBuiltWith != Boolean.FALSE && !buildState.buildStateStream().anyMatch(bs -> bs == this.questionSetsBuiltWith);
    }

    protected List<QuestionSet> buildQuestionSets(IncrementalBuildState buildState) {
        return Collections.singletonList(this.buildQuestionSet(buildState));
    }

    protected QuestionSet buildQuestionSet(IncrementalBuildState buildState) {
        throw new RuntimeException("buildQuestionSets not overridden and no static constructor was supplied");
    }

    public boolean canSkip(IncrementalBuildState buildState) {
        return this.getAvailableQuestionSets(buildState).stream().allMatch(qs -> this.skippableQuestionSets.contains(qs.getId()));
    }

    public boolean contains(QuestionSet questionSet) {
        return Objects.equals(questionSet.getPhase(), this);
    }

    @Override
    public Optional<String> getName(Locale locale) {
        String key = this.getClass().getSimpleName().replace("Phase", "");
        return Optional.ofNullable(this.getSurvey().getMessageSource().getMessage(String.format("phase.%s.name", key), new Object[0], key, locale));
    }

    @Override
    @Generated
    public Survey getSurvey() {
        return this.survey;
    }
}

