/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.survey2;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.bld.PipelineChange;
import nz.org.riskscape.wizard.bld.dsl.BasicBuildPoint;
import nz.org.riskscape.wizard.bld.dsl.IncompletePipelineChange;
import nz.org.riskscape.wizard.bld.dsl.PipelineChangeInput;
import nz.org.riskscape.wizard.bld.dsl.PipelineChanger;
import nz.org.riskscape.wizard.bld.dsl.TypedPipelineChanger;
import nz.org.riskscape.wizard.survey2.DefaultQuestionSet2;

public class AddQuestion<T> {
    private final DefaultQuestionSet2 questionSet;
    private final Class<T> parameterType;
    private Question building;

    public AddQuestion(DefaultQuestionSet2 questionSet, String name, Class<T> parameterType) {
        this.questionSet = questionSet;
        this.building = new Question(name, parameterType).atLocation(questionSet.getDefaultLocation());
        this.parameterType = parameterType;
    }

    public AddQuestion(DefaultQuestionSet2 questionSet, Question q, Class<T> parameterType) {
        this.questionSet = questionSet;
        this.building = q.withType(parameterType).atLocation(questionSet.getDefaultLocation());
        this.parameterType = parameterType;
    }

    public DefaultQuestionSet2 then(TypedPipelineChanger<T> changer) {
        this.questionSet.add(this.building);
        this.questionSet.addBuildPoint(new BasicBuildPoint(this.building.getName(), input -> changer.apply(new PipelineChangeInput(input.getBuildPoint(), input.getAnswer(), input.getBuildState()), input.getResponse(this.parameterType))));
        return this.questionSet;
    }

    public DefaultQuestionSet2 then(PipelineChanger changer) {
        this.questionSet.add(this.building);
        this.questionSet.addBuildPoint(new BasicBuildPoint(this.building.getName(), input -> changer.apply(new PipelineChangeInput(input.getBuildPoint(), input.getAnswer(), input.getBuildState()))));
        return this.questionSet;
    }

    public DefaultQuestionSet2 thenForEach(BiFunction<PipelineChangeInput, List<T>, IncompletePipelineChange> changer) {
        this.questionSet.add(this.building);
        this.questionSet.addBuildPoint(new BasicBuildPoint(this.building.getName(), input -> (IncompletePipelineChange)changer.apply(new PipelineChangeInput(input.getBuildPoint(), input.getAnswer(), input.getBuildState()), input.getResponses(this.parameterType))));
        return this.questionSet;
    }

    public AddQuestion<T> customizeQuestion(Function<Question, Question> mutator) {
        this.building = mutator.apply(this.building);
        if (!this.building.getParameterType().equals(this.parameterType)) {
            throw new IllegalStateException("Can not change parameter type");
        }
        return this;
    }

    public AddQuestion<T> dependsOn(String questionNamed) {
        return this.dependsOn(this.questionSet.get(questionNamed));
    }

    public AddQuestion<T> dependsOn(Question dependency) {
        return this.customizeQuestion(q -> q.dependsOn(dependency));
    }

    public DefaultQuestionSet2 thenNoChange() {
        this.then((PipelineChangeInput input) -> PipelineChange.noChange());
        return this.questionSet;
    }

    private Object getResponse(String questionName, IncrementalBuildState buildState) {
        return buildState.getAnswerTo(this.questionSet.getId(), questionName, Object.class);
    }

    public AddQuestion<T> askWhenResponseIs(String questionNamed, Object hasResponse) {
        return this.askWhenResponseIs(this.questionSet.get(questionNamed), hasResponse);
    }

    public AddQuestion<T> askWhenResponseIs(Question dependency, Object hasResponse) {
        return this.customizeQuestion(q -> q.dependsOn(dependency).askWhen(bs -> hasResponse.equals(this.getResponse(dependency.getName(), (IncrementalBuildState)bs))));
    }

    public AddQuestion<T> askWhenDependencyIs(Predicate<Object> predicate) {
        return this.customizeQuestion(q -> q.askWhen(bs -> bs.getAnswer(this.questionSet.getId(), this.building.getDependsOn().get().getName()).map(answer -> predicate.test(answer.getValueAs(Object.class))).orElse(false)));
    }

    public AddQuestion<T> ifNotAnswered(String questionName) {
        return this.customizeQuestion(q -> q.askWhen(bs -> !bs.isResponseGiven(this.questionSet.getId(), questionName)));
    }

    @Generated
    public DefaultQuestionSet2 getQuestionSet() {
        return this.questionSet;
    }

    @Generated
    public Class<T> getParameterType() {
        return this.parameterType;
    }

    @Generated
    public Question getBuilding() {
        return this.building;
    }
}

