/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.model2.smp;

public enum SampleType {
    CENTROID("sample_centroid"),
    CLOSEST("sample_one", "buffer-distance: %s"),
    ALL_INTERSECTIONS("sample");

    private final String function;
    private final String optionalArgsFormat;

    private SampleType(String functionName) {
        this(functionName, "");
    }

    private SampleType(String functionName, String extraParams) {
        this.function = functionName;
        this.optionalArgsFormat = extraParams;
    }

    public String getFunctionCall(String geometry, String coverage) {
        return String.format("%s(geometry: %s, coverage: %s)", this.function, geometry, coverage);
    }

    public String getFunctionCall(String geometry, String coverage, Object ... args) {
        if (this.optionalArgsFormat.isEmpty()) {
            throw new AssertionError((Object)(String.valueOf((Object)this) + " does not support extra function arguments"));
        }
        return String.format("%s(geometry: %s, coverage: %s, %s)", this.function, geometry, coverage, String.format(this.optionalArgsFormat, args));
    }
}

