/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.model2.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.i18n.TranslationContext;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.PropertyAccess;
import nz.org.riskscape.rl.ast.StructDeclaration;
import nz.org.riskscape.wizard.Choice;
import nz.org.riskscape.wizard.QuestionSet;
import nz.org.riskscape.wizard.Survey;
import nz.org.riskscape.wizard.bind.AggregationExpression;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.bld.PipelineChange;
import nz.org.riskscape.wizard.bld.dsl.IncompletePipelineChange;
import nz.org.riskscape.wizard.bld.dsl.PipelineChangeInput;
import nz.org.riskscape.wizard.model2.DslHelper;
import nz.org.riskscape.wizard.model2.input.FilterByAttribute;
import nz.org.riskscape.wizard.model2.report.SortExpression;
import nz.org.riskscape.wizard.survey2.BasePhase;
import nz.org.riskscape.wizard.survey2.Choices;
import nz.org.riskscape.wizard.survey2.DefaultQuestionSet2;

public class ReportPhase
extends BasePhase {
    private static final String REPORT_NAME_QSET = "reports";
    private static final String REPORT_NAME_Q = "name";
    private static final String DEFAULT_REPORT = "event-impact";

    public ReportPhase(Survey survey) {
        super(survey);
    }

    @Override
    public List<QuestionSet> getAvailableQuestionSets(IncrementalBuildState buildState) {
        if (!buildState.getRealizedPipeline().getStep("event_impact_table").isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<QuestionSet> questionSets = new ArrayList<QuestionSet>();
        for (String reportName : this.getReportNames(buildState)) {
            if (buildState.isQuestionSetAnswered("report-" + reportName)) continue;
            questionSets.add(this.makeQuestionSet(reportName));
        }
        if (buildState.isQuestionSetAnswered("report-event-impact") && !buildState.isQuestionSetAnswered(REPORT_NAME_QSET)) {
            DefaultQuestionSet2 qsReportNames = new DefaultQuestionSet2(REPORT_NAME_QSET, this);
            qsReportNames.addQuestion(REPORT_NAME_Q, String.class).customizeQuestion(q -> q.optionalMany()).thenNoChange();
            questionSets.add(qsReportNames);
        }
        return questionSets;
    }

    private QuestionSet makeQuestionSet(String reportName) {
        DefaultQuestionSet2 questions = new DefaultQuestionSet2("report", reportName, this);
        questions.addHiddenQuestion("start").then(input -> PipelineChange.newChain("%s -> select({*}) as \"report_%s\"", "event_impact_table", reportName));
        questions.addQuestion("filter", Expression.class).customizeQuestion(q -> q.optionalOne().withAnnotations("expression-helper-expression-type", "boolean").withAskAs(FilterByAttribute.ASK_AS)).then((input, filterExpression) -> PipelineChange.chainStep("filter(%s)", filterExpression.toSource()));
        questions.addQuestion("group-by", StructDeclaration.class).customizeQuestion(q -> q.optionalMany().withChoices(bs -> {
            ArrayList<Choice> choices = new ArrayList<Choice>(Choices.from(q, bs));
            Choice total = new Choice(TokenTypes.quoteText((String)"Total"), "Total", Optional.of("Group all results together"), TokenTypes.quoteText((String)"Total")){

                @Override
                public String getLabel(TranslationContext context) {
                    return context.getMessage("phase.report.total.label", null, "Total");
                }

                @Override
                public String getDescription(TranslationContext context) {
                    return context.getMessage("phase.report.total.desc", null, "Group all results together");
                }
            };
            choices.add(total);
            return choices;
        })).thenNoChange();
        questions.addQuestion("aggregate", StructDeclaration.class).customizeQuestion(q -> q.optionalMany().withAskAs(AggregationExpression.ASK_AS)).dependsOn("group-by").thenNoChange();
        questions.addQuestion("bucket-by", PropertyAccess.class).customizeQuestion(q -> q.optionalOne().withAnnotations("attribute", "numeric")).dependsOn("group-by").thenNoChange();
        questions.addQuestion("bucket-range", Double.class).customizeQuestion(q -> q.atLeastOne()).dependsOn("bucket-by").thenNoChange();
        questions.addQuestion("bucket-aggregation", StructDeclaration.class).customizeQuestion(q -> q.atLeastOne().withAskAs(AggregationExpression.ASK_AS)).dependsOn("bucket-range").thenNoChange();
        questions.addQuestion("bucket-name", String.class).customizeQuestion(q -> q.requiredOne()).dependsOn("bucket-aggregation").thenNoChange();
        questions.addHiddenQuestion("finish-aggregate").dependsOn("group-by").then(input -> this.aggregationStepPipelineChange(input, questions.getId()));
        questions.addQuestion("select", StructDeclaration.class).customizeQuestion(q -> q.optionalMany()).thenForEach((input, responses) -> PipelineChange.chainStep("select({ %s })", DslHelper.asStructMembers(responses)));
        questions.addQuestion("sort-by", SortExpression.class).customizeQuestion(q -> q.optionalMany()).thenForEach((input, responses) -> {
            String attributes = responses.stream().map(se -> se.attribute.toSource()).collect(Collectors.joining(", "));
            String directions = responses.stream().map(se -> se.direction.name()).collect(Collectors.joining("', '", "['", "']"));
            return PipelineChange.chainStep("sort([%s], direction: %s)", attributes, directions);
        });
        questions.addQuestion("format", Format.class).customizeQuestion(q -> q.optionalOne()).then((input, format) -> PipelineChange.chainStep("save(name: '%s', format: '%s') as \"save_%s\"", reportName, format.getId(), reportName));
        questions.addHiddenQuestion("finish").ifNotAnswered("format").then(input -> PipelineChange.chainStep("save(name: '%s') as \"save_%s\"", reportName, reportName));
        return questions;
    }

    @Override
    public boolean canSkip(IncrementalBuildState buildState) {
        return true;
    }

    private List<String> getReportNames(IncrementalBuildState buildState) {
        ArrayList<String> reports = new ArrayList<String>();
        reports.add(DEFAULT_REPORT);
        List<String> names = buildState.getAnswersTo(REPORT_NAME_QSET, REPORT_NAME_Q, String.class);
        names = names.stream().map(str -> str.replaceAll(" ", "-")).collect(Collectors.toList());
        reports.addAll(names);
        return reports;
    }

    private IncompletePipelineChange aggregationStepPipelineChange(PipelineChangeInput input, final String questionSetId) {
        final IncrementalBuildState buildState = input.getBuildState();
        class AnswerGetter {
            AnswerGetter() {
            }

            public <T> T getAnswer(String questionName, Class<T> type) {
                return buildState.getAnswerTo(questionSetId, questionName, type);
            }

            public <T> List<T> getAnswers(String questionName, Class<T> type) {
                return buildState.getAnswersTo(questionSetId, questionName, type);
            }
        }
        AnswerGetter getter = new AnswerGetter();
        List<StructDeclaration> groupBys = getter.getAnswers("group-by", StructDeclaration.class);
        ArrayList<String> selects = new ArrayList<String>(List.of("*"));
        if (buildState.isResponseGiven(questionSetId, "aggregate")) {
            List<StructDeclaration> aggregateExpressions = getter.getAnswers("aggregate", StructDeclaration.class);
            selects.add(DslHelper.asStructMembers(aggregateExpressions));
        }
        if (buildState.isResponseGiven(questionSetId, "bucket-by")) {
            PropertyAccess bucketBy = getter.getAnswer("bucket-by", PropertyAccess.class);
            List<Double> range = getter.getAnswers("bucket-range", Double.class);
            List<StructDeclaration> aggregateExpressions = getter.getAnswers("bucket-aggregation", StructDeclaration.class);
            String bucketName = getter.getAnswer("bucket-name", String.class);
            String ranges = range.stream().map(bound -> {
                if (bound % 1.0 == 0.0) {
                    return String.valueOf(bound.intValue());
                }
                return String.valueOf(bound);
            }).collect(Collectors.joining(", "));
            selects.add(String.format("bucket_range(pick: %s, select: { %s }, range: [ %s ]) as %s", bucketBy.toSource(), DslHelper.asStructMembers(aggregateExpressions), ranges, bucketName));
        }
        return PipelineChange.chainStep("group(by: { %s }, select: { %s })", DslHelper.asStructMembers(groupBys), String.join((CharSequence)", ", selects));
    }
}

