/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.model2.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.GeometryProblems;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.data.ResolvedBookmark;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.problem.StandardCodes;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.QuestionSet;
import nz.org.riskscape.wizard.Survey;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.bld.InvalidAnswerException;
import nz.org.riskscape.wizard.bld.PipelineChange;
import nz.org.riskscape.wizard.bld.change.AppendJoinChange;
import nz.org.riskscape.wizard.bld.loc.AtStepNamed;
import nz.org.riskscape.wizard.bld.loc.ChangeLocation;
import nz.org.riskscape.wizard.bld.loc.EndOfBranchWith;
import nz.org.riskscape.wizard.model2.DslHelper;
import nz.org.riskscape.wizard.model2.input.Geoprocessing;
import nz.org.riskscape.wizard.survey2.BasePhase;
import nz.org.riskscape.wizard.survey2.DefaultQuestionSet2;

public class InputDataPhase
extends BasePhase {
    private static final String EXPOSURES_DATASET = "exposures";
    private static final String AREAS_DATASET = "areas";
    private static final String RESOURCES_DATASET = "resources";
    private static final String HAZARDS_DATASET = "hazards";
    public static final String EXPOSURE_ATTRIBUTE = InputDataPhase.getAttributeName("exposures");
    public static final String HAZARD_ATTRIBUTE = InputDataPhase.getAttributeName("hazards");
    public static final String RESOURCE_ATTRIBUTE = InputDataPhase.getAttributeName("resources");
    public static final ChangeLocation MAIN_BRANCH = EndOfBranchWith.stepNamed("exposures");
    private static final String INPUT_LAYER_SUFFIX = "_input";
    private static final String ANNO_PICK_MULTI_HAZARD = "multi-hazard-pick";
    private static final String ANNO_MULTI_HAZARD_INDEX = "multi-hazard-index";
    private final Geoprocessing geoprocessing = new Geoprocessing();

    public InputDataPhase(Survey survey) {
        super(survey);
    }

    public static String getAttributeName(String dataset) {
        return dataset.replaceAll("s$", "");
    }

    public static String getDatasetName(RealizedStep inputStep) {
        return inputStep.getStepName().replace(INPUT_LAYER_SUFFIX, "");
    }

    public static boolean isMultiHazard(IncrementalBuildState buildState) {
        return buildState.isQuestionSetAnswered("input-combine-hazards");
    }

    private static List<String> getInputLayers(IncrementalBuildState buildState) {
        return buildState.getRealizedPipeline().getStartSteps().stream().map(step -> step.getStepName()).filter(name -> name.endsWith(INPUT_LAYER_SUFFIX)).map(name -> name.replace(INPUT_LAYER_SUFFIX, "")).collect(Collectors.toList());
    }

    public static List<String> getDatasetsToSample(IncrementalBuildState buildState) {
        List<String> inputLayers = InputDataPhase.getInputLayers(buildState);
        inputLayers.remove(EXPOSURES_DATASET);
        return inputLayers;
    }

    @Override
    public List<QuestionSet> getAvailableQuestionSets(IncrementalBuildState buildState) {
        ArrayList<QuestionSet> sets = new ArrayList<QuestionSet>();
        RealizedPipeline pipeline = buildState.getRealizedPipeline();
        Set startSteps = pipeline.getStartSteps();
        if (!this.isHasInputStepForDataset(startSteps, EXPOSURES_DATASET)) {
            sets.add(this.createInputDataQuestionSet(EXPOSURES_DATASET));
        }
        int nextHazardLayerIndex = this.getNextUnusedHazardLayerIndex(buildState);
        if (!this.isAnsweredAnyTypeOfHazardQuestion(buildState)) {
            sets.add(this.createInputDataQuestionSet(HAZARDS_DATASET));
            sets.add(this.createInputDataQuestionSet(HAZARDS_DATASET, nextHazardLayerIndex));
        } else if (this.isBuildingMultiHazard(buildState)) {
            sets.add(this.createInputDataQuestionSet(HAZARDS_DATASET, nextHazardLayerIndex));
            sets.add(this.createCombineMultiHazardQuestionSet(buildState));
        }
        if (!this.isHasInputStepForDataset(startSteps, AREAS_DATASET)) {
            sets.add(this.createInputDataQuestionSet(AREAS_DATASET));
        }
        if (!this.isHasInputStepForDataset(startSteps, RESOURCES_DATASET)) {
            sets.add(this.createInputDataQuestionSet(RESOURCES_DATASET));
        }
        return sets;
    }

    @Override
    public boolean canSkip(IncrementalBuildState buildState) {
        Set startSteps = buildState.getRealizedPipeline().getStartSteps();
        boolean exposuresPicked = this.isHasInputStepForDataset(startSteps, EXPOSURES_DATASET);
        boolean hazardsPicked = this.isHasInputStepForDataset(startSteps, HAZARDS_DATASET) || this.isHazardsHaveBeenCombined(buildState);
        return exposuresPicked && hazardsPicked;
    }

    private static <T> Predicate<IncrementalBuildState> isResponse(String questionName, T response) {
        return buildState -> response.equals(buildState.getAnswerTo(buildState.getQuestionSet().getId(), questionName, response.getClass()));
    }

    private boolean isHasInputStepForDataset(Set<RealizedStep> startSteps, String datasetName) {
        String stepName = InputDataPhase.getInputStepNameFor(datasetName);
        return startSteps.stream().anyMatch(rs -> rs.getStepName().equals(stepName));
    }

    private static String getInputStepNameFor(String datasetName) {
        return datasetName + INPUT_LAYER_SUFFIX;
    }

    private QuestionSet createCombineMultiHazardQuestionSet(IncrementalBuildState buildState) {
        DefaultQuestionSet2 questionSet = new DefaultQuestionSet2("input-combine-hazards", this);
        List hazardEndSteps = buildState.getRealizedPipeline().getEndSteps().stream().filter(rs -> rs.getStepName().startsWith(HAZARDS_DATASET)).collect(Collectors.toList());
        List allPickStates = buildState.buildStateStream().filter(ibs -> ibs.getQuestion().hasAnnotation(ANNO_PICK_MULTI_HAZARD)).collect(Collectors.toList());
        if (allPickStates.isEmpty()) {
            throw new AssertionError((Object)"can not do multi hazard when no multi hazard layers have been picked");
        }
        questionSet.addHiddenQuestion("create-hazard-branch").then(input -> PipelineChange.newChain("input(value: {}, name: '%s') as %s", HAZARD_ATTRIBUTE, InputDataPhase.getInputStepNameFor(HAZARDS_DATASET)));
        for (RealizedStep endStep : hazardEndSteps) {
            String joinStepName = TokenTypes.quoteIdent((String)("input-multi-hazard-join-" + endStep.getStepName()));
            AtStepNamed otherSideLocation = new AtStepNamed(endStep.getStepName());
            questionSet.addHiddenQuestion("join-attribute-" + endStep.getStepName()).then(input -> answer -> new AppendJoinChange.Builder((Answer)answer).append("join(on: true) as %s", joinStepName).joins(otherSideLocation, "%s.rhs", joinStepName).build());
        }
        questionSet.addQuestion("grid-resolution", Double.class).then((input, gridResolution) -> PipelineChange.chainStep("select({combine_coverages(%s, %f) as %s}) as %s", this.createCombineCoveragesStructExpression(input.getBuildState()), gridResolution, HAZARD_ATTRIBUTE, HAZARDS_DATASET));
        return questionSet;
    }

    private String createCombineCoveragesStructExpression(IncrementalBuildState buildState) {
        return buildState.buildStateStream().filter(ibs -> ibs.getQuestion().hasAnnotation("hazard-attribute")).map(ibs -> {
            String coverageMember = ibs.getAnswer().getValueAs(String.class);
            return TokenTypes.quoteIdent((String)coverageMember);
        }).collect(Collectors.joining(", ", "{", "}"));
    }

    private boolean isBuildingMultiHazard(IncrementalBuildState buildState) {
        boolean doingMultiHazard = buildState.getRealizedPipeline().getStartSteps().stream().anyMatch(rs -> rs.getStepName().startsWith("hazards_1"));
        boolean doneCombine = this.isHazardsHaveBeenCombined(buildState);
        return doingMultiHazard && !doneCombine;
    }

    private boolean isHazardsHaveBeenCombined(IncrementalBuildState buildState) {
        return buildState.isQuestionSetAnswered("input-combine-hazards");
    }

    private int getNextUnusedHazardLayerIndex(IncrementalBuildState buildState) {
        return (int)buildState.buildStateStream().map(ibs -> ibs.getQuestion().getAnnotation(ANNO_MULTI_HAZARD_INDEX)).filter(Optional::isPresent).count() + 1;
    }

    private boolean isAnsweredAnyTypeOfHazardQuestion(IncrementalBuildState buildState) {
        return buildState.getRealizedPipeline().getStartSteps().stream().anyMatch(rs -> rs.getStepName().startsWith(HAZARDS_DATASET));
    }

    private String getDatasetLabel(String datasetName, Locale locale) {
        return this.survey.getMessageSource().getMessage("question.input.dataset." + datasetName, null, datasetName, locale);
    }

    public QuestionSet createInputDataQuestionSet(String datasetName) {
        return this.createInputDataQuestionSet(datasetName, 0);
    }

    public QuestionSet createInputDataQuestionSet(String originalDatasetName, int multiHazardIndex) {
        String datasetName = multiHazardIndex == 0 ? originalDatasetName : originalDatasetName + "_" + multiHazardIndex;
        String startStepName = InputDataPhase.getInputStepNameFor(datasetName);
        DefaultQuestionSet2 questionSet = new DefaultQuestionSet2("input", datasetName, this);
        questionSet.setDefaultLocation(EndOfBranchWith.stepNamed(startStepName));
        questionSet.addQuestion("layer", ResolvedBookmark.class).customizeQuestion(q -> {
            if (multiHazardIndex > 0) {
                q = q.withAnnotations(ANNO_MULTI_HAZARD_INDEX, String.valueOf(multiHazardIndex), ANNO_PICK_MULTI_HAZARD, "");
            }
            q = q.withI18nLookup((suffix, locale) -> this.survey.getMessageSource().getMessage("question.input.layer." + suffix + "." + datasetName, new Object[]{this.getDatasetLabel(datasetName, (Locale)locale), "Select which layer you want to use", locale}));
            return q;
        }).then((input, response) -> {
            String dataArg;
            String id = TokenTypes.quoteText((String)response.getId());
            if (response.isType(Relation.class)) {
                ProblemException.catching(() -> this.validateRelation((ResultOrProblems<Relation>)response.getData(Relation.class))).orElseThrow(problems -> new InvalidAnswerException(input, (List<Problem>)problems));
                dataArg = "relation: " + id;
            } else if (datasetName.equals(EXPOSURES_DATASET)) {
                ProblemException.catching(() -> this.validateRelation((ResolvedBookmark)response)).orElseThrow(problems -> new InvalidAnswerException(input, (List<Problem>)problems));
                dataArg = "relation: " + id;
            } else {
                dataArg = "value: bookmark(" + id + ")";
            }
            return PipelineChange.newChain("input(%s, name: %s) as %s", dataArg, TokenTypes.quoteText((String)InputDataPhase.getAttributeName(datasetName)), startStepName);
        });
        if (multiHazardIndex > 0) {
            questionSet.addQuestion("hazard-attribute", String.class).customizeQuestion(q -> q.withAnnotations("hazard-attribute", datasetName)).thenNoChange();
        }
        questionSet.addQuestion("geoprocess", Boolean.class).customizeQuestion(q -> q.askWhen(InputDataPhase.isDataSuitableForProcessing(datasetName))).customizeQuestion(q -> q.withI18nLookup((suffix, locale) -> this.survey.getMessageSource().getMessage("question.input.geoprocess." + suffix, new Object[]{this.getDatasetLabel(datasetName, (Locale)locale)}))).then(r -> PipelineChange.noChange());
        this.geoprocessing.addQuestions(questionSet, InputDataPhase.getAttributeName(datasetName));
        questionSet.addHiddenQuestion("finalize").then(input -> {
            String attributeName = InputDataPhase.getAttributeName(datasetName);
            boolean isExposureLayer = datasetName.equals(EXPOSURES_DATASET);
            if (isExposureLayer) {
                return PipelineChange.chainStep("select({%s}) as %s", attributeName, datasetName);
            }
            String newName = input.getBuildState().getAnswer(questionSet.getId(), "hazard-attribute").map(a -> a.getValueAs(String.class)).orElse(attributeName);
            if (InputDataPhase.isDataSuitableForProcessing(datasetName).test(input.getBuildState())) {
                return PipelineChange.chainStep("group({to_coverage(%s) as %s}) as %s", attributeName, newName, datasetName);
            }
            return PipelineChange.chainStep("select({%s as %s}) as %s", attributeName, newName, datasetName);
        });
        return questionSet;
    }

    private static Predicate<IncrementalBuildState> isDataSuitableForProcessing(String datasetName) {
        return ibs -> {
            String attributeName = InputDataPhase.getAttributeName(datasetName);
            return ibs.getRealizedPipeline().getStep(InputDataPhase.getInputStepNameFor(datasetName)).flatMap(step -> DslHelper.getAttributeType(step.getProduces(), attributeName, Struct.class)).map(struct -> TupleUtils.findGeometryMember((Struct)struct, (TupleUtils.FindOption)TupleUtils.FindOption.OPTIONAL) != null).orElse(false);
        };
    }

    public static boolean isHazardDataset(String datasetName) {
        return datasetName.equals(HAZARDS_DATASET);
    }

    private boolean validateRelation(ResolvedBookmark bookmark) throws ProblemException {
        if (bookmark.isType(TypedCoverage.class) && ((Boolean)bookmark.getData(TypedCoverage.class).map(tc -> tc.asRelation().isPresent()).orElse((Object)false)).booleanValue()) {
            return true;
        }
        return this.validateRelation((ResultOrProblems<Relation>)bookmark.getData(Relation.class));
    }

    private boolean validateRelation(ResultOrProblems<Relation> relationOr) throws ProblemException {
        Relation relation = (Relation)relationOr.drainWarnings((Consumer)ProblemSink.DEVNULL).getOrThrow();
        Struct.StructMember geomMember = TupleUtils.findGeometryMember((Struct)relation.getType(), (TupleUtils.FindOption)TupleUtils.FindOption.OPTIONAL);
        if (geomMember == null) {
            throw new ProblemException((Problems)Problem.error((ProblemCode)StandardCodes.GEOMETRY_REQUIRED, (Object[])new Object[]{relation.getType()}));
        }
        geomMember.getType().find(Referenced.class).orElseThrow(() -> new ProblemException((Problems)GeometryProblems.get().notReferenced(geomMember.getType())));
        return true;
    }
}

