/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.model2.input;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.data.ResolvedBookmark;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.PropertyAccess;
import nz.org.riskscape.rl.ast.StructDeclaration;
import nz.org.riskscape.wizard.bld.PipelineChange;
import nz.org.riskscape.wizard.bld.change.AppendJoinChange;
import nz.org.riskscape.wizard.bld.dsl.IncompletePipelineChange;
import nz.org.riskscape.wizard.bld.dsl.PipelineChangeInput;
import nz.org.riskscape.wizard.bld.loc.ChangeLocation;
import nz.org.riskscape.wizard.bld.loc.EndOfBranchWith;
import nz.org.riskscape.wizard.model2.DslHelper;
import nz.org.riskscape.wizard.model2.input.CutType;
import nz.org.riskscape.wizard.model2.input.CuttingIncludes;
import nz.org.riskscape.wizard.model2.input.EnlargeBy;
import nz.org.riskscape.wizard.model2.input.FilterByAttribute;
import nz.org.riskscape.wizard.model2.input.FilterType;
import nz.org.riskscape.wizard.model2.input.RecomputeAttribute;
import nz.org.riskscape.wizard.survey2.DefaultQuestionSet2;
import org.locationtech.jts.geom.Lineal;

public class Geoprocessing {
    public static final String GEOPROCESS_QUESTION = "geoprocess";

    public void addQuestions(DefaultQuestionSet2 questionSet, String layerAttribute) {
        this.addFilterQuestions(questionSet, layerAttribute);
        this.addEnlargeQuestions(questionSet, layerAttribute);
        this.addCutQuestions(questionSet, layerAttribute);
        questionSet.addQuestion("save-raw-results", Boolean.class).customizeQuestion(q -> q.optionalOne()).askWhenResponseIs(GEOPROCESS_QUESTION, (Object)Boolean.TRUE).then((input, response) -> {
            if (response.equals(Boolean.TRUE)) {
                String stepToHangOff = layerAttribute + "_geoprocessed";
                return PipelineChange.many(PipelineChange.chainStep("select({*}) as %s", stepToHangOff), PipelineChange.newChain("%s -> save('%s-geoprocessed')", stepToHangOff, layerAttribute));
            }
            return PipelineChange.noChange();
        });
        questionSet.addHiddenQuestion("strip-wip-attrs").askWhenResponseIs(GEOPROCESS_QUESTION, (Object)Boolean.TRUE).then(input -> PipelineChange.chainStep("select({ %s })", layerAttribute));
    }

    private void addFilterQuestions(DefaultQuestionSet2 questionSet, String layerAttribute) {
        questionSet.addHiddenQuestion("geoprocess-start").askWhenResponseIs(GEOPROCESS_QUESTION, (Object)Boolean.TRUE).then(input -> PipelineChange.chainStep("select({*}) as \"geoprocess_%s\"", layerAttribute));
        questionSet.addQuestion("filter", FilterType.class).customizeQuestion(q -> q.optionalOne()).askWhenResponseIs(GEOPROCESS_QUESTION, (Object)Boolean.TRUE).then(r -> PipelineChange.noChange());
        questionSet.addQuestion("filter-expression", Expression.class).askWhenResponseIs("filter", (Object)FilterType.BY_EXPRESSION).customizeQuestion(q -> q.withAnnotations("expression-helper-expression-type", "boolean").withAskAs(FilterByAttribute.ASK_AS)).then((input, filterExpression) -> PipelineChange.chainStep("filter(%s)", filterExpression.toSource()));
        questionSet.addQuestion("filter-bounds", ResolvedBookmark.class).askWhenResponseIs("filter", (Object)FilterType.BY_LAYER_BOUNDS).then((input, response) -> PipelineChange.chainStep("filter(intersects(%s, bounds(bookmark(%s))))", layerAttribute, TokenTypes.quoteText((String)response.getId())));
        String filterLayerJoinStep = layerAttribute + "_filter_layer_join";
        String filterLayerInputStep = "filter_layer_" + layerAttribute;
        String filterLayerCoverage = layerAttribute + "_filter_coverage";
        questionSet.addQuestion("filter-layer", ResolvedBookmark.class).askWhenResponseIs("filter", (Object)FilterType.BY_FEATURE_IN_LAYER).then((input, bookmark) -> PipelineChange.newChain("input(relation: %s) as %s", TokenTypes.quoteText((String)bookmark.getId()), filterLayerInputStep));
        questionSet.addQuestion("filter-layer-condition", Expression.class).customizeQuestion(q -> q.atLocation(ChangeLocation.atStep(filterLayerInputStep)).withAnnotations("expression-helper-expression-type", "boolean", "expression-helper-layer-question", "filter-layer")).dependsOn("filter-layer").then((input, response) -> PipelineChange.chainStep("filter(%s) -> group({to_coverage(*) as %s})", response.toSource(), filterLayerCoverage));
        questionSet.addHiddenQuestion("filter-layer-join").dependsOn("filter-layer-condition").then((input, response) -> answer -> AppendJoinChange.builder(answer).append("join(on: true).lhs as %s -> filter(length(sample(%s, coverage: %s)) > 0) -> select({%s})", filterLayerJoinStep, layerAttribute, filterLayerCoverage, layerAttribute).joins(EndOfBranchWith.stepNamed(filterLayerInputStep), "%s.rhs", filterLayerJoinStep).build());
    }

    private void addEnlargeQuestions(DefaultQuestionSet2 questionSet, String layerAttribute) {
        questionSet.addQuestion("enlarge", Boolean.class).customizeQuestion(q -> q.optionalOne()).askWhenResponseIs(GEOPROCESS_QUESTION, (Object)Boolean.TRUE).thenNoChange();
        questionSet.addQuestion("enlarge-by", EnlargeBy.class).askWhenResponseIs("enlarge", (Object)Boolean.TRUE).then((input, enlargeBy) -> {
            Type geomType = this.getGeometryAttribute(input, layerAttribute).getType();
            boolean lineal = Lineal.class.isAssignableFrom(geomType.internalType());
            return PipelineChange.chainStep("enlarge(distance: %s%s, mode: '%s', remove-overlaps: %b)", enlargeBy.distance.toSource(), lineal ? " / 2" : "", enlargeBy.mode.name(), enlargeBy.removeOverlaps);
        });
    }

    private void addCutQuestions(DefaultQuestionSet2 questionSet, String layerAttribute) {
        questionSet.addQuestion("cut", CutType.class).customizeQuestion(q -> q.optionalOne()).askWhenResponseIs(GEOPROCESS_QUESTION, (Object)Boolean.TRUE).thenNoChange();
        questionSet.addQuestion("cut-distance", Double.class).askWhenResponseIs("cut", (Object)CutType.BY_DISTANCE).then((input, distance) -> {
            String cutGeom = layerAttribute + "_cut_geom";
            String geomAttr = this.getGeometryAttributeName(input, layerAttribute);
            StringBuilder sb = new StringBuilder();
            try (Formatter dsl = new Formatter(sb);){
                dsl.format("select({*, segment(%s, %f) as %s}) -> ", layerAttribute, distance, cutGeom);
                dsl.format("unnest(%s, 'segmentID') -> ", cutGeom);
                dsl.format("select({ ", new Object[0]);
                dsl.format(" { %s.*, segmentID, %s as %s } as %s,", layerAttribute, cutGeom, geomAttr, layerAttribute);
                dsl.format(" measure(%s) / measure(%s.%s) as scale_factor", cutGeom, layerAttribute, geomAttr);
                dsl.format(" })", new Object[0]);
                IncompletePipelineChange incompletePipelineChange = PipelineChange.chainStep(sb.toString(), new Object[0]);
                return incompletePipelineChange;
            }
        });
        questionSet.addQuestion("cut-by-layer", ResolvedBookmark.class).askWhenResponseIs("cut", (Object)CutType.BY_LAYER).thenNoChange();
        questionSet.addQuestion("cut-by-layer-attributes", StructDeclaration.class).askWhenResponseIs("cut", (Object)CutType.BY_LAYER).customizeQuestion(q -> q.optionalMany().withAnnotations("expression-helper-layer-question", "cut-by-layer")).thenNoChange();
        questionSet.addQuestion("cut-by-layer-include", CuttingIncludes.class).askWhenResponseIs("cut", (Object)CutType.BY_LAYER).then((input, include) -> {
            ResolvedBookmark bookmark = input.getBuildState().getResponse(questionSet.getId(), "cut-by-layer", ResolvedBookmark.class).get();
            List<StructDeclaration> membersToCopy = input.getBuildState().getAnswersTo(questionSet.getId(), "cut-by-layer-attributes", StructDeclaration.class);
            String copyAttrs = this.getCutLayerAttributesToCopy(membersToCopy);
            boolean returnDifference = include == CuttingIncludes.ALL_PARTS;
            String geomAttr = this.getGeometryAttributeName(input, layerAttribute);
            String geomAttrFull = layerAttribute + "." + geomAttr;
            StringBuilder sb = new StringBuilder();
            try (Formatter dsl = new Formatter(sb);){
                dsl.format("select({ orig_geom: %s,", geomAttrFull);
                dsl.format(" %s: layer_intersection(%s, bookmark('%s'), {%s}, %b) ", layerAttribute, layerAttribute, bookmark.getId(), copyAttrs, returnDifference);
                dsl.format("}) -> ", new Object[0]);
                dsl.format("unnest(%s, 'segmentID') -> ", layerAttribute);
                dsl.format("select({ ", new Object[0]);
                dsl.format(" { %s.*, segmentID } as %s,", layerAttribute, layerAttribute);
                dsl.format(" measure(%s) / measure(orig_geom) as scale_factor", geomAttrFull);
                dsl.format("})", new Object[0]);
                IncompletePipelineChange incompletePipelineChange = PipelineChange.chainStep(sb.toString(), new Object[0]);
                return incompletePipelineChange;
            }
        });
        questionSet.addQuestion("scale-attributes", PropertyAccess.class).dependsOn("cut").customizeQuestion(q -> q.optionalMany().withAnnotations("attribute", "numeric")).thenForEach((input, responses) -> {
            String scaledAttrs = responses.stream().map(attr -> String.format("scale_factor * %s as %s", attr.toSource(), attr.getLastIdentifier().getValue())).collect(Collectors.joining(", "));
            return PipelineChange.chainStep("select({ { %s.*, %s } as %s })", layerAttribute, scaledAttrs, layerAttribute);
        });
        questionSet.addQuestion("recompute", RecomputeAttribute.class).dependsOn("cut").customizeQuestion(q -> q.optionalMany().withAnnotations("attribute", "numeric")).thenForEach((input, responses) -> {
            String recomputedAttrs = responses.stream().map(r -> String.format("%s as %s", r.expression.toSource(), r.attribute.getLastIdentifier().getValue())).collect(Collectors.joining(", "));
            return PipelineChange.chainStep("select({ { %s.*, %s } as %s })", layerAttribute, recomputedAttrs, layerAttribute);
        });
    }

    private String getCutLayerAttributesToCopy(List<StructDeclaration> answers) {
        ArrayList membersToCopy = new ArrayList();
        for (StructDeclaration expr : answers) {
            membersToCopy.addAll(expr.getMembers());
        }
        return membersToCopy.stream().map(attr -> String.format("%s: '%s'", attr.getAttributeName(), attr.getExpression().toSource())).collect(Collectors.joining(", "));
    }

    private Struct.StructMember getGeometryAttribute(PipelineChangeInput input, String layerAttribute) {
        Struct datasetStruct = DslHelper.getAttributeType(input.getStruct(), layerAttribute, Struct.class).get();
        return TupleUtils.findGeometryMember((Struct)datasetStruct, (TupleUtils.FindOption)TupleUtils.FindOption.ANY_REQUIRED);
    }

    private String getGeometryAttributeName(PipelineChangeInput input, String layerAttribute) {
        Struct.StructMember geom = this.getGeometryAttribute(input, layerAttribute);
        return TokenTypes.quoteIdent((String)geom.getKey());
    }
}

