/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.model2.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.rl.FunctionCallPrototype;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.PropertyAccess;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.QuestionSet;
import nz.org.riskscape.wizard.Survey;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.bld.PipelineChange;
import nz.org.riskscape.wizard.bld.dsl.IncompletePipelineChange;
import nz.org.riskscape.wizard.bld.dsl.PipelineChangeInput;
import nz.org.riskscape.wizard.bld.loc.ChangeLocation;
import nz.org.riskscape.wizard.model2.DslHelper;
import nz.org.riskscape.wizard.model2.input.InputDataPhase;
import nz.org.riskscape.wizard.model2.smp.SamplePhase;
import nz.org.riskscape.wizard.survey2.BasePhase;
import nz.org.riskscape.wizard.survey2.Choices;
import nz.org.riskscape.wizard.survey2.DefaultQuestionSet2;

public class AnalysisPhase
extends BasePhase {
    public static final String CONSEQUENCE = "consequence";
    private static final String QUESTION_SET_ID = "analysis";
    private static final EnumSet<IdentifiedFunction.Category> CATEGORIES = EnumSet.of(IdentifiedFunction.Category.RISK_MODELLING, IdentifiedFunction.Category.UNASSIGNED);
    public static final String LAST_STEP_NAME = "event_impact_table";

    public AnalysisPhase(Survey survey) {
        super(survey);
    }

    @Override
    public QuestionSet buildQuestionSet(IncrementalBuildState buildState) {
        DefaultQuestionSet2 qs = new DefaultQuestionSet2(QUESTION_SET_ID, this);
        qs.setDefaultLocation(InputDataPhase.MAIN_BRANCH);
        qs.addQuestion("map-hazard", Boolean.class).customizeQuestion(q -> q.askWhen(bs -> !InputDataPhase.isMultiHazard(bs) && this.getHazardType(bs.getInputStruct((Question)q)).isA(Struct.class))).thenNoChange();
        qs.addQuestion("map-hazard-intensity", PropertyAccess.class).askWhenResponseIs("map-hazard", (Object)Boolean.TRUE).customizeQuestion(q -> q.withChoices(ibs -> {
            Type hazardType = this.getHazardType(ibs.getInputStruct((Question)q));
            return Choices.forScope((Struct)hazardType.findAllowNull(Struct.class).get(), q);
        })).then((input, hazardAttr) -> PipelineChange.chainStep("select({*, %s: map(%s, hv -> hv.%s)})", InputDataPhase.HAZARD_ATTRIBUTE, InputDataPhase.HAZARD_ATTRIBUTE, hazardAttr.toSource()));
        qs.addQuestion("aggregate-hazards", Boolean.class).customizeQuestion(q -> q.askWhen(bs -> {
            Optional<RSList> hazard = DslHelper.getAttributeType(bs.getInputStruct((Question)q), InputDataPhase.HAZARD_ATTRIBUTE, RSList.class);
            return hazard.isPresent() && !hazard.get().getMemberType().findAllowNull(Struct.class).isPresent();
        })).thenNoChange();
        qs.addQuestion("aggregate-hazards-function", FunctionCallPrototype.class).customizeQuestion(q -> q.withAnnotations("aggregation", "")).askWhenResponseIs("aggregate-hazards", (Object)Boolean.TRUE).then((input, aggFunction) -> PipelineChange.chainStep("select({*, %s: %s})", InputDataPhase.HAZARD_ATTRIBUTE, aggFunction.setFirstArgument(InputDataPhase.HAZARD_ATTRIBUTE, new Object[0]).build().toSource()));
        qs.addQuestion("function", IdentifiedFunction.class).customizeQuestion(q -> q.withChoices(ibs -> Choices.forFunctions(ibs, CATEGORIES))).then((input, answer) -> {
            boolean hasResource = input.getStruct().hasMember(InputDataPhase.RESOURCE_ATTRIBUTE);
            return PipelineChange.chainStep("select({*, %s: map(%s, hv -> %s(%s, hv%s))})", CONSEQUENCE, InputDataPhase.HAZARD_ATTRIBUTE, TokenTypes.quoteIdent((String)answer.getId()), InputDataPhase.EXPOSURE_ATTRIBUTE, hasResource ? ", " + InputDataPhase.RESOURCE_ATTRIBUTE : "");
        });
        qs.addQuestion("scale-losses", Boolean.class).customizeQuestion(q -> q.askWhen(bs -> bs.getInputStruct((Question)q).hasMember("exposed_ratio") && DslHelper.getAttributeType(bs.getInputStruct((Question)q), CONSEQUENCE, RSList.class).isPresent())).then((input, doScaling) -> {
            if (doScaling.booleanValue()) {
                return PipelineChange.chainStep("select({*, raw_consequence: consequence, consequence: zip(consequence, exposed_ratio, (loss, ratio) -> loss * ratio)})", new Object[0]);
            }
            return PipelineChange.noChange();
        });
        qs.addHiddenQuestion("raw-results").then(input -> PipelineChange.chainStep("select({*}) as raw_results", new Object[0]));
        qs.addQuestion("aggregate-consequences", Boolean.class).customizeQuestion(q -> q.askWhen(bs -> DslHelper.getAttributeType(bs.getInputStruct((Question)q), InputDataPhase.HAZARD_ATTRIBUTE, RSList.class).isPresent())).thenNoChange();
        qs.addQuestion("aggregate-consequences-function", FunctionCallPrototype.class).customizeQuestion(q -> q.withAnnotations("aggregation", "")).askWhenResponseIs("aggregate-consequences", (Object)Boolean.TRUE).then((input, aggFunction) -> PipelineChange.chainStep("select({*, %s: %s})", CONSEQUENCE, aggFunction.setFirstArgument(CONSEQUENCE, new Object[0]).build().toSource()));
        qs.addQuestion("save-raw-results", Boolean.class).customizeQuestion(q -> q.optionalOne().askWhen(bs -> DslHelper.getAttributeType(bs.getInputStruct((Question)q), SamplePhase.SAMPLED_HAZARD, RSList.class).isPresent()).atLocation(ChangeLocation.atStep("raw_results"))).then((input, doSave) -> {
            if (doSave.booleanValue()) {
                return this.saveRawResults(input);
            }
            return PipelineChange.noChange();
        });
        qs.addHiddenQuestion("final").then((input, answer) -> {
            ArrayList mapAttributes = input.getStruct().getMembers().stream().map(Struct.StructMember::getKey).collect(Collectors.toCollection(ArrayList::new));
            if (DslHelper.getAttributeType(input.getStruct(), "exposed_ratio", RSList.class).isPresent()) {
                mapAttributes.set(mapAttributes.indexOf("exposed_ratio"), String.format("min(sum(%s), 1.0) as %s", "exposed_ratio", "exposed_ratio"));
            }
            mapAttributes.remove(SamplePhase.SAMPLED_HAZARD);
            return PipelineChange.chainStep("select({%s}) as %s", String.join((CharSequence)", ", mapAttributes), LAST_STEP_NAME);
        });
        return qs;
    }

    private IncompletePipelineChange saveRawResults(PipelineChangeInput input) {
        List<String> possibleLists = Arrays.asList(SamplePhase.SAMPLED_HAZARD, InputDataPhase.HAZARD_ATTRIBUTE, "raw_consequence", "exposed_ratio", CONSEQUENCE);
        ArrayList<String> unnestAttrs = new ArrayList<String>();
        Struct inputScope = input.getStruct();
        for (String attr : possibleLists) {
            if (!DslHelper.getAttributeType(inputScope, attr, RSList.class).isPresent()) continue;
            unnestAttrs.add(attr);
        }
        String unnestStep = unnestAttrs.stream().collect(Collectors.joining(", ", "unnest([", "])"));
        ArrayList<String> attributes = new ArrayList<String>(inputScope.getMemberKeys());
        attributes.remove(SamplePhase.SAMPLED_HAZARD);
        attributes.add(0, SamplePhase.SAMPLED_HAZARD);
        String selectStep = String.format("select({%s})", String.join((CharSequence)", ", attributes));
        return PipelineChange.newChain("raw_results -> %s -> %s -> save(name: 'raw-analysis')", unnestStep, selectStep);
    }

    private Type getHazardType(Struct inputType) {
        Type hazardType = DslHelper.getAttributeType(inputType, InputDataPhase.HAZARD_ATTRIBUTE, Type.class).get();
        return hazardType.findAllowNull(RSList.class).map(RSList::getContainedType).orElse(hazardType);
    }
}

