/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.bld.loc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import nz.org.riskscape.pipeline.ast.PipelineDeclaration;
import nz.org.riskscape.pipeline.ast.StepChain;
import nz.org.riskscape.pipeline.ast.StepDeclaration;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.bld.loc.ChangeLocation;

public class AtLastChange
implements ChangeLocation {
    public static final AtLastChange INSTANCE = new AtLastChange();

    private AtLastChange() {
    }

    @Override
    public List<PipelineDeclaration.Found> find(IncrementalBuildState buildState) {
        return this.findOne(buildState).map(v -> Collections.singletonList(v)).orElse(Collections.emptyList());
    }

    @Override
    public Optional<PipelineDeclaration.Found> findOne(IncrementalBuildState buildState) {
        if (buildState.isEmpty()) {
            return Optional.empty();
        }
        PipelineDeclaration latestAst = buildState.getAst();
        IncrementalBuildState ptr = buildState;
        PipelineDeclaration oldAst = null;
        while (!ptr.isEmpty()) {
            oldAst = (ptr = ptr.getLast()).getAst();
            if (oldAst.equals((Object)latestAst)) continue;
            return Optional.ofNullable(this.findLastChange(oldAst, latestAst));
        }
        return Optional.of(PipelineDeclaration.Found.last((PipelineDeclaration)latestAst, (StepChain)latestAst.getLast()));
    }

    @Override
    public String toString() {
        return "at last change";
    }

    protected PipelineDeclaration.Found findLastChange(PipelineDeclaration oldAst, PipelineDeclaration latestAst) {
        if (oldAst.getChains().size() != latestAst.getChains().size()) {
            return PipelineDeclaration.Found.last((PipelineDeclaration)latestAst, (StepChain)latestAst.getLast());
        }
        Iterator<StepChain> oldChains = this.revChainIterator(oldAst);
        Iterator<StepChain> latestChains = this.revChainIterator(latestAst);
        while (oldChains.hasNext()) {
            StepChain latestChain;
            StepChain oldChain = oldChains.next();
            if (oldChain.equals((Object)(latestChain = latestChains.next()))) continue;
            return this.findLatestChange(latestAst, oldChain, latestChain);
        }
        throw new AssertionError((Object)"chains are all equal yet asts are not");
    }

    private PipelineDeclaration.Found findLatestChange(PipelineDeclaration ast, StepChain oldChain, StepChain latestChain) {
        if (oldChain.size() != latestChain.size()) {
            return PipelineDeclaration.Found.last((PipelineDeclaration)ast, (StepChain)latestChain);
        }
        Iterator<StepDeclaration> oldSteps = this.revStepIterator(oldChain);
        Iterator<StepDeclaration> latestSteps = this.revStepIterator(latestChain);
        while (oldSteps.hasNext()) {
            StepDeclaration latestStep;
            StepDeclaration oldStep = oldSteps.next();
            if (oldStep.equals((Object)(latestStep = latestSteps.next()))) continue;
            return new PipelineDeclaration.Found(ast, latestChain, latestStep);
        }
        throw new AssertionError((Object)"steps are all equal yet chains are not");
    }

    private Iterator<StepDeclaration> revStepIterator(StepChain chain) {
        return this.revIterator(chain.getSteps());
    }

    private Iterator<StepChain> revChainIterator(PipelineDeclaration pipeline) {
        return this.revIterator(pipeline.getChains());
    }

    private <T> Iterator<T> revIterator(List<T> list) {
        ArrayList<T> clone = new ArrayList<T>(list);
        Collections.reverse(clone);
        return clone.iterator();
    }
}

