/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.bld;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import nz.org.riskscape.dsl.LexerException;
import nz.org.riskscape.dsl.ParseException;
import nz.org.riskscape.pipeline.PipelineParser;
import nz.org.riskscape.pipeline.ast.PipelineDeclaration;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.QuestionSet;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.bld.change.AppendStepChange;
import nz.org.riskscape.wizard.bld.change.BadPipelineChangeException;
import nz.org.riskscape.wizard.bld.change.MultipleChanges;
import nz.org.riskscape.wizard.bld.change.NoChange;
import nz.org.riskscape.wizard.bld.change.SimpleChange;
import nz.org.riskscape.wizard.bld.change.StartChainChange;
import nz.org.riskscape.wizard.bld.dsl.IncompletePipelineChange;

public interface PipelineChange {
    public static IncompletePipelineChange chainStep(String pipelineFragment, Object ... args) {
        return answer -> new AppendStepChange((Answer)answer, String.format(pipelineFragment, args));
    }

    public static IncompletePipelineChange newChain(String pipelineFragment, Object ... args) {
        return answer -> new StartChainChange((Answer)answer, String.format(pipelineFragment, args));
    }

    public static IncompletePipelineChange simple(BiFunction<Answer, IncrementalBuildState, PipelineDeclaration> function) {
        return answer -> new SimpleChange((Answer)answer, function);
    }

    public static IncompletePipelineChange many(List<IncompletePipelineChange> children) {
        return answer -> new MultipleChanges((Answer)answer, children);
    }

    public static IncompletePipelineChange many(IncompletePipelineChange ... children) {
        return answer -> new MultipleChanges((Answer)answer, Arrays.asList(children));
    }

    public static IncompletePipelineChange noChange() {
        return answer -> new NoChange((Answer)answer);
    }

    public static IncompletePipelineChange failed(final List<Problem> problems) {
        return answer -> new PipelineChange(){
            final /* synthetic */ Answer val$answer;
            {
                this.val$answer = answer;
            }

            @Override
            public ResultOrProblems<IncrementalBuildState> make(IncrementalBuildState currentState) throws BadPipelineChangeException {
                return ResultOrProblems.failed((List)problems);
            }

            @Override
            public Answer getAnswer() {
                return this.val$answer;
            }
        };
    }

    public ResultOrProblems<IncrementalBuildState> make(IncrementalBuildState var1) throws BadPipelineChangeException;

    public Answer getAnswer();

    default public PipelineDeclaration parse(String pipelineSource) {
        try {
            return PipelineParser.INSTANCE.parsePipeline(pipelineSource);
        }
        catch (LexerException e) {
            throw new BadPipelineChangeException(this, "Could not parse " + pipelineSource, e);
        }
        catch (ParseException e) {
            throw new BadPipelineChangeException(this, "Could not parse " + pipelineSource, e);
        }
    }

    default public QuestionSet getQuestionSet() {
        return this.getAnswer().getQuestionSet();
    }

    default public Question getQuestion() {
        return this.getAnswer().getQuestion();
    }
}

