/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.bld;

import com.google.common.collect.Streams;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.PipelineExecutor;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.pipeline.SinkConstructor;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.pipeline.ast.PipelineDeclaration;
import nz.org.riskscape.pipeline.ast.StepDeclaration;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.EmptyQuestionSet;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.QuestionSet;
import nz.org.riskscape.wizard.Survey;
import nz.org.riskscape.wizard.bld.PipelineChange;
import nz.org.riskscape.wizard.bld.change.NoChange;
import nz.org.riskscape.wizard.bld.loc.ChangeLocation;

public class IncrementalBuildState {
    public static final String START_STEP_NAME = "start";
    public static final QuestionSet EMPTY_QUESTION_SET = new EmptyQuestionSet("empty", Survey.EMPTY_SURVEY);
    public static final Question EMPTY_QUESTION = new Question("", Void.class).optionalOne().inSet(EMPTY_QUESTION_SET);
    public static final Answer EMPTY_ANSWER = new Answer(EMPTY_QUESTION, Collections.emptyList());
    public static final Set<RealizedStep> START_STEPS_SET = Collections.singleton(RealizedStep.emptyInput((String)"start", (Struct)Struct.EMPTY_STRUCT));
    private final Context context;
    private final IncrementalBuildState last;
    private final PipelineChange createdBy;
    private final PipelineDeclaration ast;
    private final RealizedPipeline realizedPipeline;

    public static IncrementalBuildState empty(Context context) {
        return new IncrementalBuildState(context, null, new NoChange(EMPTY_ANSWER), PipelineDeclaration.EMPTY, new RealizedPipeline(context.executionContext, PipelineDeclaration.EMPTY, Collections.emptyList())){

            @Override
            public IncrementalBuildState getLast() {
                return this;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }
        };
    }

    private IncrementalBuildState(IncrementalBuildState previous, PipelineChange createdBy, PipelineDeclaration newAst, RealizedPipeline realizedPipeline) {
        this.last = previous;
        this.createdBy = createdBy;
        this.context = this.last.context;
        this.ast = newAst;
        this.realizedPipeline = realizedPipeline;
    }

    public IncrementalBuildState append(@NonNull PipelineChange newCreatedBy, @NonNull PipelineDeclaration newAst, @NonNull RealizedPipeline newPipeline) throws IllegalArgumentException {
        if (newCreatedBy == null) {
            throw new NullPointerException("newCreatedBy is marked non-null but is null");
        }
        if (newAst == null) {
            throw new NullPointerException("newAst is marked non-null but is null");
        }
        if (newPipeline == null) {
            throw new NullPointerException("newPipeline is marked non-null but is null");
        }
        this.buildStateStream().forEach(ptr -> {
            if (ptr.getQuestion().equals(newCreatedBy.getQuestion()) && ptr.getQuestionSet().equals(newCreatedBy.getQuestionSet())) {
                throw new IllegalArgumentException("already answered - " + String.valueOf(ptr.getAnswer()));
            }
        });
        return new IncrementalBuildState(this, newCreatedBy, newAst, newPipeline);
    }

    public Iterator<IncrementalBuildState> buildStateIterator() {
        return new Iterator<IncrementalBuildState>(){
            IncrementalBuildState ptr;
            {
                this.ptr = IncrementalBuildState.this;
            }

            @Override
            public boolean hasNext() {
                return !this.ptr.isEmpty();
            }

            @Override
            public IncrementalBuildState next() {
                IncrementalBuildState toReturn = this.ptr;
                this.ptr = this.ptr.getLast();
                return toReturn;
            }
        };
    }

    public Stream<IncrementalBuildState> buildStateStream() {
        return Streams.stream(this.buildStateIterator());
    }

    public boolean isInvalid() {
        return this.buildStateStream().anyMatch(ibs -> ibs.realizedPipeline.hasFailures());
    }

    public RealizedStep getRealizedStep() throws IllegalStateException {
        Set endSteps = this.getRealizedPipeline().getEndSteps();
        List nonSinkEndSteps = endSteps.stream().filter(step -> !step.getStepType().equals(SinkConstructor.class)).collect(Collectors.toList());
        if (nonSinkEndSteps.size() == 1) {
            return (RealizedStep)nonSinkEndSteps.iterator().next();
        }
        if (nonSinkEndSteps.isEmpty() && !endSteps.isEmpty()) {
            RealizedStep dependsOn = null;
            for (RealizedStep sink : endSteps) {
                if (dependsOn == null) {
                    dependsOn = (RealizedStep)sink.getDependencies().get(0);
                    continue;
                }
                if (dependsOn == sink.getDependencies().get(0)) continue;
                dependsOn = null;
                break;
            }
            if (dependsOn != null) {
                return dependsOn;
            }
        }
        throw new IllegalStateException("can not return a single step - previous state had multiple outputs");
    }

    public Struct getInputStruct(ChangeLocation location) {
        Optional<PipelineDeclaration.Found> found = location.findOne(this);
        if (!found.isPresent()) {
            return Struct.EMPTY_STRUCT;
        }
        StepDeclaration targetStep = found.get().getStep();
        Optional<RealizedStep> realizedStep = this.getRealizedPipeline().getRealizedSteps().stream().filter(step -> targetStep.equals((Object)step.getAst())).findFirst();
        return realizedStep.map(step -> step.getProduces()).orElse(Struct.EMPTY_STRUCT);
    }

    public Struct getInputStruct(Question question) {
        return this.getInputStruct(question.getChangeLocation());
    }

    public boolean isEmpty() {
        return false;
    }

    public Optional<Answer> getAnswer(String questionSetId, String questionName) {
        return this.buildStateStream().filter(ptr -> ptr.getQuestionSet().getId().equals(questionSetId) && ptr.getQuestion().getName().equals(questionName)).findFirst().map(IncrementalBuildState::getAnswer);
    }

    public Optional<Answer> getAnswer(Question q) {
        return this.getAnswer(q.getQuestionSet().getId(), q.getName());
    }

    public <T> Optional<T> getResponse(String questionSetId, String questionName, Class<T> expectedResponseType) {
        return this.getAnswer(questionSetId, questionName).map(ans -> ans.getValueAs(expectedResponseType));
    }

    public <T> List<T> getAnswersTo(String questionSetId, String questionName, Class<T> expectedType) {
        return this.getAnswer(questionSetId, questionName).map(ans -> ans.getValuesAs(expectedType)).orElse(Collections.emptyList());
    }

    public <T> T getAnswerTo(String questionSetId, String questionName, Class<T> expectedType) {
        return this.getAnswer(questionSetId, questionName).map(answer -> answer.getValueAs(expectedType)).orElse(null);
    }

    public ResultOrProblems<RealizedPipeline> realizePipeline(PipelineDeclaration realizeThisAst) {
        return ResultOrProblems.of((Object)this.context.getExecutionContext().realize(realizeThisAst));
    }

    public Answer getAnswer() {
        return this.createdBy.getAnswer();
    }

    public QuestionSet getQuestionSet() {
        return this.createdBy.getQuestionSet();
    }

    public Question getQuestion() {
        return this.createdBy.getQuestion();
    }

    public Project getProject() {
        return this.context.executionContext.getProject();
    }

    public List<Answer> getAllAnswers() {
        return this.buildStateStream().map(IncrementalBuildState::getAnswer).collect(Collectors.toList());
    }

    public boolean isQuestionSetAnswered(String questionSetId) {
        return this.buildStateStream().anyMatch(ibs -> ibs.getQuestionSet().getId().equals(questionSetId));
    }

    public boolean wasAsked(String questionSetId, String questionName) {
        return this.getAnswer(questionSetId, questionName).isPresent();
    }

    public boolean lastAnswerWas(Object value) {
        return this.getQuestion().isSingleValueQuestion() && value.equals(this.getAnswer().getValueAs(Object.class));
    }

    public boolean isResponseGiven(String questionSetId, String questionName) {
        return this.getAnswer(questionSetId, questionName).map(answer -> !answer.isEmpty()).orElse(false);
    }

    public <T> boolean ifResponseGiven(String questionSetId, String questionName, Class<T> clazz, Consumer<T> callback) {
        Optional<Answer> answer = this.getAnswer(questionSetId, questionName);
        if (answer.isPresent() && !answer.get().isEmpty()) {
            callback.accept(answer.get().getValueAs(clazz));
            return true;
        }
        return false;
    }

    public BindingContext getBindingContext() {
        return this.getContext().getExecutionContext().getBindingContext();
    }

    public PipelineExecutor getPipelineExecutor() {
        return this.getContext().getExecutionContext().getPipelineExecutor();
    }

    public Survey getSurvey() {
        return this.context.survey;
    }

    public String toString() {
        return String.format("IncrementalBuildState(last-answer=%s)", this.createdBy.getAnswer());
    }

    public boolean isResponseGiven() {
        return !this.getAnswer().isEmpty() && !this.getQuestion().isHidden();
    }

    public IncrementalBuildState rewind() {
        IncrementalBuildState buildState = this;
        while (!buildState.isEmpty() && !buildState.isResponseGiven()) {
            buildState = buildState.getLast();
        }
        return buildState;
    }

    @Generated
    public Context getContext() {
        return this.context;
    }

    @Generated
    public IncrementalBuildState getLast() {
        return this.last;
    }

    @Generated
    public PipelineChange getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public PipelineDeclaration getAst() {
        return this.ast;
    }

    @Generated
    public RealizedPipeline getRealizedPipeline() {
        return this.realizedPipeline;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IncrementalBuildState)) {
            return false;
        }
        IncrementalBuildState other = (IncrementalBuildState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        IncrementalBuildState this$last = this.getLast();
        IncrementalBuildState other$last = other.getLast();
        if (this$last == null ? other$last != null : !((Object)this$last).equals(other$last)) {
            return false;
        }
        PipelineChange this$createdBy = this.getCreatedBy();
        PipelineChange other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        PipelineDeclaration this$ast = this.getAst();
        PipelineDeclaration other$ast = other.getAst();
        if (this$ast == null ? other$ast != null : !this$ast.equals(other$ast)) {
            return false;
        }
        RealizedPipeline this$realizedPipeline = this.getRealizedPipeline();
        RealizedPipeline other$realizedPipeline = other.getRealizedPipeline();
        return !(this$realizedPipeline == null ? other$realizedPipeline != null : !this$realizedPipeline.equals(other$realizedPipeline));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IncrementalBuildState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        IncrementalBuildState $last = this.getLast();
        result = result * 59 + ($last == null ? 43 : ((Object)$last).hashCode());
        PipelineChange $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        PipelineDeclaration $ast = this.getAst();
        result = result * 59 + ($ast == null ? 43 : $ast.hashCode());
        RealizedPipeline $realizedPipeline = this.getRealizedPipeline();
        result = result * 59 + ($realizedPipeline == null ? 43 : $realizedPipeline.hashCode());
        return result;
    }

    @Generated
    protected IncrementalBuildState(Context context, IncrementalBuildState last, PipelineChange createdBy, PipelineDeclaration ast, RealizedPipeline realizedPipeline) {
        this.context = context;
        this.last = last;
        this.createdBy = createdBy;
        this.ast = ast;
        this.realizedPipeline = realizedPipeline;
    }

    public static class Context {
        private final Survey survey;
        private final ExecutionContext executionContext;

        @Generated
        public Survey getSurvey() {
            return this.survey;
        }

        @Generated
        public ExecutionContext getExecutionContext() {
            return this.executionContext;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Survey this$survey = this.getSurvey();
            Survey other$survey = other.getSurvey();
            if (this$survey == null ? other$survey != null : !this$survey.equals(other$survey)) {
                return false;
            }
            ExecutionContext this$executionContext = this.getExecutionContext();
            ExecutionContext other$executionContext = other.getExecutionContext();
            return !(this$executionContext == null ? other$executionContext != null : !this$executionContext.equals(other$executionContext));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Context;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Survey $survey = this.getSurvey();
            result = result * 59 + ($survey == null ? 43 : $survey.hashCode());
            ExecutionContext $executionContext = this.getExecutionContext();
            result = result * 59 + ($executionContext == null ? 43 : $executionContext.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "IncrementalBuildState.Context(survey=" + String.valueOf(this.getSurvey()) + ", executionContext=" + String.valueOf(this.getExecutionContext()) + ")";
        }

        @Generated
        public Context(Survey survey, ExecutionContext executionContext) {
            this.survey = survey;
            this.executionContext = executionContext;
        }
    }
}

