/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard.bind;

import com.google.common.base.CaseFormat;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import nz.org.riskscape.ReflectionUtils;
import nz.org.riskscape.engine.bind.BaseBinder;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.wizard.Composite;
import nz.org.riskscape.wizard.CompositeField;
import nz.org.riskscape.wizard.Question;

public class CompositeBinder
extends BaseBinder {
    public static String fieldName(Field field) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, field.getName());
    }

    public static String fieldName(Question question) {
        String fullName = question.getName();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    public static Question fieldifyQuestion(Question originalQuestion, Class<?> clazz, String fieldName) {
        return CompositeBinder.fieldifyQuestion(originalQuestion, (Field)ReflectionUtils.getPublicField(clazz, (String)fieldName).get());
    }

    public static Question fieldifyQuestion(Question originalQuestion, Field field) {
        CompositeField compositeField = field.getAnnotation(CompositeField.class);
        Question subQuestion = originalQuestion.withType(field.getType()).withName(originalQuestion.getName() + "." + CompositeBinder.fieldName(field));
        if (!compositeField.tagKey().isEmpty()) {
            subQuestion = subQuestion.withAnnotations(compositeField.tagKey(), compositeField.tagValue());
        }
        return subQuestion;
    }

    public boolean canBind(Class<?> sourceType, Class<?> destinationType) {
        return destinationType.getAnnotation(Composite.class) != null && Map.class.isAssignableFrom(sourceType);
    }

    public <T> ResultOrProblems<T> bindValue(BindingContext context, Object value, Class<T> destinationType) {
        HashMap valueMap = new HashMap((Map)value);
        LinkedList<Problem> problems = new LinkedList<Problem>();
        Object compositeInstance = ReflectionUtils.newInstance(destinationType);
        List fields = ReflectionUtils.getAnnotatedFields(destinationType, CompositeField.class);
        for (Field field : fields) {
            Class<?> fieldType = field.getType();
            String mapKey = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, field.getName());
            Object unboundFieldValue = valueMap.remove(mapKey);
            if (unboundFieldValue == null) {
                problems.add(ParamProblems.get().wrongNumberGiven(mapKey, "1", 0));
                continue;
            }
            ResultOrProblems bound = context.bind(unboundFieldValue, fieldType);
            if (bound.hasErrors()) {
                problems.add(Problems.foundWith(CompositeField.class, (String)mapKey, (List)bound.getProblems()));
                continue;
            }
            bound = bound.drainWarnings(p -> problems.add(Problems.foundWith(CompositeField.class, (String)mapKey, (Problem[])new Problem[]{p})));
            ReflectionUtils.setField((Field)field, (Object)compositeInstance, (Object)bound.get());
        }
        if (!valueMap.isEmpty()) {
            problems.add(ParamProblems.get().ignored(valueMap.keySet().stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
        if (Problem.hasErrors(problems)) {
            return ResultOrProblems.failed(problems);
        }
        return ResultOrProblems.of((Object)compositeInstance, problems);
    }
}

