/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.Survey;
import nz.org.riskscape.wizard.WizardProblems;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.bld.InvalidAnswerException;
import nz.org.riskscape.wizard.bld.PipelineChange;
import nz.org.riskscape.wizard.bld.change.BadPipelineChangeException;
import nz.org.riskscape.wizard.survey2.QuestionTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WizardProcessor.class);
    private final ExecutionContext executionContext;
    private IncrementalBuildState buildState;
    private List<Problem> failures = Collections.emptyList();
    private QuestionTree questionTree = QuestionTree.empty();

    public WizardProcessor(ExecutionContext context, Survey survey) {
        this.executionContext = context;
        this.buildState = IncrementalBuildState.empty(new IncrementalBuildState.Context(survey, context));
    }

    public boolean isFailed() {
        return !this.failures.isEmpty();
    }

    public Project getProject() {
        return this.executionContext.getProject();
    }

    public Survey getSurvey() {
        return this.buildState.getSurvey();
    }

    public QuestionTree getQuestionTree() {
        if (this.questionTree.isComplete(this.buildState)) {
            this.questionTree = this.getSurvey().getQuestionTree(this.buildState);
        }
        return this.questionTree;
    }

    public boolean isDone() {
        return this.getNextQuestions().isEmpty();
    }

    public BindingContext getBindingContext() {
        return this.executionContext.getBindingContext();
    }

    public List<Question> getNextQuestions() {
        if (this.isFailed()) {
            throw new IllegalStateException("Can not get questions from a failed wizard processor");
        }
        List<Question> next = this.getQuestionTree().getNextQuestions(this.buildState);
        List<Question> withoutHidden = next.stream().filter(q -> !q.isHidden()).toList();
        if (!next.isEmpty() && withoutHidden.isEmpty()) {
            throw new AssertionError((Object)"All remaining questions are hidden!");
        }
        Question firstRequired = withoutHidden.stream().filter(Question::isRequired).findFirst().orElse(null);
        if (firstRequired != null) {
            return withoutHidden.subList(0, withoutHidden.indexOf(firstRequired) + 1);
        }
        return withoutHidden;
    }

    public boolean applyAnswer(Answer answer) {
        this.skipBefore(answer.getQuestion());
        try {
            PipelineChange pipelineChange = this.getSurvey().getPipelineChange(this.buildState, answer);
            this.makeChange(pipelineChange);
            return this.skipTrailingHiddenQuestions() && this.skipHiddenInNextQuestions();
        }
        catch (InvalidAnswerException | BadPipelineChangeException e) {
            this.failures = Arrays.asList(e.getProblem());
            return false;
        }
    }

    public boolean skip(Question skip) {
        this.skipInternal(skip);
        return this.skipTrailingHiddenQuestions();
    }

    public boolean skipAll(List<Question> toSkip) {
        for (Question question : toSkip) {
            if (this.skipInternal(question)) continue;
            return false;
        }
        return this.skipTrailingHiddenQuestions();
    }

    public void undo() {
        this.failures = Collections.emptyList();
        this.buildState = this.buildState.rewind().getLast().rewind();
        this.questionTree = QuestionTree.empty();
        this.getQuestionTree();
        this.skipTrailingHiddenQuestions();
        this.skipHiddenInNextQuestions();
    }

    private boolean makeChange(PipelineChange pipelineChange) {
        ResultOrProblems<IncrementalBuildState> changed = null;
        if (this.isFailed()) {
            throw new IllegalStateException("Can not change a failed wizard processor");
        }
        try {
            log.debug("Applying change {}", (Object)pipelineChange);
            changed = pipelineChange.make(this.buildState);
        }
        catch (BadPipelineChangeException ex) {
            this.failures = Collections.singletonList(ex.getProblem());
            this.buildState = this.buildState.append(pipelineChange, this.buildState.getAst(), this.buildState.getRealizedPipeline());
            return false;
        }
        if (changed.hasErrors()) {
            this.failures = changed.getProblems();
            this.buildState = this.buildState.append(pipelineChange, this.buildState.getAst(), this.buildState.getRealizedPipeline());
            return false;
        }
        this.buildState = (IncrementalBuildState)changed.get();
        if (this.buildState.getRealizedPipeline().hasFailures()) {
            this.failures = this.buildState.getRealizedPipeline().getFailures();
            return false;
        }
        this.failures = Collections.emptyList();
        return !this.isFailed();
    }

    private boolean skipHiddenInNextQuestions() {
        if (this.questionTree.isComplete(this.buildState)) {
            List<Question> initialHidden = this.getQuestionTree().getNextQuestions(this.buildState).stream().takeWhile(Question::isHidden).toList();
            return this.skipAll(initialHidden);
        }
        return true;
    }

    private boolean skipTrailingHiddenQuestions() {
        if (this.isFailed()) {
            return false;
        }
        List<Question> questionsAfter = this.questionTree.getNextQuestions(this.buildState);
        if (questionsAfter.isEmpty()) {
            return true;
        }
        List<Question> trailingHidden = questionsAfter.stream().takeWhile(Question::isHidden).toList();
        if (!trailingHidden.isEmpty()) {
            return this.skipAll(trailingHidden);
        }
        return true;
    }

    private boolean skipBefore(Question question) {
        List<Question> questions = this.questionTree.getNextQuestions(this.getBuildState());
        int questionIndex = questions.indexOf(question);
        if (questionIndex == -1) {
            throw new RuntimeException("Question not in list! " + String.valueOf(question) + " not among " + String.valueOf(questions));
        }
        List<Question> toBeSkipped = questions.subList(0, questionIndex);
        if (!toBeSkipped.isEmpty() && toBeSkipped.stream().allMatch(Question::isHidden)) {
            throw new AssertionError((Object)"Hidden questions should only be trailing, not preceding a question");
        }
        return this.skipAll(toBeSkipped);
    }

    private boolean skipInternal(Question skip) {
        boolean success = this.makeChange(this.buildState.getSurvey().skip(this.buildState, skip));
        if (!success) {
            this.composeFailures(WizardProblems.get().skipFailed(skip));
            return false;
        }
        return true;
    }

    private void composeFailures(Problem parent) {
        this.failures = Collections.singletonList(parent.withChildren(this.failures));
    }

    @Generated
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Generated
    public IncrementalBuildState getBuildState() {
        return this.buildState;
    }

    @Generated
    public List<Problem> getFailures() {
        return this.failures;
    }
}

