/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterProperties;
import nz.org.riskscape.engine.bind.ParameterProperty;
import nz.org.riskscape.engine.bind.ParameterTemplate;
import nz.org.riskscape.engine.i18n.TranslationContext;
import nz.org.riskscape.engine.model.ModelParameter;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;

public class WizardModelParameter
extends ModelParameter {
    private final Question question;
    private final IncrementalBuildState buildState;

    public WizardModelParameter(Parameter parameter, Question question, IncrementalBuildState buildState) {
        super(parameter, ParameterTemplate.EMPTY);
        this.question = question;
        this.buildState = buildState;
    }

    public WizardModelParameter(Question question, IncrementalBuildState buildState) {
        this(question.toParameter(), question, buildState);
    }

    public String getDescription(Locale locale) {
        return this.getMessage("title", locale).map(str -> str + " " + this.getMessage("description", locale).orElse("")).orElse("");
    }

    protected String toUserFriendlyString(String input) {
        return super.toUserFriendlyString(input).replaceAll("[\\.\\[\\]]+", " ").trim();
    }

    public String getLabel() {
        return this.toUserFriendlyString(this.getParameter().getName());
    }

    public List<ParameterTemplate.Choice> getChoices(Locale locale) {
        TranslationContext context = new TranslationContext(locale, this.question.getMessageSource());
        return this.question.getChoices(this.buildState).stream().map(c -> c.toParameter(context)).toList();
    }

    public Set<ParameterProperty> getProperties() {
        return ParameterProperties.infer(this.question.getParameterType());
    }

    public Optional<String> getMessage(String suffix, Locale locale) {
        return this.question.getMessage(suffix, locale);
    }

    @Generated
    public Question getQuestion() {
        return this.question;
    }
}

