/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.bind.ParameterSet;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.model.BaseModel2;
import nz.org.riskscape.engine.model.Model;
import nz.org.riskscape.engine.model.ModelFramework;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.wizard.ConfigParser;
import nz.org.riskscape.wizard.Survey;
import nz.org.riskscape.wizard.WizardProblems;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.model2.ModelSurvey2;

public class WizardModelFramework
implements ModelFramework {
    private final Engine engine;
    private final JavaParameterSet<Parameters> buildParameterSet = JavaParameterSet.fromBindingClass(Parameters.class);

    public WizardModelFramework(Engine engine) {
        this.engine = engine;
    }

    public String getId() {
        return "wizard";
    }

    public ResultOrProblems<Model> build(Project project, BoundParameters buildParameters) {
        ConfigParser parser = this.getConfigParser();
        HashMap unbound = new HashMap(buildParameters.getUnbound().size());
        unbound.putAll(buildParameters.getUnbound());
        unbound.remove("framework");
        unbound.remove("description");
        ResultOrProblems<IncrementalBuildState> result = this.loadConfig(parser, project.newExecutionContext(), unbound);
        return result.map(buildState -> new WizardModelImpl(buildParameters, this.getBoundParameters((IncrementalBuildState)buildState, buildParameters), (IncrementalBuildState)buildState));
    }

    private ConfigParser getConfigParser() {
        return new ConfigParser(this::surveyConstructor);
    }

    private BoundParameters getBoundParameters(IncrementalBuildState buildState, BoundParameters buildParameters) {
        Collection parameters = this.getConfigParser().getModelParameters(buildState).stream().map(mp -> mp.getParameter()).collect(Collectors.toList());
        return new ParameterSet(parameters).bind(buildState.getBindingContext(), Collections.emptyMap());
    }

    private ResultOrProblems<IncrementalBuildState> loadConfig(ConfigParser parser, ExecutionContext context, Map<String, List<?>> unbound) {
        try {
            return parser.loadConfig(context, unbound);
        }
        catch (RuntimeException e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
        }
    }

    private Survey surveyConstructor(String id) {
        MessageSource messages = this.engine.getMessages().newMessageSource(Survey.getSurveyMessageBundleName("survey2"));
        ModelSurvey2 newSurvey = new ModelSurvey2(messages);
        if (id.equals(newSurvey.getId())) {
            return newSurvey;
        }
        throw new RiskscapeException((Problems)GeneralProblems.get().noSuchObjectExists(id, Survey.class).withChildren(new Problems[]{WizardProblems.get().configError()}));
    }

    @Generated
    public JavaParameterSet<Parameters> getBuildParameterSet() {
        return this.buildParameterSet;
    }

    public static class Parameters {
    }

    private class WizardModelImpl
    extends BaseModel2 {
        private final IncrementalBuildState buildState;

        WizardModelImpl(BoundParameters frameworkParams, BoundParameters params, IncrementalBuildState buildState) {
            super((ModelFramework)WizardModelFramework.this, frameworkParams, params, WizardModelFramework.this.getConfigParser().getModelParameters(buildState));
            this.buildState = buildState;
        }

        public ResultOrProblems<RealizedPipeline> realize(ExecutionContext context) {
            return ResultOrProblems.of((Object)this.buildState.getRealizedPipeline().drainWarnings((Consumer)ProblemSink.DEVNULL));
        }

        @Generated
        public IncrementalBuildState getBuildState() {
            return this.buildState;
        }
    }
}

