/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.i18n.MutableMessageSource;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.EmptySurvey;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.QuestionSet;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.bld.PipelineChange;
import nz.org.riskscape.wizard.bld.change.NoChange;
import nz.org.riskscape.wizard.survey2.Phase;
import nz.org.riskscape.wizard.survey2.QuestionTree;

public interface Survey
extends Identified {
    public static final Survey EMPTY_SURVEY = new EmptySurvey("empty", (MessageSource)new MutableMessageSource());

    public static String getSurveyMessageBundleName(String surveyId) {
        return "survey-" + surveyId + "-messages";
    }

    public String getId();

    public MessageSource getMessageSource();

    default public int getVersion() {
        return 1;
    }

    default public boolean isQuestionSetReplayOrdered() {
        return false;
    }

    default public Optional<String> getAnalysisOutputStepName() {
        return Optional.empty();
    }

    public PipelineChange getPipelineChange(IncrementalBuildState var1, Answer var2);

    default public PipelineChange skip(IncrementalBuildState buildState, Question toSkip) {
        if (toSkip.isHidden()) {
            return this.getPipelineChange(buildState, Answer.hidden(toSkip));
        }
        if (!toSkip.isRequired()) {
            return new NoChange(Answer.skip(toSkip));
        }
        throw new IllegalArgumentException("can not skip question " + String.valueOf(toSkip));
    }

    public QuestionTree getQuestionTree(IncrementalBuildState var1);

    default public Question getNextQuestion(IncrementalBuildState buildState) {
        List<Question> questions = this.getQuestionTree(buildState).getNextQuestions(buildState);
        return questions.size() == 0 ? null : questions.get(0);
    }

    public boolean isFinished(IncrementalBuildState var1);

    public List<QuestionSet> getApplicableQuestionSets(IncrementalBuildState var1);

    default public List<Phase> getDefinedPhases() {
        return Collections.emptyList();
    }

    default public Optional<String> getDescription(Locale locale) {
        return Optional.of(this.getMessageSource().getMessage("survey.description", new Object[0], locale));
    }
}

