/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.ReflectionUtils;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.wizard.AskAs;
import nz.org.riskscape.wizard.Choice;
import nz.org.riskscape.wizard.Composite;
import nz.org.riskscape.wizard.CompositeField;
import nz.org.riskscape.wizard.QuestionSet;
import nz.org.riskscape.wizard.Survey;
import nz.org.riskscape.wizard.bind.CompositeBinder;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.bld.loc.AtLastChange;
import nz.org.riskscape.wizard.bld.loc.ChangeLocation;
import nz.org.riskscape.wizard.survey2.Choices;
import nz.org.riskscape.wizard.survey2.Phase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Question {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Question.class);
    public static final Hidden HIDDEN_VALUE = new Hidden();
    public static final I18nLookupFunction DEFAULT_I18N_LOOKUP = (q, suffix, locale) -> {
        String key = "question." + q.getQuestionSet().getName() + "." + q.getName() + "." + suffix;
        String i18nMsg = q.getMessageSource().getMessage(key, new Object[0], locale);
        if (i18nMsg == null) {
            log.info("No i18n message found for {}", (Object)key);
        }
        return Optional.ofNullable(i18nMsg);
    };
    public static final Range<Integer> ONE_REQUIRED = Range.singleton((Comparable)Integer.valueOf(1));
    public static final Range<Integer> ONE_AT_LEAST = Range.atLeast((Comparable)Integer.valueOf(1));
    public static final Range<Integer> OPTIONAL_ONE = Range.singleton((Comparable)Integer.valueOf(0)).span(ONE_REQUIRED);
    public static final Range<Integer> OPTIONAL_MANY = Range.atLeast((Comparable)Integer.valueOf(0));
    public static final String NO_VALUE = "";
    @NonNull
    private final String name;
    @NonNull
    private final Class<?> parameterType;
    private final Question dependsOn;
    @NonNull
    private final Predicate<IncrementalBuildState> shouldBeAsked;
    @NonNull
    private final Range<Integer> arity;
    @NonNull
    private final ImmutableMap<String, String> annotations;
    private final QuestionSet questionSet;
    private final I18nLookupFunction i18nLookup;
    private final Function<IncrementalBuildState, List<Choice>> choiceFunction;
    @NonNull
    private final ChangeLocation changeLocation;
    private final AskAs<?> askAs;

    public static boolean isComposite(Class<?> clazz) {
        return clazz.getDeclaredAnnotation(Composite.class) != null;
    }

    public static List<Question> getCompositeSubparts(Question question, Class<?> clazz) {
        if (Question.isComposite(clazz)) {
            return ReflectionUtils.getAnnotatedFields(clazz, CompositeField.class).stream().map(field -> CompositeBinder.fieldifyQuestion(question, field)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static String formatName(String name) {
        String onlyAlphas = name.replaceAll("[^a-zA-Z0-9]", " ");
        return onlyAlphas.substring(0, 1).toUpperCase() + onlyAlphas.substring(1);
    }

    public Question(String name, Class<?> parameterType) {
        this.name = name;
        this.parameterType = parameterType;
        this.annotations = ImmutableMap.of();
        this.arity = ONE_REQUIRED;
        this.dependsOn = null;
        this.shouldBeAsked = as -> true;
        this.questionSet = QuestionSet.UNASSIGNED;
        this.changeLocation = AtLastChange.INSTANCE;
        this.i18nLookup = DEFAULT_I18N_LOOKUP;
        this.choiceFunction = null;
        this.askAs = null;
    }

    private Question(MutableFields fields) {
        this.name = fields.name;
        this.parameterType = fields.parameterType;
        this.dependsOn = fields.dependsOn;
        this.shouldBeAsked = fields.shouldBeAsked;
        this.arity = fields.arity;
        this.annotations = ImmutableMap.copyOf(fields.annotations);
        this.questionSet = fields.questionSet;
        this.changeLocation = fields.changeLocation;
        this.i18nLookup = fields.i18nLookup;
        this.choiceFunction = fields.choiceFunction;
        this.askAs = fields.askAs;
    }

    private boolean shouldBeAsked(IncrementalBuildState buildState) {
        return this.shouldBeAsked.test(buildState);
    }

    public boolean readyToBeAsked(IncrementalBuildState buildState) {
        return (this.dependsOn == null || buildState.isResponseGiven(this.getQuestionSet().getId(), this.dependsOn.getName())) && this.shouldBeAsked(buildState);
    }

    public boolean isFollowing(Question question) {
        return this.dependsOn == null && question == IncrementalBuildState.EMPTY_QUESTION || this.dependsOn != null && this.dependsOn.equals(question);
    }

    private Question withArity(Range<Integer> arityRequired) {
        return this.clone(fields -> {
            fields.arity = arityRequired;
        });
    }

    public Question atLeastOne() {
        return this.withArity(ONE_AT_LEAST);
    }

    public Question requiredOne() {
        return this.withArity(ONE_REQUIRED);
    }

    public Question optionalOne() {
        return this.withArity(OPTIONAL_ONE);
    }

    public Question optionalMany() {
        return this.withArity(OPTIONAL_MANY);
    }

    public Question hidden() {
        return this.withArity(ONE_REQUIRED).withType(Hidden.class);
    }

    public Question parseAnnotations(String ... newAnnotationStrings) {
        Map<String, String> parsedAnnotations = Arrays.asList(newAnnotationStrings).stream().map(str -> str.trim()).filter(str -> !str.isEmpty()).map(str -> Arrays.asList(str.split("="))).map(list -> list.size() < 2 ? Arrays.asList((String)list.get(0), NO_VALUE) : list).collect(Collectors.toMap(list -> ((String)list.get(0)).trim(), list -> ((String)list.get(1)).trim()));
        return this.clone(fields -> {
            fields.annotations = parsedAnnotations;
        });
    }

    public Question withAnnotations(String k1, String v1) {
        return this.clone(fields -> {
            fields.annotations = ImmutableMap.of((Object)k1, (Object)v1);
        });
    }

    public Question withAnnotations(String k1, String v1, String k2, String v2) {
        return this.clone(fields -> {
            fields.annotations = ImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2);
        });
    }

    public Question withAnnotations(String k1, String v1, String k2, String v2, String k3, String v3) {
        return this.clone(fields -> {
            fields.annotations = ImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3, (Object)v3);
        });
    }

    public boolean hasAnnotation(String tag) {
        return this.annotations.keySet().contains((Object)tag);
    }

    public boolean hasAnnotationWithValue(String tag, String value) {
        return this.getAnnotation(tag).map(found -> found.equals(value)).orElse(false);
    }

    public Optional<String> getAnnotation(String tag) {
        return Optional.ofNullable((String)this.annotations.get((Object)tag));
    }

    public Question dependsOn(Question newDependsOn) {
        return this.clone(fields -> {
            fields.dependsOn = newDependsOn;
        });
    }

    public Question withType(Class<?> newParameterType) {
        return this.clone(fields -> {
            fields.parameterType = newParameterType;
        });
    }

    public Question askWhen(Predicate<IncrementalBuildState> conditionMet) {
        return this.clone(fields -> {
            fields.shouldBeAsked = conditionMet;
        });
    }

    public boolean isSingleValueQuestion() {
        return !this.arity.contains((Comparable)Integer.valueOf(2));
    }

    public boolean isRequired() {
        return !this.arity.contains((Comparable)Integer.valueOf(0));
    }

    public boolean isOptional() {
        return !this.isRequired();
    }

    public boolean isHidden() {
        return this.parameterType.equals(Hidden.class);
    }

    public boolean isRequired(IncrementalBuildState buildState) {
        return this.isRequired() && this.shouldBeAsked(buildState);
    }

    public void checkValidity(List<Object> values) {
        if (!this.arity.contains((Comparable)Integer.valueOf(values.size()))) {
            throw new IllegalArgumentException("wrong arity - " + values.size() + " not within " + String.valueOf(this.arity));
        }
        for (Object value : values) {
            if (this.parameterType.isInstance(value)) continue;
            throw new IllegalArgumentException("wrong type (not a " + String.valueOf(this.parameterType) + ") - " + String.valueOf(value));
        }
    }

    public void requireSingleValueQuestion() {
        if (!this.isSingleValueQuestion()) {
            throw new IllegalArgumentException("question is not a single answer question " + this.name);
        }
    }

    public String getId() {
        return String.format("%s.%s", this.getQuestionSet().getId(), this.name);
    }

    public Parameter toParameter() {
        int min = this.isRequired() ? 1 : 0;
        int max = this.isSingleValueQuestion() ? 1 : Integer.MAX_VALUE;
        return Parameter.range((String)this.getId(), this.parameterType, (int)min, (int)max);
    }

    public String toString() {
        return String.format("Question[name=%s, type=%s, arity=%s, dependsOn=%s]", this.name, this.parameterType.getSimpleName(), this.arity, this.dependsOn);
    }

    private Question clone(Consumer<MutableFields> mutator) {
        MutableFields fields = new MutableFields(this);
        mutator.accept(fields);
        return new Question(fields);
    }

    public QuestionSet getQuestionSet() {
        if (this.isUnassigned()) {
            throw new IllegalStateException("question " + this.name + " is unassigned");
        }
        return this.questionSet;
    }

    public Phase getPhase() {
        return this.getQuestionSet().getPhase();
    }

    public boolean isUnassigned() {
        return this.questionSet == QuestionSet.UNASSIGNED;
    }

    public Question inSet(QuestionSet newQuestionSet) {
        return this.clone(fields -> {
            fields.questionSet = newQuestionSet;
        });
    }

    public Question withName(String newName) {
        return this.clone(fields -> {
            fields.name = newName;
        });
    }

    public Question withI18nLookup(I18nLookupFunction newLookup) {
        return this.clone(fields -> {
            fields.i18nLookup = newLookup;
        });
    }

    public Question withI18nLookup(BiFunction<String, Locale, String> newLookup) {
        return this.clone(fields -> {
            fields.i18nLookup = (q, s, l) -> Optional.ofNullable((String)newLookup.apply(s, l));
        });
    }

    public Question atLocation(ChangeLocation newChangeLocation) {
        return this.clone(fields -> {
            fields.changeLocation = newChangeLocation;
        });
    }

    public Optional<String> getTitle(Locale locale) {
        return this.getMessage("title", locale);
    }

    public Optional<String> getDescription(Locale locale) {
        return this.getMessage("description", locale);
    }

    public Optional<String> getSummary(Locale locale) {
        return this.getMessage("summary", locale);
    }

    public Optional<String> getMessage(String suffix, Locale locale) {
        return this.i18nLookup.apply(this, suffix, locale);
    }

    public MessageSource getMessageSource() {
        return this.getSurvey().getMessageSource();
    }

    public Survey getSurvey() {
        return this.getQuestionSet().getSurvey();
    }

    public Question withChoices(Function<IncrementalBuildState, List<Choice>> newFunction) {
        return this.clone(fields -> {
            fields.choiceFunction = newFunction;
        });
    }

    public List<Choice> getChoices(IncrementalBuildState buildState) {
        if (this.choiceFunction != null) {
            return this.choiceFunction.apply(buildState);
        }
        return Choices.from(this, buildState);
    }

    public boolean isComposite() {
        return Question.isComposite(this.getParameterType());
    }

    public List<Question> getCompositeSubparts() {
        return Question.getCompositeSubparts(this, this.getParameterType());
    }

    public Optional<Question> getDependsOn() {
        return Optional.ofNullable(this.dependsOn);
    }

    public boolean isAskAs() {
        return this.askAs != null;
    }

    public <T> Question withAskAs(Class<T> newAskAsType, Function<T, String> newAskAsFunction) {
        return this.withAskAs(new AskAs<T>(newAskAsType, newAskAsFunction));
    }

    public Question withAskAs(AskAs<?> newAskAs) {
        return this.clone(fields -> {
            fields.askAs = newAskAs;
        });
    }

    public Optional<AskAs> getAskAs() {
        return Optional.ofNullable(this.askAs);
    }

    public Question getAskedAs() {
        if (this.isAskAs()) {
            return this.withType(this.askAs.getType()).withAskAs(null);
        }
        return this;
    }

    public Optional<Question> getSubQuestion(String fieldName) {
        return this.getCompositeSubparts().stream().filter(q -> CompositeBinder.fieldName(q).equals(fieldName)).findAny();
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public Class<?> getParameterType() {
        return this.parameterType;
    }

    @NonNull
    @Generated
    public Predicate<IncrementalBuildState> getShouldBeAsked() {
        return this.shouldBeAsked;
    }

    @NonNull
    @Generated
    public Range<Integer> getArity() {
        return this.arity;
    }

    @NonNull
    @Generated
    public ImmutableMap<String, String> getAnnotations() {
        return this.annotations;
    }

    @Generated
    public I18nLookupFunction getI18nLookup() {
        return this.i18nLookup;
    }

    @Generated
    public Function<IncrementalBuildState, List<Choice>> getChoiceFunction() {
        return this.choiceFunction;
    }

    @NonNull
    @Generated
    public ChangeLocation getChangeLocation() {
        return this.changeLocation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Question)) {
            return false;
        }
        Question other = (Question)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        QuestionSet this$questionSet = this.questionSet;
        QuestionSet other$questionSet = other.questionSet;
        return !(this$questionSet == null ? other$questionSet != null : !this$questionSet.equals(other$questionSet));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Question;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        QuestionSet $questionSet = this.questionSet;
        result = result * 59 + ($questionSet == null ? 43 : $questionSet.hashCode());
        return result;
    }

    @FunctionalInterface
    public static interface I18nLookupFunction {
        public Optional<String> apply(Question var1, String var2, Locale var3);
    }

    private static final class MutableFields {
        String message;
        String title;
        String name;
        Class<?> parameterType;
        Question dependsOn;
        Range<Integer> arity;
        Map<String, String> annotations;
        QuestionSet questionSet;
        Predicate<IncrementalBuildState> shouldBeAsked;
        ChangeLocation changeLocation;
        I18nLookupFunction i18nLookup;
        Function<IncrementalBuildState, List<Choice>> choiceFunction;
        AskAs<?> askAs;

        MutableFields(Question source) {
            this.name = source.name;
            this.parameterType = source.parameterType;
            this.dependsOn = source.dependsOn;
            this.arity = source.arity;
            this.annotations = new HashMap<String, String>((Map<String, String>)source.annotations);
            this.questionSet = source.questionSet;
            this.shouldBeAsked = source.shouldBeAsked;
            this.changeLocation = source.changeLocation;
            this.i18nLookup = source.i18nLookup;
            this.choiceFunction = source.choiceFunction;
            this.askAs = source.askAs;
        }
    }

    public static final class Hidden {
        private Hidden() {
        }

        public String toString() {
            return "<Hidden>";
        }
    }
}

